/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.data.ReviewerData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.web.NavBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultSPIUserUtils
implements SPIUserUtils {
    private final UserManager userManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final GlobalPermissionManager globalPermissionManager;
    public static final Function<FecruUser, UserData> USER_TO_USERDATA_FUNCTION = user -> user == null ? null : new UserData(user.getUsername(), user.getDisplayName(), NavBuilder.user(null, user.getUsername()), DefaultSPIUserUtils.getAvatarUrl(user));

    @Autowired
    public DefaultSPIUserUtils(UserManager userManager, EffectiveUserProvider effectiveUserProvider, GlobalPermissionManager globalPermissionManager) {
        this.userManager = userManager;
        this.effectiveUserProvider = effectiveUserProvider;
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    public boolean hasPermissionToAccess(RepositoryHandle repositoryHandle) {
        return this.effectiveUserProvider.isAdmin() || this.userManager.hasPermissionToAccess(this.effectiveUserProvider.getEffectivePrincipal(), repositoryHandle);
    }

    @Override
    public void requireUserHasPermissionToAccess(String repositoryName) {
        RepositoryHandle handle = this.getRepositoryHandle(repositoryName);
        if (handle == null) {
            if (this.effectiveUserProvider.isAdmin()) {
                throw new NotFoundException("Repository '" + repositoryName + "' not found.");
            }
            throw new NotPermittedException("No permission to access repository '" + repositoryName + "'");
        }
        if (!this.hasPermissionToAccess(handle)) {
            throw new NotPermittedException("No permission to access repository '" + repositoryName + "'");
        }
    }

    @Override
    public TimeZone getUserTimezone() {
        try {
            FecruUser user;
            if (!this.effectiveUserProvider.isAnonymous() && (user = this.userManager.getLicensedUser(this.effectiveUserProvider.getEffectivePrincipal().getUserName())) != null && !Strings.isNullOrEmpty((String)user.getUserProfile().getTimezone())) {
                return TimeZone.getTimeZone(user.getUserProfile().getTimezone());
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"Could not retrieve timezone for user", (Throwable)e2);
        }
        return AppConfig.getsConfig().getTimezone();
    }

    @Override
    public List<String> getNamesFromUsers(Collection<FecruUser> users) {
        return users.stream().map(FecruUser::getUsername).collect(Collectors.toList());
    }

    private RepositoryHandle getRepositoryHandle(String repositoryName) {
        return AppConfig.getsConfig().getRepositoryManager().getRepository(repositoryName);
    }

    @Override
    public FecruUser getUserFromPrincipal(Principal principal) {
        if (Principal.Anonymous.isAnon((Principal)principal) || Principal.SuperUser.isSuperUser((Principal)principal)) {
            return null;
        }
        return this.getUserByName(principal.getUserName());
    }

    @Override
    public FecruUser getUserByName(String name) {
        FecruUser u2 = this.userManager.getUser(name);
        if (u2 == null) {
            throw new IllegalArgumentException("No such user:" + name);
        }
        return u2;
    }

    @Override
    public Set<UserData> crucibleUsersToUserDataSet(Collection<FecruUser> users) {
        HashSet<UserData> names = new HashSet<UserData>();
        for (FecruUser u2 : users) {
            names.add(this.createUserData(u2));
        }
        return names;
    }

    @Override
    public Set<FecruUser> userDataCollectionToCrucibleUserSet(Collection<UserData> userData) {
        HashSet<FecruUser> users = new HashSet<FecruUser>();
        if (userData != null) {
            for (UserData d2 : userData) {
                users.add(this.getUser(d2));
            }
        }
        return users;
    }

    @Override
    public UserData createUserData(FecruUser user) {
        return USER_TO_USERDATA_FUNCTION.apply(user);
    }

    @Override
    public ReviewerData createReviewerData(FecruUser user, boolean completed) {
        return user == null ? null : new ReviewerData(user.getUsername(), user.getDisplayName(), DefaultSPIUserUtils.getAvatarUrl(user), completed);
    }

    private static String getAvatarUrl(FecruUser user) {
        return AvatarTypeInfo.getFullAvatarUrl(user, null);
    }

    @Override
    public ReviewerData createReviewerData(ReviewParticipant reviewer) throws IllegalArgumentException {
        if (reviewer == null || reviewer.getUser() == null || !reviewer.isReviewer()) {
            return null;
        }
        ReviewerData reviewerData = new ReviewerData(reviewer.getUser().getUsername(), reviewer.getUser().getDisplayName(), DefaultSPIUserUtils.getAvatarUrl(reviewer.getUser()), reviewer.isAllComplete());
        reviewerData.setCompletionStatusChangeDate(reviewer.getCompletionStatusChangeDateTime());
        reviewerData.setTimeSpent(reviewer.getTimeSpent());
        return reviewerData;
    }

    @Override
    public FecruUser getUser(UserData userData) {
        return this.getUserByName(userData.getUserName());
    }

    @Override
    public Iterable<String> getAllowedReviewers(Project p2) {
        Set<FecruUser> crucibleUsers = p2.getAllowedReviewers();
        if (crucibleUsers.isEmpty()) {
            return this.globalPermissionManager.getUsersWithPermission(GlobalPermissionType.CRUCIBLE_USER);
        }
        return crucibleUsers.stream().filter(user -> this.globalPermissionManager.hasPermission(user.getUsername(), GlobalPermissionType.CRUCIBLE_USER)).map(FecruUser::getUsername).collect(Collectors.toList());
    }
}

