/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.crucible.event.ReviewStateChangedEvent;
import com.atlassian.crucible.event.ReviewStateChangedEventImpl;
import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.CrucibleChangeSetsHelper;
import com.atlassian.crucible.explorers.CrucibleChangeSetsHelperFactory;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.ReviewServiceInternal;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.ActionData;
import com.atlassian.crucible.spi.data.Actions;
import com.atlassian.crucible.spi.data.AnchorData;
import com.atlassian.crucible.spi.data.ChangesetData;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.data.CommentStats;
import com.atlassian.crucible.spi.data.Comments;
import com.atlassian.crucible.spi.data.CrucibleRevisionData;
import com.atlassian.crucible.spi.data.CustomFieldData;
import com.atlassian.crucible.spi.data.CustomFieldDefData;
import com.atlassian.crucible.spi.data.CustomFilterData;
import com.atlassian.crucible.spi.data.DetailedReviewData;
import com.atlassian.crucible.spi.data.FisheyeReviewItemAttibutes;
import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.crucible.spi.data.GeneralCommentData;
import com.atlassian.crucible.spi.data.PatchData;
import com.atlassian.crucible.spi.data.PatchGroupData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.ReviewItemRevisionData;
import com.atlassian.crucible.spi.data.ReviewItems;
import com.atlassian.crucible.spi.data.ReviewerData;
import com.atlassian.crucible.spi.data.Reviewers;
import com.atlassian.crucible.spi.data.Transitions;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.data.VersionInfo;
import com.atlassian.crucible.spi.data.VersionedLineCommentData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.rpc.util.FileDataBuilder;
import com.atlassian.crucible.spi.rpc.util.MetricsUtil;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.crucible.spi.services.FileData;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.PatchAnchorFailedException;
import com.atlassian.crucible.spi.services.ReviewContentTooLargeException;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.fisheye.jira.issue.QueryContext;
import com.atlassian.fisheye.jira.issue.QueryContextImpl;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.renderer.RenderContext;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentReadStatus;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.CustomField;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.StateTransition;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.InlineCommentManager;
import com.cenqua.crucible.model.managers.LogItemBuilder;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SnippetManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.notification.ReviewReminderNotificationEvent;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.upload.UploadManager;
import com.cenqua.crucible.util.PatchAnchorHelper;
import com.cenqua.crucible.util.PatchReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.WithDisposer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;

@Component(value="reviewService")
@AvailableToPlugins(interfaces={ReviewService.class, ReviewServiceInternal.class})
@WithDisposer
public class DefaultReviewService
implements ReviewServiceInternal,
ReviewService {
    private final TxTemplate txTemplate;
    private final EffectiveUserProvider effectiveUserProvider;
    private final ProjectManager projectManager;
    private final UserManager userManager;
    private final UnreadManager unreadManager;
    private final SourceFactory sourceFactory;
    private final ContentManager contentManager;
    private final SnippetManager snippetManager;
    private final NotificationManager notificationManager;
    private final WikiRenderer renderer;
    private final SPIUtils spiUtils;
    private final SPIUserUtils spiUserUtils;
    private final ReviewManager reviewManager;
    private final JiraIssueService issueService;
    private final JiraServerService jiraServerService;
    private final PatchAnchorHelper patchAnchorHelper;
    private final CommitterUserMappingManager committerUserMappingManager;
    private final CommentManager commentManager;
    private final EventPublisher eventPublisher;
    private final CrucibleChangeSetsHelperFactory crucibleChangeSetsHelperFactory;
    private final ReviewLockManager reviewLockManager;
    private final LogItemManager logManager;
    private final PermissionManager permissionManager;
    private final PatchManager patchManager;

    @Autowired
    public DefaultReviewService(TxTemplate txTemplate, EffectiveUserProvider effectiveUserProvider, ProjectManager projectManager, UserManager userManager, UnreadManager unreadManager, SourceFactory sourceFactory, ContentManager contentManager, SnippetManager snippetManager, NotificationManager notificationManager, WikiRenderer renderer, SPIUtils spiUtils, SPIUserUtils spiUserUtils, ReviewManager reviewManager, JiraIssueService issueService, JiraServerService jiraServerService, CommitterUserMappingManager committerUserMappingManager, CommentManager commentManager, EventPublisher eventPublisher, CrucibleChangeSetsHelperFactory crucibleChangeSetsHelperFactory, ReviewLockManager reviewLockManager, LogItemManager logManager, PermissionManager permissionManager, PatchManager patchManager) {
        this.txTemplate = txTemplate;
        this.effectiveUserProvider = effectiveUserProvider;
        this.projectManager = projectManager;
        this.userManager = userManager;
        this.unreadManager = unreadManager;
        this.sourceFactory = sourceFactory;
        this.contentManager = contentManager;
        this.snippetManager = snippetManager;
        this.notificationManager = notificationManager;
        this.renderer = renderer;
        this.spiUtils = spiUtils;
        this.spiUserUtils = spiUserUtils;
        this.reviewManager = reviewManager;
        this.issueService = issueService;
        this.jiraServerService = jiraServerService;
        this.committerUserMappingManager = committerUserMappingManager;
        this.commentManager = commentManager;
        this.eventPublisher = eventPublisher;
        this.crucibleChangeSetsHelperFactory = crucibleChangeSetsHelperFactory;
        this.reviewLockManager = reviewLockManager;
        this.permissionManager = permissionManager;
        this.patchManager = patchManager;
        this.patchAnchorHelper = new PatchAnchorHelper();
        this.logManager = logManager;
    }

    private FecruUser getEffectiveUser() {
        return this.effectiveUserProvider.getEffectiveUser();
    }

    private Principal getEffectivePrincipal() {
        return this.effectiveUserProvider.getEffectivePrincipal();
    }

    public ReviewData createReview(final ReviewData reviewData) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.createReviewFromReviewData(reviewData);
                return DefaultReviewService.this.buildReviewData(review, false, false);
            }
        });
    }

    public DetailedReviewData createDetailedReview(final DetailedReviewData detailedReviewData) {
        return this.txTemplate.execute(new TxCallback<DetailedReviewData>(){

            @Override
            public DetailedReviewData doInTransaction(TransactionStatus status) throws DbException {
                Review review = DefaultReviewService.this.createReviewFromDetailedReviewData(detailedReviewData);
                return (DetailedReviewData)DefaultReviewService.this.buildReviewData(review, true, false);
            }
        });
    }

    public ReviewData createReviewFromPatch(ReviewData reviewData, String patch) throws ChangeSetContentTooLargeException {
        try {
            return this.createReviewFromPatch(reviewData, patch, null);
        }
        catch (PatchAnchorFailedException e2) {
            Logs.APP_LOG.error((Object)"should not throw PatchAnchorFailedException when not anchoring", (Throwable)e2);
            throw new RuntimeException("should not throw PatchAnchorFailedException when not anchoring", e2);
        }
    }

    public ReviewData createReviewFromPatch(final ReviewData reviewData, final String patch, final AnchorData anchorData) throws PatchAnchorFailedException, ChangeSetContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<ReviewData>(){

                @Override
                public ReviewData doInTransaction(TransactionStatus status) {
                    Review review = DefaultReviewService.this.createReviewFromReviewData(reviewData);
                    try {
                        UploadItem ui = UploadManager.createUploadItem(DefaultReviewService.this.getEffectiveUser(), review.getPermaId() + "-patch.txt", patch, "text/plain", "patch for review " + review.getPermaId());
                        Patch p2 = DefaultReviewService.this.patchManager.createPatch(review, ui);
                        PatchReviewCreationHelper.addAllPatchRevsToReview(p2, review, DefaultReviewService.this.getEffectiveUser(), DefaultReviewService.this.notificationManager);
                        DefaultReviewService.this.tryAnchorPatch(p2, anchorData);
                        return DefaultReviewService.this.buildReviewData(review, false, false);
                    }
                    catch (SourceException se) {
                        throw new RuntimeWrappedException(se);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeWrappedException(ioe);
                    }
                    catch (PatchException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                    catch (PatchAnchorFailedException e3) {
                        throw new RuntimeWrappedException(e3);
                    }
                    catch (ChangeSetContentTooLargeException e4) {
                        throw new RuntimeWrappedException(e4);
                    }
                    catch (ReviewContentTooLargeException e5) {
                        throw new RuntimeException("Unexpected ReviewContentTooLargeException, shouldn't happen for newly created review", e5);
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(PatchAnchorFailedException.class);
            rwe.rethrowCause(ChangeSetContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    private void tryAnchorPatch(Patch p2, AnchorData anchorData) throws DbException, IOException, SourceException, PatchAnchorFailedException {
        if (anchorData != null && anchorData.getAnchorRepository() != null) {
            if (anchorData.getAnchorPath() == null) {
                this.doSearchAndSetAnchor(p2, anchorData);
            } else {
                p2.setAnchored(true);
                p2.setAnchorPath(anchorData.getAnchorPath());
                p2.setAnchorSource(anchorData.getAnchorRepository());
                p2.setStripCount(anchorData.getStripCount());
            }
        }
    }

    private void doSearchAndSetAnchor(Patch p2, AnchorData anchorData) throws DbException, IOException, SourceException, PatchAnchorFailedException {
        Source source = this.tryGetSource(anchorData.getAnchorRepository());
        if (!(source instanceof RepositorySource)) {
            throw new PatchAnchorFailedException(String.format("Incorrect repository type [%s] for patch anchoring. Patches can only be anchored to Fisheye repositories.", source.getClass().getSimpleName()), anchorData);
        }
        PatchSource patchSource = (PatchSource)this.tryGetSource("PATCH:" + p2.getId());
        PatchAnchorHelper.PatchAnchorResult anchorResult = this.patchAnchorHelper.anchorPatch(this.contentManager, p2, patchSource, source);
        if (!anchorResult.worked) {
            throw new PatchAnchorFailedException(String.format("Unable to anchor patch [%s] to repository [%s]: " + anchorResult.errorMsg, p2.getUploadItem().getOriginalName(), anchorData.getAnchorRepository()), anchorData);
        }
    }

    public ReviewData createSnippetReview(final ReviewData reviewData, final String snippet, final String filename) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.createSnippetFromReviewData(reviewData);
                try {
                    String newFilename = StringUtils.isEmpty((String)filename) ? "filename.txt" : (filename.indexOf(46) == -1 ? "filename." + filename : filename);
                    review = DefaultReviewService.this.snippetManager.addFileToSnippet(review, newFilename, snippet, "text/plain", DefaultReviewService.this.contentManager, null);
                    return DefaultReviewService.this.buildReviewData(review, false, false);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
    }

    public ReviewData createReviewFromChangeSets(final ReviewData reviewData, final String repository, final List<ChangesetData> changesets) throws ChangeSetContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<ReviewData>(){

                @Override
                public ReviewData doInTransaction(TransactionStatus status) {
                    try {
                        final List<CrucibleChangeSet> changeSets = DefaultReviewService.this.createCCSHelperForChangeSets(changesets, repository).createChangeSets(true);
                        final Review review = DefaultReviewService.this.createReviewFromReviewData(reviewData);
                        return DefaultReviewService.this.reviewLockManager.withReviewLock(review, new Callable<ReviewData>(){

                            @Override
                            public ReviewData call() throws Exception {
                                Source s2 = DefaultReviewService.this.tryGetSource(repository);
                                ReviewCreationHelper ch = DefaultReviewService.this.makeReviewCreationHelper(s2, review);
                                String title = null;
                                FecruUser author = null;
                                ReviewCreationHelper.MetadataFilter filter = changesets.size() == 1 ? ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL : ReviewCreationHelper.MetadataFilter.ALL;
                                for (CrucibleChangeSet cs : changeSets) {
                                    ch.addRevisions(DefaultReviewService.this.getEffectiveUser(), cs.getRevisions(), Review.AttachMethod.ITERATION, null, filter);
                                    if (StringUtils.isBlank(title) && !StringUtils.isBlank((String)cs.getComment())) {
                                        title = ReviewUtil.extractReviewTitle(cs.getComment());
                                    }
                                    if (!(s2 instanceof RepositorySource) || author != null || reviewData.getAuthor() != null) continue;
                                    author = DefaultReviewService.this.committerUserMappingManager.getUserForCommitter(s2.getName(), cs.getAuthor());
                                }
                                if (!StringUtils.isBlank(title) && reviewData.getName() == null) {
                                    review.setName(title);
                                }
                                if (author != null && reviewData.getAuthor() == null) {
                                    review.setAuthor(author);
                                }
                                return DefaultReviewService.this.buildReviewData(review, false, false);
                            }
                        });
                    }
                    catch (SourceException se) {
                        throw new RuntimeException(se);
                    }
                    catch (ChangeSetContentTooLargeException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                    catch (ReviewContentTooLargeException e3) {
                        throw new RuntimeException("Unexpected ReviewContentTooLargeException, shouldn't happen for newly created review");
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ChangeSetContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    public void checkChangesetSizeAcceptable(List<ChangesetData> changesets, String repository) throws ChangeSetContentTooLargeException {
        try {
            this.createCCSHelperForChangeSets(changesets, repository).checkSize();
        }
        catch (SourceException e2) {
            throw new RuntimeException(e2);
        }
    }

    private CrucibleChangeSetsHelper createCCSHelperForChangeSets(List<ChangesetData> changesets, String repository) throws ChangeSetContentTooLargeException, SourceException {
        CrucibleChangeSetsHelper crucibleChangeSetsHelper = this.createCCSHelper();
        for (ChangesetData changeset : changesets) {
            crucibleChangeSetsHelper.addCrucibleChangeSet(ChangeSetPair.newInstance(repository, changeset.getId()));
        }
        return crucibleChangeSetsHelper;
    }

    private CrucibleChangeSetsHelper createCCSHelper() {
        return this.crucibleChangeSetsHelperFactory.createCrucibleChangeSetsHelper();
    }

    private void ensureNotNull(FecruUser user, String participantType) {
        if (user == null) {
            throw new IllegalArgumentException("Review " + participantType + " has to be specified.");
        }
    }

    private Review createReviewFromReviewData(ReviewData reviewData) {
        String jiraIssueKey;
        Project project = this.projectManager.getProjectByKey(reviewData.getProjectKey());
        if (project == null) {
            throw new IllegalArgumentException("No project found with key " + reviewData.getProjectKey());
        }
        this.requirePermission(UserActionManager.ACTION_CREATE, project);
        FecruUser creator = reviewData.getCreator() != null ? this.getLicensedUser(reviewData.getCreator().getUserName()) : this.getEffectiveUser();
        this.ensureNotNull(creator, "creator");
        Review review = this.reviewManager.createReviewWithDefaults(this.projectManager, project, reviewData.getName(), creator);
        if (!StringUtils.isBlank((String)reviewData.getDescription())) {
            review.setDescription(reviewData.getDescription());
        }
        FecruUser author = reviewData.getAuthor() != null ? this.getLicensedUser(reviewData.getAuthor().getUserName()) : creator;
        this.ensureNotNull(author, "author");
        review.setAuthor(author);
        if (project.isModeratorEnabled() && reviewData.getModerator() != null) {
            FecruUser moderator = this.getLicensedUser(reviewData.getModerator().getUserName());
            review.setModerator(moderator);
        }
        if (reviewData.getParentReview() != null) {
            String parentId = reviewData.getParentReview().getId();
            Review parentReview = this.reviewManager.getReviewByPermaId(parentId);
            if (parentReview == null || !this.hasReviewPermission(UserActionManager.ACTION_VIEW, parentReview)) {
                throw new IllegalArgumentException("Unknown parent review specified: " + parentId);
            }
            review.setParentReview(parentReview);
        }
        review.setCreator(creator);
        if (reviewData.isAllowReviewersToJoin() != null) {
            review.setAllowReviewerToJoin(reviewData.isAllowReviewersToJoin());
        }
        if ((jiraIssueKey = reviewData.getJiraIssueKey() != null ? reviewData.getJiraIssueKey() : review.getBestSuggestedJiraIssueKey()) != null) {
            review.setJiraIssueKey(jiraIssueKey);
        }
        if (reviewData.getDueDate() != null) {
            review.setDueDate(reviewData.getDueDate());
        }
        if (reviewData.getReminderDate() != null) {
            review.setReminderDate(reviewData.getReminderDate());
        }
        return review;
    }

    private Review createSnippetFromReviewData(ReviewData reviewData) {
        Project project = this.projectManager.getProjectByKey(reviewData.getProjectKey());
        if (project == null) {
            throw new IllegalArgumentException("No project found with key " + reviewData.getProjectKey());
        }
        this.requirePermission(UserActionManager.ACTION_CREATE, project);
        FecruUser creator = reviewData.getCreator() != null ? this.getLicensedUser(reviewData.getCreator().getUserName()) : this.getEffectiveUser();
        this.ensureNotNull(creator, "creator");
        Review review = this.reviewManager.createSnippetReviewWithDefaults(this.projectManager, project, reviewData.getName(), creator);
        review.setDescription(reviewData.getDescription());
        review.setAuthor(creator);
        review.setCreator(creator);
        review.setDefaultSource("UPLOAD:");
        review.setName(reviewData.getName());
        review.setSummary(reviewData.getSummary());
        return review;
    }

    private Review createReviewFromDetailedReviewData(DetailedReviewData detailedReviewData) throws DbException {
        Review review = this.createReviewFromReviewData((ReviewData)detailedReviewData);
        if (detailedReviewData.getReviewers() != null) {
            for (ReviewerData reviewer : detailedReviewData.getReviewers().reviewer) {
                this.reviewManager.addReviewer(review, this.getLicensedUser(reviewer.getUserName()));
            }
        }
        return review;
    }

    private Review getRequiredReview(PermId<ReviewData> id) throws PermaIdFormatException {
        Review review = this.reviewManager.getReviewByPermaId(id.getId());
        if (review == null) {
            throw new NotFoundException("No review exists with permId '" + id.getId() + "'", id);
        }
        return review;
    }

    private Comment getRequiredComment(PermId<CommentData> id) {
        Comment comment = this.commentManager.getById(this.getCommentId(id));
        if (comment == null || comment.isDeleted()) {
            throw new NotFoundException(String.format("No comment exists with permId '%s'", id.getId()), id);
        }
        return comment;
    }

    private FileRevisionExtraInfo getRequiredFileRevisionExtraInfo(PermId<ReviewItemData> id) {
        FileRevisionExtraInfo frx = FRXManager.getByPermaId(id.getId());
        if (frx == null) {
            throw new NotFoundException(String.format("No file revision info exists with permId '%s'", id.getId()), id);
        }
        return frx;
    }

    public ReviewData addChangesetsToReview(final PermId<ReviewData> id, final String repository, final List<ChangesetData> changesets) throws ChangeSetContentTooLargeException, ReviewContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<ReviewData>(){

                @Override
                public ReviewData doInTransaction(TransactionStatus status) throws SourceException {
                    final Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                    return DefaultReviewService.this.reviewLockManager.withReviewLock(review, new Callable<ReviewData>(){

                        @Override
                        public ReviewData call() throws SourceException {
                            DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
                            ReviewData reviewData = DefaultReviewService.this.buildReviewData(review, false, false);
                            Source s2 = DefaultReviewService.this.tryGetSource(repository);
                            ReviewCreationHelper ch = DefaultReviewService.this.makeReviewCreationHelper(s2, review);
                            try {
                                List<CrucibleChangeSet> changeSets = DefaultReviewService.this.createCCSHelperForChangeSets(changesets, repository).createChangeSets(true);
                                for (CrucibleChangeSet cs : changeSets) {
                                    ch.addRevisions(DefaultReviewService.this.getEffectiveUser(), cs.getRevisions(), Review.AttachMethod.ITERATION, null, changeSets.size() == 1 ? ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL : ReviewCreationHelper.MetadataFilter.ALL);
                                }
                                return reviewData;
                            }
                            catch (ChangeSetContentTooLargeException e2) {
                                throw new RuntimeWrappedException(e2);
                            }
                            catch (ReviewContentTooLargeException e3) {
                                throw new RuntimeWrappedException(e3);
                            }
                        }
                    });
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ChangeSetContentTooLargeException.class);
            rwe.rethrowCause(ReviewContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    @Transactional
    public ReviewData addPatchToReview(PermId<ReviewData> id, String patch) throws ReviewContentTooLargeException, ChangeSetContentTooLargeException {
        try {
            return this.addPatchToReviewImpl(id, patch, null, null);
        }
        catch (PatchAnchorFailedException e2) {
            Logs.APP_LOG.error((Object)"should not throw PatchAnchorFailedException when not anchoring", (Throwable)e2);
            throw new RuntimeException("should not throw PatchAnchorFailedException when not anchoring", e2);
        }
    }

    @Transactional
    public ReviewData addPatchToReview(PermId<ReviewData> id, String patch, AnchorData anchorData) throws PatchAnchorFailedException {
        return this.addPatchToReviewImpl(id, patch, anchorData, null);
    }

    @Transactional
    public ReviewData addPatchToReview(PermId<ReviewData> id, String patch, AnchorData anchorData, String source) throws PatchAnchorFailedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException {
        return this.addPatchToReviewImpl(id, patch, anchorData, source);
    }

    private String generatePatchName(Review review) {
        int numPatches = this.patchManager.findReviewPatches(review).size();
        return String.format("%s-patch-%d.txt", review.getPermaId(), numPatches);
    }

    private ReviewData addPatchToReviewImpl(PermId<ReviewData> id, String patch, AnchorData anchorData, String source) throws PatchAnchorFailedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException {
        try {
            PatchData patchData = this.uploadPatchToReview(id, patch);
            this.anchorPatch(patchData.getId(), anchorData);
            this.completeUploadPatchToReview(id, patchData.getId(), source, true);
            return this.getReviewData(id, false);
        }
        catch (IOException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    @Override
    @Transactional
    public PatchData uploadPatchToReview(PermId<ReviewData> id, String content) throws IOException {
        Review review = this.getReviewCheckOpenReviewPermissionAndRoomForNewContent(id);
        String name = this.generatePatchName(review);
        FileData uploadData = FileDataBuilder.create(content).name(name).description(name).build();
        return this.uploadPatchToReview(id, uploadData);
    }

    @Override
    @Transactional
    public PatchData uploadPatchToReview(PermId<ReviewData> id, FileData uploadData) throws IOException {
        try {
            Review review = this.getReviewCheckOpenReviewPermissionAndRoomForNewContent(id);
            UploadItem ui = UploadManager.createUploadItem(this.getEffectiveUser(), uploadData);
            Patch patch = this.patchManager.createPatch(review, ui);
            if (patch.getFileRevisions().size() == 0) {
                throw new IllegalArgumentException("No files found in patch. If it is not a valid patch file, upload it as an attachment.");
            }
            return new PatchData(patch.getId().intValue(), patch.getUploadItem().getOriginalName(), patch.getUploadItem().getCreateDate(), null, null);
        }
        catch (PatchException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    @Override
    @Transactional
    public void anchorPatch(int patchId, AnchorData anchorData) throws IOException, PatchAnchorFailedException {
        try {
            this.tryAnchorPatch(this.patchManager.getPatchById(patchId), anchorData);
        }
        catch (SourceException e2) {
            Throwables.propagate((Throwable)e2);
        }
    }

    @Override
    @Transactional
    public void completeUploadPatchToReview(PermId<ReviewData> reviewId, int patchId, String source, boolean addAsIteration) {
        try {
            Patch patch = this.patchManager.getPatchById(patchId);
            if (addAsIteration && !Strings.isNullOrEmpty((String)source)) {
                Source patchSource = this.tryGetSource(source);
                if (patchSource instanceof PatchSource && patchSource.isAvailable()) {
                    this.patchManager.transferPatchToExistingSource(patch, (PatchSource)patchSource);
                } else {
                    throw new IllegalArgumentException("Cannot append patch to a non patch source.");
                }
            }
            PatchReviewCreationHelper.addAllPatchRevsToReview(patch, this.getRequiredReview(reviewId), this.getEffectiveUser(), this.notificationManager);
        }
        catch (PatchException | SourceException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    @Transactional
    public List<PatchGroupData> removePatchFromReview(PermId<ReviewData> id, int patchId) {
        Review review = this.getRequiredReview(id);
        this.requireReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
        Patch patch = this.patchManager.getPatchById(patchId);
        Preconditions.checkArgument((patch != null && patch.isAvailableForAdding() && Objects.equals(patch.getReview().getId(), review.getId()) ? 1 : 0) != 0, (String)"No patch with id %s found in review %s", (Object[])new Object[]{patchId, id});
        PatchSource patchSource = this.sourceFactory.getPatchSource(patchId);
        List<CrucibleRevision> patchRevisions = patch.getFileRevisions();
        patchRevisions.stream().filter(rev -> !PatchRevision.fromCrucibleRevision((CrucibleRevision)rev).isFrom).forEach(rev -> {
            FileRevisionExtraInfo frx = review.getFRX((CrucibleRevision)rev);
            if (frx != null) {
                this.patchManager.removePatchRevision(patchSource, frx, (CrucibleRevision)rev);
            }
        });
        patch.setAvailableForAdding(false);
        return this.getReviewPatches(id);
    }

    public DetailedReviewData addReviewRevisions(final PermId<ReviewData> reviewId, final List<CrucibleRevisionData> reviewItems) throws IllegalArgumentException, NotFoundException, NotPermittedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<DetailedReviewData>(){

                @Override
                public DetailedReviewData doInTransaction(TransactionStatus status) throws SourceException {
                    try {
                        if (null == reviewItems) {
                            throw new IllegalArgumentException("Null reviewItems");
                        }
                        DefaultReviewService.this.ensureChangeSetSizeAcceptable(reviewItems.size());
                        final Review review = DefaultReviewService.this.getReviewCheckOpenReviewPermissionAndRoomForNewContent((PermId<ReviewData>)reviewId);
                        return DefaultReviewService.this.reviewLockManager.withReviewLock(review, new Callable<DetailedReviewData>(){

                            @Override
                            public DetailedReviewData call() throws Exception {
                                for (CrucibleRevisionData revision : reviewItems) {
                                    Source s2 = DefaultReviewService.this.tryGetSource(revision.getSource());
                                    ReviewCreationHelper helper = DefaultReviewService.this.makeReviewCreationHelper(s2, review);
                                    for (String revStr : revision.getRevisions()) {
                                        CrucibleRevision fileRevision = DefaultReviewService.this.getFileRevision(s2, revision.getPath(), revStr);
                                        if (fileRevision != null) {
                                            helper.addRevisions(DefaultReviewService.this.getEffectiveUser(), Arrays.asList(fileRevision), Review.AttachMethod.SINGLE_REVISION, null, ReviewCreationHelper.MetadataFilter.NONE);
                                            continue;
                                        }
                                        throw new IllegalArgumentException(revision.getPath() + " at revision " + revStr + " does not exist in source " + revision.getSource());
                                    }
                                }
                                return (DetailedReviewData)DefaultReviewService.this.buildReviewData(review, true, true);
                            }
                        });
                    }
                    catch (ChangeSetContentTooLargeException | ReviewContentTooLargeException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ChangeSetContentTooLargeException.class);
            rwe.rethrowCause(ReviewContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    private Review getReviewCheckOpenReviewPermissionAndRoomForNewContent(PermId<ReviewData> reviewId) throws ReviewContentTooLargeException {
        Review review = this.getRequiredReview(reviewId);
        this.requireOpenReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
        review.checkRoomForMoreContentExists();
        return review;
    }

    public FisheyeReviewItemData addReviewItem(final PermId<ReviewData> reviewId, final FisheyeReviewItemData reviewItem) throws IllegalArgumentException, NotFoundException, NotPermittedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<FisheyeReviewItemData>(){

                @Override
                public FisheyeReviewItemData doInTransaction(TransactionStatus status) throws SourceException {
                    if (reviewItem.getExpandedRevisions() == null) {
                        throw new IllegalArgumentException("the given review item is not valid. There are no revisions.");
                    }
                    try {
                        FileRevisionExtraInfo frx;
                        DefaultReviewService.this.ensureChangeSetSizeAcceptable(reviewItem.getExpandedRevisions().size());
                        Review review = DefaultReviewService.this.getReviewCheckOpenReviewPermissionAndRoomForNewContent((PermId<ReviewData>)reviewId);
                        Source s2 = DefaultReviewService.this.tryGetSource(reviewItem.getRepositoryName());
                        ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>(reviewItem.getExpandedRevisions().size());
                        for (ReviewItemRevisionData revision : reviewItem.getExpandedRevisions()) {
                            revisions.add(DefaultReviewService.this.getFileRevision(s2, revision.getPath(), revision.getRevision()));
                        }
                        List<Pair<Path, List<CrucibleRevision>>> groupedRevisions = s2.groupFileRevisions(revisions);
                        if (groupedRevisions.size() == 1) {
                            List<CrucibleRevision> sortedRevisions = groupedRevisions.get(0).getSecond();
                            frx = FRXManager.createAndAddFRX(sortedRevisions.get(0), review);
                            for (int i2 = 1; i2 < sortedRevisions.size(); ++i2) {
                                CrucibleRevision fr = sortedRevisions.get(i2);
                                frx.addRevision(s2.getInsertIndex(frx.getCrucibleRevisions(), fr, null), fr);
                            }
                        } else {
                            throw new IllegalArgumentException("the given review item is not valid.");
                        }
                        return DefaultReviewService.this.buildReviewItemData(frx, null);
                    }
                    catch (ChangeSetContentTooLargeException | ReviewContentTooLargeException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ChangeSetContentTooLargeException.class);
            rwe.rethrowCause(ReviewContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    private void ensureChangeSetSizeAcceptable(int size) throws ChangeSetContentTooLargeException {
        int limit = CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT;
        if (size > limit) {
            throw new ChangeSetContentTooLargeException(limit);
        }
    }

    private Source tryGetSource(String name) {
        Source s2 = this.sourceFactory.getSource(name, this.getEffectivePrincipal());
        if (s2 == null || !s2.isAvailable()) {
            throw new IllegalArgumentException("the given source " + name + " is not available", s2 == null ? null : s2.getException());
        }
        return s2;
    }

    public FisheyeReviewItemData setReviewItem(final PermId<ReviewData> reviewId, final PermId<ReviewItemData> itemId, final FisheyeReviewItemData reviewItem) throws IllegalArgumentException, NotFoundException, NotPermittedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<FisheyeReviewItemData>(){

                @Override
                public FisheyeReviewItemData doInTransaction(TransactionStatus status) throws SourceException {
                    if (null == reviewItem) {
                        throw new IllegalArgumentException("The given review item is null.");
                    }
                    Collection revisionDataList = reviewItem.getExpandedRevisions();
                    if (revisionDataList == null) {
                        throw new IllegalArgumentException("The given review item is not valid. There are no revisions.");
                    }
                    try {
                        FileRevisionExtraInfo frx;
                        DefaultReviewService.this.ensureChangeSetSizeAcceptable(revisionDataList.size());
                        Review review = DefaultReviewService.this.getReviewCheckOpenReviewPermissionAndRoomForNewContent((PermId<ReviewData>)reviewId);
                        Source s2 = DefaultReviewService.this.tryGetSource(reviewItem.getRepositoryName());
                        ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>(revisionDataList.size());
                        for (ReviewItemRevisionData revision : reviewItem.getExpandedRevisions()) {
                            revisions.add(DefaultReviewService.this.getFileRevision(s2, revision.getPath(), revision.getRevision()));
                        }
                        List<Pair<Path, List<CrucibleRevision>>> groupedRevisions = s2.groupFileRevisions(revisions);
                        if (groupedRevisions.size() == 1) {
                            List<CrucibleRevision> sortedRevisions = groupedRevisions.get(0).getSecond();
                            frx = FRXManager.getByPermaId(itemId.getId());
                            if (frx == null) {
                                throw new NotFoundException("FRX with id '" + itemId.getId() + "' not found.");
                            }
                            List<CrucibleRevision> revisionsToRemove = frx.getCrucibleRevisions();
                            for (CrucibleRevision fr : sortedRevisions) {
                                revisionsToRemove.remove(fr);
                                frx.addRevision(s2.getInsertIndex(frx.getCrucibleRevisions(), fr, null), fr);
                            }
                            for (CrucibleRevision oldFr : revisionsToRemove) {
                                frx.removeRevision(oldFr);
                            }
                        } else {
                            throw new IllegalArgumentException("the given review item is not valid.");
                        }
                        frx.setShowAsDiff(reviewItem.isShowAsDiff());
                        return DefaultReviewService.this.buildReviewItemData(frx, null);
                    }
                    catch (ChangeSetContentTooLargeException | ReviewContentTooLargeException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ChangeSetContentTooLargeException.class);
            rwe.rethrowCause(ReviewContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    public ReviewItemData addReviewItemRevisions(final PermId<ReviewData> reviewId, final PermId<ReviewItemData> itemId, final List<String> revisions) throws IllegalArgumentException, NotFoundException, NotPermittedException, ReviewContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<ReviewItemData>(){

                @Override
                public ReviewItemData doInTransaction(TransactionStatus status) throws SourceException {
                    try {
                        final Review review = DefaultReviewService.this.getReviewCheckOpenReviewPermissionAndRoomForNewContent((PermId<ReviewData>)reviewId);
                        return DefaultReviewService.this.reviewLockManager.withReviewLock(review, new Callable<ReviewItemData>(){

                            @Override
                            public ReviewItemData call() throws Exception {
                                FileRevisionExtraInfo frx = DefaultReviewService.this.getRequiredFileRevisionExtraInfo((PermId<ReviewItemData>)itemId);
                                CrucibleRevision crucibleRevision = frx.getFileRevision();
                                Source s2 = DefaultReviewService.this.tryGetSource(crucibleRevision.getSourceName());
                                ReviewCreationHelper rch = DefaultReviewService.this.makeReviewCreationHelper(s2, review);
                                for (String revStr : revisions) {
                                    CrucibleRevision cruFileRevision = DefaultReviewService.this.getFileRevision(s2, crucibleRevision.getPath(), revStr);
                                    if (cruFileRevision != null) {
                                        rch.addRevisions(DefaultReviewService.this.getEffectiveUser(), Arrays.asList(cruFileRevision), Review.AttachMethod.SINGLE_REVISION, null, ReviewCreationHelper.MetadataFilter.NONE);
                                        continue;
                                    }
                                    throw new IllegalArgumentException("the revision " + revStr + " for path " + crucibleRevision.getPath() + " does not exist in source " + crucibleRevision.getSourceName());
                                }
                                return DefaultReviewService.this.buildReviewItemData(frx, null);
                            }
                        });
                    }
                    catch (ReviewContentTooLargeException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ReviewContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    private ReviewCreationHelper makeReviewCreationHelper(Source s2, Review review) {
        try {
            return new ReviewCreationHelper(s2, review, this.contentManager, this.notificationManager, this.spiUtils, this.commentManager, this.eventPublisher);
        }
        catch (SourceException e2) {
            throw new IllegalArgumentException("the given source " + s2.getName() + " is not available", e2);
        }
    }

    public void removeReviewItemRevisions(final PermId<ReviewData> reviewId, final PermId<ReviewItemData> itemId, final List<String> revisions) throws IllegalArgumentException, NotFoundException, NotPermittedException {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)reviewId);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
                CrucibleRevision crucibleRevision = DefaultReviewService.this.getRequiredFileRevisionExtraInfo((PermId<ReviewItemData>)itemId).getFileRevision();
                Source s2 = DefaultReviewService.this.tryGetSource(crucibleRevision.getSourceName());
                ArrayList<CrucibleRevision> toRemove = new ArrayList<CrucibleRevision>(revisions.size());
                for (String revStr : revisions) {
                    CrucibleRevision revision = DefaultReviewService.this.getFileRevision(s2, crucibleRevision.getPath(), revStr);
                    if (revision != null) {
                        toRemove.add(revision);
                        continue;
                    }
                    throw new IllegalArgumentException("the revision " + revStr + " for path " + crucibleRevision.getPath() + " does not exist in source " + crucibleRevision.getSourceName());
                }
                for (CrucibleRevision revision : toRemove) {
                    if (review.removeRevision(revision)) continue;
                    throw new IllegalArgumentException("cannot remove " + revision.getPath() + " revision " + revision.getRevision() + " because it is either not in the review, or it has comments and cannot be deleted.");
                }
                return null;
            }
        });
    }

    public FisheyeReviewItemData addFileToReview(final PermId<ReviewData> id, final FileData file, final FileData diff) throws ReviewContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<FisheyeReviewItemData>(){

                @Override
                public FisheyeReviewItemData doInTransaction(TransactionStatus status) throws IOException {
                    try {
                        Review review = DefaultReviewService.this.getReviewCheckOpenReviewPermissionAndRoomForNewContent((PermId<ReviewData>)id);
                        FecruUser author = DefaultReviewService.this.getEffectiveUser();
                        String sourceName = "UPLOAD:" + review.getId();
                        CrucibleRevision fromRev = null;
                        if (file == null) {
                            throw new IllegalArgumentException("fileToReview cannot be be null");
                        }
                        FileRevisionExtraInfo frx = UploadManager.getFrxForPath(review, file.getName());
                        if (diff != null) {
                            UploadItem fromUi = UploadManager.createUploadItem(author, diff);
                            FileRevisionInfo fromFri = UploadManager.getFromFRI(fromUi, author.getUsername(), diff.getName(), diff.getDescription(), diff.getContentType(), frx);
                            fromRev = DefaultReviewService.this.contentManager.makeCrucibleRevision(sourceName, fromFri);
                            fromRev.setUploadItem(fromUi);
                        }
                        UploadItem toUi = UploadManager.createUploadItem(author, file);
                        CrucibleRevision diffRevision = fromRev;
                        if (fromRev == null && frx != null) {
                            diffRevision = frx.getFileRevision();
                        }
                        FileRevisionInfo toFri = UploadManager.getToFRI(toUi, diffRevision, author.getUsername(), file.getName(), file.getDescription(), file.getContentType(), frx);
                        CrucibleRevision toRev = DefaultReviewService.this.contentManager.makeCrucibleRevision(sourceName, toFri);
                        toRev.setUploadItem(toUi);
                        if (frx == null) {
                            frx = review.addRevision(toRev);
                            if (fromRev != null) {
                                frx.addRevision(0, fromRev);
                            } else {
                                frx.setShowAsDiff(false);
                            }
                            DefaultReviewService.this.logManager.addLogItem(LogItemBuilder.buildReviewFrxAdded(review, author, frx));
                        } else {
                            FRXRevisionManager frxRevManager = new FRXRevisionManager();
                            if (fromRev != null) {
                                frxRevManager.createFRXRevisionAndUnread(frx, frx.getFrxRevisions().size(), fromRev);
                            }
                            frxRevManager.createFRXRevisionAndUnread(frx, frx.getFrxRevisions().size(), toRev);
                            DefaultReviewService.this.logManager.addLogItem(LogItemBuilder.buildReviewRevisionAdded(review, author, frx.getFileFRXRevision()));
                        }
                        FRXRevision frxRev = frx.getFRXRevision(toRev);
                        DefaultReviewService.this.notificationManager.noteFRXRevisionAdded(review, frxRev, DefaultReviewService.this.getEffectiveUser());
                        return DefaultReviewService.this.buildReviewItemData(frx, null);
                    }
                    catch (ReviewContentTooLargeException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ReviewContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    public List<ReviewData> getAllReviews(boolean details) {
        ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
        Collection<Review> reviews = this.reviewManager.getReviews();
        ReviewUtil.AllowedActionsCache permissionCache = new ReviewUtil.AllowedActionsCache();
        ReviewUtil.AllowedTransitionsCache transitionCache = new ReviewUtil.AllowedTransitionsCache();
        ReviewUtil.ActionAllowedCache actionPermissionCache = new ReviewUtil.ActionAllowedCache();
        for (Review r2 : reviews) {
            if (!this.hasReviewPermission(UserActionManager.ACTION_VIEW, r2, actionPermissionCache)) continue;
            reviewDataList.add(this.buildReviewData(r2, details, false, permissionCache, transitionCache));
        }
        return reviewDataList;
    }

    public ReviewData getReview(PermId<ReviewData> id, boolean details) {
        return this.getReviewData(id, details);
    }

    public ReviewData getReview(PermId<ReviewData> id) {
        return this.getReviewData(id, false);
    }

    public DetailedReviewData getReviewDetails(PermId<ReviewData> id) {
        return (DetailedReviewData)this.getReviewData(id, true);
    }

    private ReviewData getReviewData(PermId<ReviewData> id, boolean details) {
        Timer t2 = new Timer("getReviewData, with details: " + details);
        Review review = this.getRequiredReview(id);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
        ReviewData reviewData = this.buildReviewData(review, details, true);
        t2.end();
        return reviewData;
    }

    public List<ActionData> getAllowedActionsForReview(PermId<ReviewData> id) {
        Review review = this.getRequiredReview(id);
        return this.prepareAllowedActions(review, null);
    }

    private List<ActionData> prepareAllowedActions(Review review, ReviewUtil.AllowedActionsCache permissionCache) {
        ArrayList<ActionData> actionData = new ArrayList<ActionData>();
        Collection<UserActionManager.Action> actions = UserActionManager.getInstance().getAllowedActions(this.getEffectivePrincipal(), review, permissionCache);
        for (UserActionManager.Action action : actions) {
            actionData.add(new ActionData(action.getName(), action.getDisplayName()));
        }
        return actionData;
    }

    public List<ActionData> getAllowedTransitionsForReview(PermId<ReviewData> id) {
        Review review = this.getRequiredReview(id);
        return this.prepareAllowedTransitions(this.getEffectivePrincipal(), review, null);
    }

    private List<ActionData> prepareAllowedTransitions(Principal principal, Review review, ReviewUtil.AllowedTransitionsCache cache) {
        ArrayList<ActionData> transitionData = new ArrayList<ActionData>();
        for (StateTransition stateTransition : ReviewUtil.getStateActions(principal, review, cache)) {
            UserActionManager.Action action = UserActionManager.getInstance().getAction(stateTransition.getActionName());
            if (action == null) continue;
            transitionData.add(new ActionData(action.getName(), action.getDisplayName()));
        }
        return transitionData;
    }

    public List<ReviewData> getReviewsInStates(ReviewData.State[] states, boolean details) {
        ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
        String[] statesAsStrings = new String[states.length];
        int i2 = 0;
        for (ReviewData.State s2 : states) {
            statesAsStrings[i2++] = s2.toString();
        }
        Collection<Review> reviews = this.reviewManager.getReviewsInStates(statesAsStrings);
        ReviewUtil.AllowedActionsCache permissionCache = new ReviewUtil.AllowedActionsCache();
        ReviewUtil.AllowedTransitionsCache transitionCache = new ReviewUtil.AllowedTransitionsCache();
        ReviewUtil.ActionAllowedCache actionPermissionCache = new ReviewUtil.ActionAllowedCache();
        for (Review r2 : reviews) {
            if (!this.hasReviewPermission(UserActionManager.ACTION_VIEW, r2, actionPermissionCache)) continue;
            reviewDataList.add(this.buildReviewData(r2, details, false, permissionCache, transitionCache));
        }
        return reviewDataList;
    }

    private ReviewData buildReviewData(Review r2, boolean details, boolean includeReviewItems) {
        return this.buildReviewData(r2, details, includeReviewItems, null, null);
    }

    private ReviewData buildReviewData(Review review, boolean details, boolean includeReviewItems, ReviewUtil.AllowedActionsCache permissionCache, ReviewUtil.AllowedTransitionsCache transitionCache) {
        ReviewData.Builder reviewBuilder;
        if (details) {
            List<ActionData> actionData = this.prepareAllowedActions(review, permissionCache);
            List<ActionData> transitionData = this.prepareAllowedTransitions(this.getEffectivePrincipal(), review, transitionCache);
            ReviewItems reviewItems = includeReviewItems ? new ReviewItems(this.prepareReviewItemsForReview(review)) : null;
            reviewBuilder = new DetailedReviewData.Builder().setReviewers(new Reviewers(this.prepareReviewersData(review, ReviewerStatus.ALL))).setGeneralComments(new Comments(this.prepareGeneralComments(review, details))).setVersionedComments(new Comments(this.prepareAllRevisionComments(review, details), true)).setReviewItems(reviewItems).setTransitions(new Transitions(transitionData)).setActions(new Actions(actionData)).setCommentStats(this.buildReviewStats(review));
        } else {
            reviewBuilder = new ReviewData.Builder();
        }
        return this.spiUtils.applyToReviewBuilder(reviewBuilder, review).build();
    }

    private Collection<CommentStats> buildReviewStats(Review review) {
        HashMap<FecruUser, CommentStats> stats = new HashMap<FecruUser, CommentStats>();
        FecruUser currentUser = this.getEffectiveUser();
        for (Comment comment : this.commentManager.comments(review).where(DiscussionClauses.not(DiscussionClauses.deleted())).collect()) {
            CommentStats stat = (CommentStats)stats.get(comment.getUser());
            if (stat == null) {
                stat = new CommentStats(comment.getUser().getUsername(), 0, 0, 0, 0, 0, 0);
                stats.put(comment.getUser(), stat);
            }
            if (comment.isDraft()) {
                ++stat.drafts;
            } else {
                ++stat.published;
            }
            if (comment.isDefectRaised()) {
                ++stat.defects;
            }
            CommentReadStatus.Status readStatus = comment.getReadStatusValue(currentUser);
            switch (readStatus) {
                case LEAVE_UNREAD: {
                    ++stat.leaveUnread;
                    break;
                }
                case READ: {
                    ++stat.read;
                    break;
                }
                case UNREAD: {
                    ++stat.unread;
                }
            }
        }
        return stats.values();
    }

    public ReviewItemData addFisheyeDiff(final PermId<ReviewData> id, final String repositoryName, final String fromPath, final String fromRevision, final String toPath, final String toRevision) throws ReviewContentTooLargeException {
        try {
            return this.txTemplate.execute(new TxCallback<ReviewItemData>(){

                @Override
                public ReviewItemData doInTransaction(TransactionStatus status) {
                    try {
                        Review review = DefaultReviewService.this.getReviewCheckOpenReviewPermissionAndRoomForNewContent((PermId<ReviewData>)id);
                        Source source = DefaultReviewService.this.tryGetSource(repositoryName);
                        CrucibleRevision to = DefaultReviewService.this.getFileRevision(source, toPath, toRevision);
                        FileRevisionExtraInfo frxInfo = null;
                        frxInfo = review.addRevision(to);
                        if (fromPath != null && !"".equals(fromPath)) {
                            CrucibleRevision from = DefaultReviewService.this.getFileRevision(source, fromPath, fromRevision);
                            CrucibleRevision revToRemove = frxInfo.getFromRevision();
                            frxInfo.addRevision(0, from);
                            if (!from.equals(revToRemove)) {
                                frxInfo.removeRevision(revToRemove);
                            }
                        }
                        return DefaultReviewService.this.buildReviewItemData(frxInfo, null);
                    }
                    catch (ReviewContentTooLargeException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                }
            });
        }
        catch (RuntimeWrappedException rwe) {
            rwe.rethrowCause(ReviewContentTooLargeException.class);
            rwe.rethrowCause(RuntimeException.class);
            throw new RuntimeException(rwe.getCause());
        }
    }

    private CrucibleRevision getFileRevision(Source source, String path, String revision) {
        return this.contentManager.getCrucibleRevision(source, new RevInfoKey(new Path(path), revision));
    }

    public void removeReviewItem(final PermId<ReviewData> reviewId, final PermId<ReviewItemData> itemId) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)reviewId);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
                FileRevisionExtraInfo frx = DefaultReviewService.this.getRequiredFileRevisionExtraInfo((PermId<ReviewItemData>)itemId);
                review.removeFRX(frx);
                return null;
            }
        });
    }

    public FisheyeReviewItemData getReviewItem(PermId<ReviewData> reviewDataPermId, PermId<ReviewItemData> reviewItemDataPermId) {
        Review review = this.getRequiredReview(reviewDataPermId);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            if (!frx.getPermaId().equals(reviewItemDataPermId.getId())) continue;
            Patch patch = this.patchManager.findPatch(frx.getFileRevision());
            return this.buildReviewItemData(frx, patch);
        }
        throw new NotFoundException(String.format("%s not found under %s", reviewItemDataPermId.getId(), reviewDataPermId.getId()));
    }

    public List<ReviewItemData> getReviewItemsForReview(PermId<ReviewData> id) {
        Review review = this.getRequiredReview(id);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
        return this.prepareReviewItemsForReview(review);
    }

    private List<ReviewItemData> prepareReviewItemsForReview(Review review) {
        Set<FileRevisionExtraInfo> frxs = review.getFrxs();
        ArrayList<ReviewItemData> data = new ArrayList<ReviewItemData>(frxs.size());
        for (FileRevisionExtraInfo frx : frxs) {
            Patch patch = this.patchManager.findPatch(frx.getFileRevision());
            data.add((ReviewItemData)this.buildReviewItemData(frx, patch));
        }
        return data;
    }

    public List<ReviewData> getAllReviewsForItem(String path, String repositoryName, boolean details) {
        Source s2 = this.tryGetSource(repositoryName);
        List<Object[]> r2 = FileRevisionManager.getReviewsAndRevisionsForPath(s2, path);
        ArrayList<ReviewData> reviews = new ArrayList<ReviewData>();
        ReviewUtil.AllowedActionsCache permissionCache = new ReviewUtil.AllowedActionsCache();
        ReviewUtil.AllowedTransitionsCache transitionCache = new ReviewUtil.AllowedTransitionsCache();
        for (Object[] objects : r2) {
            Review review;
            if (!(objects[0] instanceof Review) || !this.hasReviewPermission(UserActionManager.ACTION_VIEW, review = (Review)objects[0])) continue;
            reviews.add(this.buildReviewData((Review)objects[0], details, false, permissionCache, transitionCache));
        }
        return reviews;
    }

    private FisheyeReviewItemData buildReviewItemData(FileRevisionExtraInfo frx, Patch patch) {
        FisheyeReviewItemAttibutes attrs;
        boolean isPatch = patch != null;
        String urlSuffix = null;
        if (isPatch) {
            urlSuffix = this.spiUtils.createPatchContentUrlFromPatch(patch);
        }
        String toContentUrl = null;
        String fromContentUrl = null;
        CrucibleRevision fileRevision = frx.getFileRevision();
        if (fileRevision != null) {
            FisheyeReviewItemData.CommitType ct = this.spiUtils.asCommitType(fileRevision);
            attrs = new FisheyeReviewItemAttibutes(ct == FisheyeReviewItemData.CommitType.Added, ct == FisheyeReviewItemData.CommitType.Deleted, ct == FisheyeReviewItemData.CommitType.Modified, ct == FisheyeReviewItemData.CommitType.Moved, ct == FisheyeReviewItemData.CommitType.Copied);
            if (!isPatch) {
                toContentUrl = this.spiUtils.createRevisionContentUrlFromFRX(frx.getFileFRXRevision());
            }
        } else {
            attrs = new FisheyeReviewItemAttibutes();
        }
        this.retrieveRevisionDetailsIfMissing(frx);
        CrucibleRevision fromRevision = frx.getFromRevision();
        if (fromRevision != null && !isPatch) {
            fromContentUrl = this.spiUtils.createRevisionContentUrlFromFRX(frx.getFromFRXRevision());
        }
        ArrayList<ReviewItemRevisionData> revs = new ArrayList<ReviewItemRevisionData>();
        for (FRXRevision frxrev : frx.getFrxRevisions()) {
            revs.add(this.spiUtils.createRevisionData(frxrev, this.sourceFactory.isPatchSource(frxrev.getRevision().getSourceName())));
        }
        FisheyeReviewItemData frd = new FisheyeReviewItemData(fileRevision != null && fileRevision.getSourceName() != null ? fileRevision.getSourceName() : "", fromRevision != null ? fromRevision.getPath() : "", fromRevision != null ? fromRevision.getRevision() : "", fromContentUrl, fileRevision != null ? fileRevision.getPath() : "", fileRevision != null ? fileRevision.getRevision() : "", toContentUrl, attrs, frx.getPermaId(), urlSuffix, patch != null && patch.isAnchored() ? this.makeAnchordPatchData(patch, fileRevision) : null, this.spiUtils.asFileType(fileRevision != null ? fileRevision.getFileType() : ""), StringUtils.defaultString((String)(fileRevision != null ? fileRevision.getAuthorName() : "")), fileRevision != null ? fileRevision.getCommitDate() : null, frx.getShowAsDiff(), this.getParticipants(frx), revs);
        return frd;
    }

    private void retrieveRevisionDetailsIfMissing(FileRevisionExtraInfo frx) {
        CrucibleRevision cr = frx.getFileRevision();
        if (null == cr) {
            return;
        }
        CrucibleRevision fromRevision = frx.getFromRevision();
        if (!(this.contentManager.needsUpdate(cr) || fromRevision != null && this.contentManager.needsUpdate(fromRevision))) {
            return;
        }
        Source source = this.tryGetSource(cr.getSourceName());
        this.contentManager.checkRevisionDetailsSynchronously(cr, source);
        if (null != fromRevision) {
            this.contentManager.checkRevisionDetailsSynchronously(fromRevision, source);
        }
    }

    private AnchorData makeAnchordPatchData(Patch patch, CrucibleRevision fileRevision) {
        return new AnchorData(patch.getAnchorSource(), patch.getAnchoredPath(fileRevision.getPath()), patch.getStripCount());
    }

    private Set<ReviewItemData.ParticipantStatus> getParticipants(FileRevisionExtraInfo frx) {
        HashSet<ReviewItemData.ParticipantStatus> statuses = new HashSet<ReviewItemData.ParticipantStatus>();
        for (ReviewParticipant rp : frx.getReview().getParticipants()) {
            statuses.add(new ReviewItemData.ParticipantStatus(this.spiUtils.createUserData(rp.getUser()), rp.isRead(frx)));
        }
        return statuses;
    }

    public VersionedLineCommentData addComment(final PermId<ReviewItemData> id, final VersionedLineCommentData comment) {
        return this.txTemplate.execute(new TxCallback<VersionedLineCommentData>(){

            @Override
            public VersionedLineCommentData doInTransaction(TransactionStatus status) {
                VersionedLineCommentData result;
                boolean isFrxRevision;
                FileRevisionExtraInfo frx = DefaultReviewService.this.getRequiredFileRevisionExtraInfo((PermId<ReviewItemData>)id);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, frx.getReview());
                Comment c2 = DefaultReviewService.this.createComment(frx.getReview(), (CommentData)comment);
                String toLineRange = comment.getToLineRange();
                String fromLineRange = comment.getFromLineRange();
                boolean bl = isFrxRevision = (comment.getLineRanges() == null || comment.getLineRanges().isEmpty()) && StringUtils.isEmpty((String)toLineRange) && StringUtils.isEmpty((String)fromLineRange);
                if (isFrxRevision) {
                    FRXComment rc = FRXCommentManager.createAndAddFrxComment(c2, frx);
                    result = DefaultReviewService.this.buildVersionedLineCommentData(rc, true);
                } else {
                    List<VersionedLineCommentData.LineRangeDetail> ranges;
                    HashMap<FRXRevision, String> revisionLineRanges = new HashMap<FRXRevision, String>();
                    List list = ranges = comment.getLineRanges() == null ? new ArrayList() : comment.getLineRanges();
                    if (ranges.isEmpty()) {
                        FRXRevision toRev = frx.getFileFRXRevision();
                        FRXRevision fromRev = frx.getFromFRXRevision();
                        if (toRev != null) {
                            ranges.add(new VersionedLineCommentData.LineRangeDetail(toRev.getRevision().getRevision(), toLineRange));
                        }
                        if (fromRev != null) {
                            ranges.add(new VersionedLineCommentData.LineRangeDetail(fromRev.getRevision().getRevision(), fromLineRange));
                        }
                    }
                    for (VersionedLineCommentData.LineRangeDetail range : ranges) {
                        boolean validRevision = false;
                        for (FRXRevision rev : frx.getFrxRevisions()) {
                            if (!rev.getRevision().getRevision().equals(range.getRevision())) continue;
                            revisionLineRanges.put(rev, range.getRange());
                            validRevision = true;
                            break;
                        }
                        if (validRevision) continue;
                        throw new IllegalArgumentException("Invalid revision specified: " + range.getRevision());
                    }
                    if (revisionLineRanges.size() > 2) {
                        throw new IllegalArgumentException("An inline comment cannot refer to " + revisionLineRanges.size() + " revisions. Restrict lines range to 2 revisions max.");
                    }
                    InlineComment rc = InlineCommentManager.createInlineComment(frx, c2, revisionLineRanges);
                    result = DefaultReviewService.this.buildVersionedLineCommentData(rc, true);
                }
                DefaultReviewService.this.commentManager.announceCommentCreation(c2);
                return result;
            }
        });
    }

    public GeneralCommentData addGeneralComment(final PermId<ReviewData> id, final GeneralCommentData comment) {
        return this.txTemplate.execute(new TxCallback<GeneralCommentData>(){

            @Override
            public GeneralCommentData doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, review);
                Comment c2 = DefaultReviewService.this.createComment(review, (CommentData)comment);
                review.addComment(c2);
                DefaultReviewService.this.commentManager.announceCommentCreation(c2);
                return DefaultReviewService.this.buildGeneralCommentData(c2, false);
            }
        });
    }

    public CommentData getComment(PermId<CommentData> id) {
        return this.getComment(id, false);
    }

    public CommentData getComment(PermId<CommentData> id, boolean withHtmlMessage) {
        Comment c2 = this.getRequiredComment(id);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, c2.getReview());
        if (c2.isDraft()) {
            DefaultReviewService.ensureCommentAuthoredBy(c2, this.getEffectiveUser());
        }
        return this.buildCommentData(c2, withHtmlMessage);
    }

    private CommentData buildCommentData(Comment c2, boolean withHtml) {
        if (c2.getFrxComment() != null) {
            return this.buildVersionedLineCommentData(c2.getFrxComment(), withHtml);
        }
        if (c2.getInlineComment() != null) {
            return this.buildVersionedLineCommentData(c2.getInlineComment(), withHtml);
        }
        return this.buildGeneralCommentData(c2, withHtml);
    }

    private Integer getCommentId(PermId<CommentData> commentId) {
        String[] cIdTokens = commentId.getId().split(":");
        String id = cIdTokens.length > 1 ? cIdTokens[1] : cIdTokens[0];
        return Integer.parseInt(id);
    }

    public void updateComment(final PermId<CommentData> commentId, final GeneralCommentData newContent) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) {
                Comment comment = DefaultReviewService.this.getRequiredComment((PermId<CommentData>)commentId);
                String oldCommentText = comment.getMessage();
                boolean wasDraft = comment.isDraft();
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, comment.getReview());
                DefaultReviewService.ensureCommentAuthoredBy(comment, DefaultReviewService.this.getEffectiveUser());
                DefaultReviewService.this.updateComment((CommentData)newContent, comment);
                DefaultReviewService.this.commentManager.announceCommentUpdate(comment, oldCommentText, wasDraft);
                return null;
            }
        });
    }

    private static void ensureCommentAuthoredBy(Comment comment, FecruUser user) {
        FecruUser author = comment.getUser();
        if (!author.equals(user)) {
            throw new NotPermittedException(String.format("Comment %s is authored by %s, not %s", comment.getPermaId(), user.getUsername(), author.getUsername()));
        }
    }

    public void postComment(final PermId<CommentData> commentId) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) {
                Comment c2 = DefaultReviewService.this.getRequiredComment((PermId<CommentData>)commentId);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, c2.getReview());
                DefaultReviewService.ensureCommentAuthoredBy(c2, DefaultReviewService.this.getEffectiveUser());
                DefaultReviewService.this.commentManager.publishCommentAndAnnounce(c2);
                return null;
            }
        });
    }

    public void postComments(final PermId<ReviewData> id) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, review);
                DefaultReviewService.this.commentManager.publishDraftCommentsAndAnnounce(review, DefaultReviewService.this.getEffectiveUser());
                return null;
            }
        });
    }

    public DetailedReviewData markAllCommentsAsRead(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<DetailedReviewData>(){

            @Override
            public DetailedReviewData doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                DefaultReviewService.this.requireMarkAsReadPermission(review);
                DefaultReviewService.this.unreadManager.markReviewCommentsAsRead(DefaultReviewService.this.getEffectiveUser(), review);
                for (FileRevisionExtraInfo frx : review.getFrxs()) {
                    DefaultReviewService.this.unreadManager.markFRXCommentsAsRead(DefaultReviewService.this.getEffectiveUser(), frx);
                }
                DetailedReviewData data = (DetailedReviewData)DefaultReviewService.this.buildReviewData(review, true, true);
                ArrayList comments = new ArrayList();
                comments.addAll(data.getGeneralComments().comments);
                comments.addAll(data.getVersionedComments().comments);
                for (CommentData c2 : comments) {
                    c2.setReadStatus(CommentData.Status.READ);
                    for (CommentData r2 : c2.getReplies()) {
                        r2.setReadStatus(CommentData.Status.READ);
                    }
                }
                return data;
            }
        });
    }

    public CommentData markCommentAsRead(final PermId<CommentData> commentId) {
        return this.txTemplate.execute(new TxCallback<CommentData>(){

            @Override
            public CommentData doInTransaction(TransactionStatus status) throws Exception {
                Comment c2 = DefaultReviewService.this.getRequiredComment((PermId<CommentData>)commentId);
                DefaultReviewService.this.requireMarkAsReadPermission(c2.getReview());
                FecruUser user = DefaultReviewService.this.getEffectiveUser();
                new UnreadManager().markAsRead(user, c2);
                CommentData data = DefaultReviewService.this.buildCommentData(c2, false);
                data.setReadStatus(CommentData.Status.READ);
                return data;
            }
        });
    }

    public CommentData markCommentAsLeaveUnread(final PermId<CommentData> commentId) {
        return this.txTemplate.execute(new TxCallback<CommentData>(){

            @Override
            public CommentData doInTransaction(TransactionStatus status) throws Exception {
                Comment c2 = DefaultReviewService.this.getRequiredComment((PermId<CommentData>)commentId);
                DefaultReviewService.this.requireMarkAsReadPermission(c2.getReview());
                new UnreadManager().markAsLeaveUnread(DefaultReviewService.this.getEffectiveUser(), c2);
                CommentData data = DefaultReviewService.this.buildCommentData(c2, false);
                data.setReadStatus(CommentData.Status.LEAVE_UNREAD);
                return data;
            }
        });
    }

    private void requireMarkAsReadPermission(Review review) throws NotPermittedException {
        this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, review);
        if (!this.hasMarkAsReadPermission(review)) {
            throw new NotPermittedException("You do not have permission to change a comment status in the review " + review.getPermaId());
        }
    }

    public void removeComment(final PermId<CommentData> commentId) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) {
                Comment comment = DefaultReviewService.this.getRequiredComment((PermId<CommentData>)commentId);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, comment.getReview());
                DefaultReviewService.ensureCommentAuthoredBy(comment, DefaultReviewService.this.getEffectiveUser());
                DefaultReviewService.this.commentManager.deleteComment(comment);
                if (!StringUtils.isEmpty((String)comment.getJiraIssueKey())) {
                    DefaultReviewService.this.deleteLinkedJiraIssue(comment);
                    comment.setJiraIssueKey(null);
                }
                return null;
            }
        });
    }

    private void deleteLinkedJiraIssue(Comment comment) {
        JiraIssue jiraIssue = this.issueService.getJiraIssue(comment.getJiraIssueKey(), QueryContextImpl.Builder.newInstance(this.jiraServerService).project(comment.getReview().getProject()).build(), new RemoteExceptionHandler(){

            @Override
            public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
            }

            @Override
            public void acceptException(JiraServer jiraServer, Exception e2) {
            }
        });
        try {
            jiraIssue.delete();
        }
        catch (Exception je) {
            this.logJiraIssueDeleteFailed(comment, je);
        }
    }

    private void logJiraIssueDeleteFailed(Comment comment, Exception e2) {
        Logs.APP_LOG.warn((Object)String.format("Deleting linked Jira issue %s failed (%s). Deleting comment regardless.", comment.getJiraIssueKey(), e2.getMessage()), (Throwable)e2);
    }

    public GeneralCommentData addReply(final PermId<CommentData> commentId, final GeneralCommentData comment) {
        return this.txTemplate.execute(new TxCallback<GeneralCommentData>(){

            @Override
            public GeneralCommentData doInTransaction(TransactionStatus status) {
                Comment parent = DefaultReviewService.this.getRequiredComment((PermId<CommentData>)commentId);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_COMMENT, parent.getReview());
                if (!comment.isDraft() && !parent.isVisibleToAll()) {
                    throw new IllegalArgumentException("Can't post replies to drafts.");
                }
                Comment reply = DefaultReviewService.this.createComment(parent.getReview(), (CommentData)comment);
                parent.addComment(reply);
                DefaultReviewService.this.commentManager.announceCommentCreation(reply);
                return DefaultReviewService.this.buildGeneralCommentData(reply, false);
            }
        });
    }

    private Comment createComment(Review review, CommentData newContent) {
        Comment comment = this.commentManager.createComment(newContent.getMessage(), review, this.getEffectiveUser());
        this.updateComment(newContent, comment);
        return comment;
    }

    private Comment updateComment(CommentData newContent, Comment comment) {
        comment.setMessage(newContent.getMessage());
        comment.setUpdatedDateTime(System.currentTimeMillis());
        comment.setDefectApproved(newContent.isDefectApproved());
        comment.setDefectRaised(newContent.isDefectRaised());
        comment.setDraft(newContent.isDraft());
        comment.setDeleted(newContent.isDeleted());
        if (newContent.getReplies() != null && newContent.getReplies().size() > 0) {
            throw new IllegalArgumentException("You cannot specify replies when creating a comment via the API");
        }
        Map metrics = newContent.getMetrics();
        if (metrics != null) {
            for (Map.Entry metric : metrics.entrySet()) {
                FieldDefinition fd;
                CustomFieldData fieldData;
                Map<String, FieldDefinition> commentFields;
                CustomField oldField = comment.getFieldByName((String)metric.getKey());
                if (oldField != null) {
                    comment.removeField(oldField);
                }
                if ((commentFields = MetricsManager.INSTANCE.getConfig((fieldData = (CustomFieldData)metric.getValue()).getConfigVersion()).getCommentFields()) == null || (fd = commentFields.get(metric.getKey())) == null) continue;
                CustomField f2 = fd.makeCustomField(fieldData.getValue());
                comment.addField(f2);
            }
        }
        return comment;
    }

    public List<CustomFieldDefData> getMetrics(int metricsVersion) {
        MetricsConfig config = MetricsManager.INSTANCE.getConfig(metricsVersion);
        if (config == null) {
            throw new NotFoundException("Unknown metrics version: " + metricsVersion);
        }
        return MetricsUtil.toSPI(config, metricsVersion);
    }

    public List<GeneralCommentData> getGeneralComments(PermId<ReviewData> id) {
        return this.getGeneralComments(id, false);
    }

    public List<GeneralCommentData> getGeneralComments(PermId<ReviewData> id, boolean withHtml) {
        Review review = this.getRequiredReview(id);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
        return this.prepareGeneralComments(review, withHtml);
    }

    private List<GeneralCommentData> prepareGeneralComments(Review review, boolean renderHtml) {
        Set<Comment> comments = review.getComments();
        ArrayList<GeneralCommentData> commentDatas = new ArrayList<GeneralCommentData>(comments.size());
        for (Comment c2 : comments) {
            if (!c2.isVisible(this.getEffectiveUser())) continue;
            commentDatas.add(this.buildGeneralCommentData(c2, renderHtml));
        }
        return commentDatas;
    }

    public List<VersionedLineCommentData> getVersionedComments(PermId<ReviewItemData> id) {
        return this.getVersionedComments(id, false);
    }

    public List<VersionedLineCommentData> getVersionedComments(PermId<ReviewItemData> id, boolean withHtml) {
        FileRevisionExtraInfo frx = this.getRequiredFileRevisionExtraInfo(id);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, frx.getReview());
        ArrayList<VersionedLineCommentData> data = new ArrayList<VersionedLineCommentData>();
        this.prepareVersionedComments(data, frx, withHtml);
        return data;
    }

    private void prepareVersionedComments(List<VersionedLineCommentData> data, FileRevisionExtraInfo frx, boolean renderHtml) {
        for (FRXComment frxComment : frx.getFrxComments()) {
            if (!frxComment.getComment().isVisible(this.getEffectiveUser())) continue;
            data.add(this.buildVersionedLineCommentData(frxComment, renderHtml));
        }
        for (InlineComment inlineComment : frx.getInlineComments()) {
            if (!inlineComment.getComment().isVisible(this.getEffectiveUser())) continue;
            data.add(this.buildVersionedLineCommentData(inlineComment, renderHtml));
        }
    }

    public List<VersionedLineCommentData> getAllRevisionComments(PermId<ReviewData> id) {
        return this.getAllRevisionComments(id, false);
    }

    public List<VersionedLineCommentData> getAllRevisionComments(PermId<ReviewData> id, boolean withHtml) {
        Review review = this.getRequiredReview(id);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
        return this.prepareAllRevisionComments(review, withHtml);
    }

    private List<VersionedLineCommentData> prepareAllRevisionComments(Review review, boolean renderHtml) {
        ArrayList<VersionedLineCommentData> data = new ArrayList<VersionedLineCommentData>();
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            this.prepareVersionedComments(data, frx, renderHtml);
        }
        return data;
    }

    public List<GeneralCommentData> getReplies(PermId<CommentData> commentId) {
        return this.getReplies(commentId, false);
    }

    public List<GeneralCommentData> getReplies(PermId<CommentData> commentId, boolean withHtml) {
        Comment c2 = this.getRequiredComment(commentId);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, c2.getReview());
        if (c2.isDraft()) {
            DefaultReviewService.ensureCommentAuthoredBy(c2, this.getEffectiveUser());
        }
        return this.buildRepliesList(c2, withHtml);
    }

    public List<ReviewData> getUncompletedReviewsForUser(String username) {
        ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
        ReviewFilters reviewFilters = new ReviewFilters(this.getUser(username));
        Collection<Review> reviews = this.reviewManager.getMatchingReviews(reviewFilters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW), null);
        ReviewUtil.AllowedActionsCache permissionCache = new ReviewUtil.AllowedActionsCache();
        ReviewUtil.AllowedTransitionsCache transitionCache = new ReviewUtil.AllowedTransitionsCache();
        for (Review r2 : reviews) {
            if (!this.hasReviewPermission(UserActionManager.ACTION_VIEW, r2)) continue;
            reviewDataList.add(this.buildReviewData(r2, false, false, permissionCache, transitionCache));
        }
        return reviewDataList;
    }

    public List<ReviewData> getFilteredReviews(String filter, boolean details) {
        ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
        FecruUser user = this.getEffectiveUser();
        if (user != null) {
            ReviewFilters reviewFilters = new ReviewFilters(user);
            ReviewFilters.FilterKey filterKey = ReviewFilters.FilterKey.fromId(filter);
            if (filterKey == null) {
                throw new IllegalArgumentException("The filter '" + filter + "' is not defined");
            }
            ReviewFilterDef filterDef = reviewFilters.getFilterDefByKey(filterKey);
            if (filterDef == null) {
                throw new RuntimeException("Filter '" + filter + "' not defined");
            }
            HashSet<Review> reviews = new HashSet<Review>();
            reviews.addAll(this.reviewManager.getMatchingReviews(filterDef, null));
            ReviewUtil.AllowedActionsCache permissionCache = new ReviewUtil.AllowedActionsCache();
            ReviewUtil.AllowedTransitionsCache transitionCache = new ReviewUtil.AllowedTransitionsCache();
            ReviewUtil.ActionAllowedCache actionPermissionCache = new ReviewUtil.ActionAllowedCache();
            for (Review r2 : reviews) {
                if (!this.hasReviewPermission(UserActionManager.ACTION_VIEW, r2, actionPermissionCache)) continue;
                reviewDataList.add(this.buildReviewData(r2, details, false, permissionCache, transitionCache));
            }
        }
        return reviewDataList;
    }

    public List<ReviewData> getCustomFilterReviews(CustomFilterData filter, boolean details) {
        ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
        FecruUser user = this.getEffectiveUser();
        if (user != null) {
            ReviewFilters reviewFilters = new ReviewFilters(user);
            ReviewFilterDef filterDef = reviewFilters.getCustomFilterDef();
            this.adjustCustomFilter(filter, filterDef);
            Collection<Review> reviews = this.reviewManager.getMatchingReviews(filterDef, filter.getTitle());
            ReviewUtil.AllowedActionsCache permissionCache = new ReviewUtil.AllowedActionsCache();
            ReviewUtil.AllowedTransitionsCache transitionCache = new ReviewUtil.AllowedTransitionsCache();
            ReviewUtil.ActionAllowedCache actionPermissionCache = new ReviewUtil.ActionAllowedCache();
            for (Review r2 : reviews) {
                if (!this.hasReviewPermission(UserActionManager.ACTION_VIEW, r2, actionPermissionCache)) continue;
                reviewDataList.add(this.buildReviewData(r2, details, false, permissionCache, transitionCache));
            }
        }
        return reviewDataList;
    }

    private void adjustCustomFilter(CustomFilterData filter, ReviewFilterDef filterDef) {
        if (filter.getProject() != null && !"".equals(filter.getProject())) {
            Project project = this.projectManager.getProjectByKey(filter.getProject());
            if (project == null) {
                throw new NotFoundException("No project found with key " + filter.getProject());
            }
            filterDef.project = project;
            this.requirePermission(UserActionManager.ACTION_VIEW, project);
        }
        if (filter.getState() != null) {
            filterDef.state = filter.getState().split(",");
        }
        if (!StringUtils.isBlank((String)filter.getAuthor())) {
            filterDef.author = this.getUser(filter.getAuthor());
        }
        if (!StringUtils.isBlank((String)filter.getCreator())) {
            filterDef.creator = this.getUser(filter.getCreator());
        }
        if (!StringUtils.isBlank((String)filter.getModerator())) {
            filterDef.moderator = this.getUser(filter.getModerator());
        }
        if (!StringUtils.isBlank((String)filter.getReviewer())) {
            filterDef.reviewer = this.getUser(filter.getReviewer());
        }
        filterDef.orRoles = filter.isOrRoles();
        filterDef.complete = filter.isComplete();
        filterDef.allReviewersComplete = filter.isAllReviewersComplete();
        if (filter.getFromDate() > 0L) {
            filterDef.fromDate = filter.getFromDate();
        }
        if (filter.getToDate() > 0L) {
            filterDef.toDate = filter.getToDate();
        }
    }

    public VersionInfo getVersionInfo() {
        return new VersionInfo("4.0.4", "2016-05-06");
    }

    public void deleteReview(PermId<ReviewData> id) {
        Review review = this.getRequiredReview(id);
        if (!review.getState().isDeletable()) {
            throw new IllegalArgumentException("The review " + id + " in the " + review.getState() + " is not deletable. ");
        }
        String action = UserActionManager.ACTION_DELETE;
        FecruUser user = this.getEffectiveUser();
        if (user == null) {
            throw new IllegalArgumentException("The user '" + this.getEffectivePrincipal().getUserName() + "' is not a Crucible user.");
        }
        this.requireReviewPermission(action, review);
        if (!this.reviewManager.deleteReview(review, user)) {
            throw new RuntimeException("Failed to delete review " + id);
        }
    }

    public ReviewData changeState(final PermId<ReviewData> id, final String action) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                State oldState = review.getState();
                FecruUser user = DefaultReviewService.this.getEffectiveUser();
                UserActionManager.Action act = UserActionManager.getInstance().getAction(action);
                if (act == null) {
                    throw new IllegalArgumentException("Action named '" + action + "' is not a valid review action");
                }
                DefaultReviewService.this.reviewManager.changeState(review, act.getName(), user);
                DefaultReviewService.this.eventPublisher.publish((Object)DefaultReviewService.this.createReviewStateChangedEvent(review, oldState, user, action));
                return DefaultReviewService.this.buildReviewData(review, false, false);
            }
        });
    }

    private ReviewStateChangedEvent createReviewStateChangedEvent(Review review, State oldState, FecruUser user, String action) {
        return new ReviewStateChangedEventImpl((PermId<ReviewData>)new PermId(review.getPermaId()), this.spiUtils.modelStateToDataState(oldState), this.spiUtils.modelStateToDataState(review.getState()), action, this.spiUserUtils.createUserData(user));
    }

    public ReviewData changeState(PermId<ReviewData> id, ReviewService.Action action) {
        return this.changeState(id, action.getActionString());
    }

    public ReviewData closeReviewWithSummary(final PermId<ReviewData> id, final String message) {
        return this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                FecruUser user = DefaultReviewService.this.getEffectiveUser();
                String action = ReviewService.Action.Close.getActionString();
                State oldState = review.getState();
                DefaultReviewService.this.reviewManager.changeState(review, action, user);
                review.setSummary(message);
                DefaultReviewService.this.eventPublisher.publish((Object)DefaultReviewService.this.createReviewStateChangedEvent(review, oldState, user, action));
                return DefaultReviewService.this.buildReviewData(review, false, false);
            }
        });
    }

    public void completeReview(PermId<ReviewData> id, boolean complete) {
        this.txTemplate.execute(status -> {
            Review review = this.getRequiredReview(id);
            FecruUser user = this.getEffectiveUser();
            String requiredAction = complete ? UserActionManager.ACTION_COMPLETE : UserActionManager.ACTION_UNCOMPLETE;
            this.requireReviewPermission(requiredAction, review);
            this.reviewManager.completeReview(review, user, complete);
            return null;
        });
    }

    public List<ReviewData> getChildReviews(PermId<ReviewData> id) {
        return this.getChildReviews(id, false);
    }

    public List<ReviewData> getChildReviews(PermId<ReviewData> id, boolean details) {
        Review review = this.getRequiredReview(id);
        this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
        ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
        List<Review> reviews = review.getChildReviews();
        for (Review r2 : reviews) {
            if (!this.hasReviewPermission(UserActionManager.ACTION_VIEW, r2)) continue;
            reviewDataList.add(this.buildReviewData(r2, details, false));
        }
        return reviewDataList;
    }

    public void tryAutomaticJiraLinking(final PermId<ReviewData> id) {
        this.txTemplate.execute(new TxCallback<ReviewData>(){

            @Override
            public ReviewData doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                String jiraIssueKey = review.getBestSuggestedJiraIssueKey();
                if (jiraIssueKey != null) {
                    try {
                        QueryContext queryContext = QueryContextImpl.Builder.newInstance(DefaultReviewService.this.jiraServerService).project(review.getProject()).build();
                        if (DefaultReviewService.this.issueService.getJiraIssueAggregateExceptions(jiraIssueKey, queryContext) != null) {
                            review.setJiraIssueKey(jiraIssueKey);
                        }
                    }
                    catch (RemoteJiraException e2) {
                        Logs.APP_LOG.debug((Object)e2.getMessage(), (Throwable)e2);
                        Logs.APP_LOG.warn((Object)("Could not link issue key: '" + jiraIssueKey + "' to review: '" + review.getPermaId() + "' due to: " + e2.getMessage()));
                    }
                }
                return null;
            }
        });
    }

    public List<PatchGroupData> getReviewPatches(PermId<ReviewData> id) {
        return this.txTemplate.execute(status -> {
            Review review = this.getRequiredReview(id);
            this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
            HashSet parsedSources = Sets.newHashSet();
            ArrayList<PatchGroupData> patchGroups = new ArrayList<PatchGroupData>();
            for (CrucibleRevision revision : review.getRevisions()) {
                String sourceName = revision.getSourceName();
                if (!sourceName.startsWith("PATCH:") || parsedSources.contains(sourceName)) continue;
                Source source = this.tryGetSource(sourceName);
                parsedSources.add(sourceName);
                if (!(source instanceof PatchSource) || !source.isAvailable()) continue;
                ArrayList<PatchData> patchData = new ArrayList<PatchData>();
                for (Patch patch : this.patchManager.getActivePatchesForSource(source.getName())) {
                    UploadItem ui = patch.getUploadItem();
                    AnchorData anchor = patch.isAnchored() ? this.makeAnchordPatchData(patch, revision) : null;
                    String patchUrl = this.spiUtils.createPatchContentUrlFromPatch(patch);
                    patchData.add(new PatchData(patch.getId().intValue(), ui.getOriginalName(), ui.getCreateDate(), anchor, patchUrl));
                }
                patchGroups.add(new PatchGroupData(patchData, sourceName, source.getDisplayName()));
            }
            return patchGroups;
        });
    }

    private Map<String, CustomFieldData> buildMetrics(Comment c2) {
        HashMap<String, CustomFieldData> metrics = new HashMap<String, CustomFieldData>();
        for (String name : c2.getFieldDefinitions().keySet()) {
            CustomField cf = c2.getFieldByName(name);
            if (cf == null) continue;
            metrics.put(name, new CustomFieldData(cf.getConfigVersion().intValue(), cf.getHrValue()));
        }
        return metrics;
    }

    private boolean hasMarkAsReadPermission(Review review) {
        return review.isNotClosed() && this.permissionManager.canPrincipalDoAction(review.getProject().getPermissionScheme(), this.effectiveUserProvider.getEffectivePrincipal(), this.effectiveUserProvider.getEffectiveUser(), UserActionManager.ACTION_COMMENT, review);
    }

    private CommentData.Status getReadStatus(FecruUser user, Comment comment) {
        if (!this.hasMarkAsReadPermission(comment.getReview())) {
            return CommentData.Status.READ;
        }
        CommentReadStatus.Status status = comment.getReadStatusValue(user);
        switch (status) {
            case UNREAD: {
                return CommentData.Status.UNREAD;
            }
            case READ: {
                return CommentData.Status.READ;
            }
            case LEAVE_UNREAD: {
                return CommentData.Status.LEAVE_UNREAD;
            }
        }
        throw new IllegalArgumentException("Comment status " + (Object)((Object)status) + " cannot be mapped to an API comment status");
    }

    private VersionedLineCommentData buildVersionedLineCommentData(FRXComment frxComment, boolean withHtml) {
        FileRevisionExtraInfo frx = frxComment.getFrx();
        Comment comment = frxComment.getComment();
        FecruUser user = comment.getUser();
        return new VersionedLineCommentData(new PermId(frx.getPermaId()), comment.getMessage(), withHtml ? this.renderer.render((CharSequence)comment.getMessage(), (RenderContext)this.makeContext(comment)) : null, comment.isDraft(), comment.isDeleted(), comment.isDefectRaised(), comment.isDefectApproved(), this.getReadStatus(this.getEffectiveUser(), comment), this.spiUtils.createUserData(user), comment.getCreateDate(), null, null, comment.getPermaId(), this.buildRepliesList(comment, withHtml), this.buildMetrics(comment), this.getReplyToCommentPermId(comment));
    }

    private VersionedLineCommentData buildVersionedLineCommentData(InlineComment inlineComment, boolean withHtml) {
        FileRevisionExtraInfo frx = inlineComment.getFrx();
        Comment comment = inlineComment.getComment();
        FecruUser user = comment.getUser();
        ArrayList<InlineCommentRevisionDetail> revDetails = new ArrayList<InlineCommentRevisionDetail>(inlineComment.getDetails());
        Collections.sort(revDetails, new Comparator<InlineCommentRevisionDetail>(){

            @Override
            public int compare(InlineCommentRevisionDetail d1, InlineCommentRevisionDetail d2) {
                return d1.getFrxRevision().getOrder() - d2.getFrxRevision().getOrder();
            }
        });
        ArrayList<VersionedLineCommentData.LineRangeDetail> details = new ArrayList<VersionedLineCommentData.LineRangeDetail>();
        for (InlineCommentRevisionDetail detail : revDetails) {
            details.add(new VersionedLineCommentData.LineRangeDetail(detail.getFrxRevision().getRevision().getRevision(), detail.getLineRange()));
        }
        InlineCommentRevisionDetail fromDetail = inlineComment.getFromDetail();
        InlineCommentRevisionDetail toDetail = inlineComment.getToDetail();
        VersionedLineCommentData vlcd = new VersionedLineCommentData(new PermId(frx.getPermaId()), comment.getMessage(), withHtml ? this.renderer.render((CharSequence)comment.getMessage(), (RenderContext)this.makeContext(comment)) : null, comment.isDraft(), comment.isDeleted(), comment.isDefectRaised(), comment.isDefectApproved(), this.getReadStatus(this.getEffectiveUser(), comment), this.spiUtils.createUserData(user), comment.getCreateDate(), fromDetail == null ? null : fromDetail.getLineRange(), toDetail == null ? null : toDetail.getLineRange(), comment.getPermaId(), this.buildRepliesList(comment, withHtml), this.buildMetrics(comment), this.getReplyToCommentPermId(comment));
        vlcd.setLineRanges(details);
        return vlcd;
    }

    private GeneralCommentData buildGeneralCommentData(Comment c2, boolean withHtml) {
        FecruUser user = c2.getUser();
        return ((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)((GeneralCommentData.GeneralCommentBuilder)GeneralCommentData.builder().setMessage(c2.getMessage())).setMessageAsHtml(withHtml ? this.renderer.render((CharSequence)c2.getMessage(), (RenderContext)this.makeContext(c2)) : null)).setDraft(c2.isDraft())).setDeleted(c2.isDeleted())).setDefectRaised(c2.isDefectRaised())).setDefectApproved(c2.isDefectApproved())).setReadStatus(this.getReadStatus(this.getEffectiveUser(), c2))).setUser(this.spiUtils.createUserData(user))).setCreateDate(c2.getCreateDate())).setPermaId(c2.getPermaId())).setReplies(this.buildRepliesList(c2, withHtml))).setMetrics(this.buildMetrics(c2))).setParentCommentPermId(this.getReplyToCommentPermId(c2))).build();
    }

    private CrucibleRenderContext makeContext(Comment c2) {
        String repo = c2.getReview().getProject().getDefaultRepositoryNameIfFisheyeRepository();
        return (CrucibleRenderContext)this.renderer.setupRenderContextProperties((RenderContext)new CrucibleRenderContext(c2.getReview(), " ", null, repo));
    }

    private String getReplyToCommentPermId(Comment c2) {
        Comment replyTo = c2.getReplyToComment();
        return replyTo == null ? null : replyTo.getPermaId();
    }

    private List<GeneralCommentData> buildRepliesList(Comment comment, boolean withHtml) {
        Set<Comment> replies = comment.getComments();
        ArrayList<GeneralCommentData> repliesData = new ArrayList<GeneralCommentData>(replies.size());
        for (Comment c2 : replies) {
            if (c2.isDeleted() || c2.getDraft() && !c2.getUser().equals(this.getEffectiveUser())) continue;
            repliesData.add(this.buildGeneralCommentData(c2, withHtml));
        }
        return repliesData;
    }

    private Set<ReviewerData> getReviewers(final PermId<ReviewData> id, final ReviewerStatus reviewerStatus) {
        return this.txTemplate.execute(new TxCallback<Set<ReviewerData>>(){

            @Override
            public Set<ReviewerData> doInTransaction(TransactionStatus status) {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                DefaultReviewService.this.requireReviewPermission(UserActionManager.ACTION_VIEW, review);
                return DefaultReviewService.this.prepareReviewersData(review, reviewerStatus);
            }
        });
    }

    private Set<ReviewerData> prepareReviewersData(Review review, ReviewerStatus reviewerStatus) {
        HashSet<ReviewerData> reviewers = new HashSet<ReviewerData>();
        for (ReviewParticipant u2 : review.getParticipants()) {
            if (!u2.isReviewer()) continue;
            switch (reviewerStatus) {
                case ALL: {
                    reviewers.add(this.spiUtils.createReviewerData(u2));
                    break;
                }
                case COMPLETED: {
                    if (!u2.isAllComplete()) break;
                    reviewers.add(this.spiUtils.createReviewerData(u2));
                    break;
                }
                case UNCOMPLETED: {
                    if (u2.isAllComplete()) break;
                    reviewers.add(this.spiUtils.createReviewerData(u2));
                }
            }
        }
        return reviewers;
    }

    public Set<ReviewerData> getAllReviewers(PermId<ReviewData> id) {
        return this.getReviewers(id, ReviewerStatus.ALL);
    }

    public Set<ReviewerData> getCompletedReviewers(PermId<ReviewData> id) {
        return this.getReviewers(id, ReviewerStatus.COMPLETED);
    }

    public Set<ReviewerData> getUncompletedReviewers(PermId<ReviewData> id) {
        return this.getReviewers(id, ReviewerStatus.UNCOMPLETED);
    }

    public void addReviewers(final PermId<ReviewData> id, final String[] userNames) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws DbException {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                if (DefaultReviewService.this.hasReviewPermission(UserActionManager.ACTION_MOD_FILES, review)) {
                    for (String userName : userNames) {
                        FecruUser user = DefaultReviewService.this.getLicensedUser(userName);
                        if (DefaultReviewService.this.projectManager.isAllowedReviewer(review.getProject(), user)) {
                            boolean existingReviewer = review.isReviewer(user);
                            ReviewParticipant reviewParticipant = DefaultReviewService.this.reviewManager.addReviewer(review, user);
                            if (!reviewParticipant.isReviewer()) {
                                throw new IllegalArgumentException("Could not add reviewer '" + userName + "' as they are already the author and/or moderator.");
                            }
                            if (!review.getState().isReviewState() || existingReviewer) continue;
                            DefaultReviewService.this.notificationManager.noteGeneralMsg(review, DefaultReviewService.this.effectiveUserProvider.getEffectiveUser(), user, "You have been added as a reviewer in " + review.getPermaId());
                            continue;
                        }
                        throw new NotPermittedException(String.format("User %s is not in the list of allowed reviewers for project %s and therefore cannot be added to review %s. No reviewers added.", user.getUsername(), review.getProject().getProjKey(), review.getPermaId()));
                    }
                } else {
                    if (DefaultReviewService.this.getEffectiveUser() == null) {
                        throw new NotPermittedException("Anonymous user cannot add reviewers to a review.");
                    }
                    if (userNames.length == 1 && DefaultReviewService.this.getEffectiveUser().getUsername().equals(userNames[0]) && review.isAllowReviewerToJoin() && DefaultReviewService.this.projectManager.isAllowedReviewer(review.getProject(), DefaultReviewService.this.getEffectiveUser())) {
                        ReviewParticipant reviewParticipant = DefaultReviewService.this.reviewManager.addReviewer(review, DefaultReviewService.this.getEffectiveUser());
                        if (!reviewParticipant.isReviewer()) {
                            throw new IllegalArgumentException("Could not add reviewer '" + userNames[0] + "' as they are already the author and/or moderator.");
                        }
                    } else {
                        throw new NotPermittedException("You do not have permission to join this review.");
                    }
                }
                return null;
            }
        });
    }

    private FecruUser getLicensedUser(String username) throws DbException {
        FecruUser user = this.userManager.getLicensedUser(username);
        if (user == null) {
            throw new NotFoundException("The user named '" + username + "' is not a Crucible user.");
        }
        return user;
    }

    private FecruUser getUser(String username) throws DbException {
        FecruUser user = this.userManager.getUser(username);
        if (user == null) {
            throw new NotFoundException("The user named '" + username + "' does not exist.");
        }
        return user;
    }

    public void removeReviewer(final PermId<ReviewData> id, final String userName) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
                FecruUser user = DefaultReviewService.this.getUser(userName);
                if (review.isReviewer(user)) {
                    review.removeReviewer(user);
                    if (review.getState().isReviewState()) {
                        DefaultReviewService.this.notificationManager.noteGeneralMsg(review, DefaultReviewService.this.effectiveUserProvider.getEffectiveUser(), user, "You have been removed as a reviewer in " + review.getPermaId());
                    }
                }
                return null;
            }
        });
    }

    public List<UserData> remindIncompleteReviewers(final PermId<ReviewData> id) {
        return this.txTemplate.execute(new TxCallback<List<UserData>>(){

            @Override
            public List<UserData> doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
                FecruUser currentUser = DefaultReviewService.this.effectiveUserProvider.getEffectiveUser();
                ReviewReminderNotificationEvent notification = new ReviewReminderNotificationEvent(currentUser, review);
                HibernateUtil.currentSession().save((Object)notification);
                Collection<FecruUser> recipients = notification.getDefaultRecipients();
                notification.doNotify(recipients);
                ArrayList<UserData> recipientData = new ArrayList<UserData>(recipients.size());
                for (FecruUser user : recipients) {
                    recipientData.add(DefaultReviewService.this.spiUserUtils.createUserData(user));
                }
                return recipientData;
            }
        });
    }

    public List<UserData> remindIncompleteReviewers(final PermId<ReviewData> id, final List<String> recipients, final String message) {
        return this.txTemplate.execute(new TxCallback<List<UserData>>(){

            @Override
            public List<UserData> doInTransaction(TransactionStatus status) throws Exception {
                Review review = DefaultReviewService.this.getRequiredReview((PermId<ReviewData>)id);
                DefaultReviewService.this.requireOpenReviewPermission(UserActionManager.ACTION_MOD_FILES, review);
                FecruUser currentUser = DefaultReviewService.this.effectiveUserProvider.getEffectiveUser();
                ReviewReminderNotificationEvent notification = new ReviewReminderNotificationEvent(currentUser, review);
                notification.setMessage(message);
                HibernateUtil.currentSession().save((Object)notification);
                ArrayList<FecruUser> recipientUsers = new ArrayList<FecruUser>(recipients.size());
                ArrayList<UserData> recipientData = new ArrayList<UserData>(recipients.size());
                for (String username : recipients) {
                    FecruUser user = DefaultReviewService.this.userManager.getLicensedUser(username);
                    if (user == null || review.getParticipant(user) == null) continue;
                    recipientUsers.add(user);
                    recipientData.add(DefaultReviewService.this.spiUserUtils.createUserData(user));
                }
                notification.doNotify(recipientUsers);
                return recipientData;
            }
        });
    }

    public boolean hasPermission(PermId<ReviewData> id, String actionName) throws NotFoundException {
        Review review = this.getRequiredReview(id);
        return this.hasReviewPermission(actionName, review);
    }

    public String extractReviewTitle(String text) {
        return ReviewUtil.extractReviewTitle(text);
    }

    protected boolean hasReviewPermission(String actionName, Project project) {
        PermissionScheme ps = project.getPermissionScheme();
        return this.permissionManager.canPrincipalDoAction(ps, this.getEffectivePrincipal(), null, actionName, null);
    }

    private boolean hasReviewPermission(String actionName, Review review) {
        PermissionScheme ps = review.getProject().getPermissionScheme();
        return this.permissionManager.canPrincipalDoAction(ps, this.getEffectivePrincipal(), null, actionName, review);
    }

    private boolean hasReviewPermission(String actionName, Review review, ReviewUtil.ActionAllowedCache permissionsCache) {
        return ReviewUtil.principalCanDoReviewAction(this.getEffectivePrincipal(), actionName, review, permissionsCache);
    }

    private void requirePermission(String actionName, Project project) {
        if (!this.hasReviewPermission(actionName, project)) {
            UserActionManager.Action a2 = UserActionManager.getInstance().getAction(actionName);
            throw new NotPermittedException("You do not have permission to " + a2.getDisplayName() + " in project " + project.getName());
        }
    }

    private void requireReviewPermission(String actionName, Review review) {
        if (!this.hasReviewPermission(actionName, review)) {
            UserActionManager.Action a2 = UserActionManager.getInstance().getAction(actionName);
            throw new NotPermittedException("You do not have permission to " + a2.getDisplayName() + " the review " + review.getPermaId());
        }
    }

    private void requireOpenReviewPermission(String actionName, Review review) {
        if (!review.getState().isDraftMetaState() && !review.getState().isOpenMetaState()) {
            throw new IllegalStateException(String.format("Review %s must be in draft or open to perform action %s.", review.getPermaId(), actionName));
        }
        this.requireReviewPermission(actionName, review);
    }

    private static enum ReviewerStatus {
        ALL,
        COMPLETED,
        UNCOMPLETED;

    }
}

