/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.scm.HasChangelogBrowser;
import com.atlassian.crucible.scm.HasDirectoryBrowser;
import com.atlassian.crucible.scm.SCMModule;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.crucible.spi.data.PluginRepositoryData;
import com.atlassian.crucible.spi.data.RepositoryData;
import com.atlassian.crucible.spi.data.RepositoryDataSearchCriteria;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.RepositoryService;
import com.atlassian.fecru.page.OnePageRequest;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.util.functional.LazyIterable;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryService")
@AvailableToPlugins
public class DefaultRepositoryService
implements RepositoryService {
    public static final String REPO_DATA_TYPE_PLUGIN = "plugin";
    private final SCMModuleManager scmModuleManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final UserManager userManager;
    private final RepositoryManager repositoryManager;
    private final ConfigDocument.Config config;
    private final Predicate<RepositoryHandle> accessibleRepositoryPredicate = new Predicate<RepositoryHandle>(){

        public boolean apply(RepositoryHandle handle) {
            return DefaultRepositoryService.this.isAccessible(handle);
        }
    };
    private final Supplier<Iterable<RepositoryHandle>> repositoryHandleSupplier = new Supplier<Iterable<RepositoryHandle>>(){

        public Collection<RepositoryHandle> get() {
            return DefaultRepositoryService.this.repositoryManager.getHandles();
        }
    };
    private final Supplier<Iterable<SCMRepository>> scmRepositorySupplier = new Supplier<Iterable<SCMRepository>>(){

        public Collection<SCMRepository> get() {
            return DefaultRepositoryService.this.scmModuleManager.getRepositories();
        }
    };
    private static final Function<RepositoryHandle, RepositoryData> REPOSITORY_HANDLE_TO_DATA = new Function<RepositoryHandle, RepositoryData>(){

        public RepositoryData apply(RepositoryHandle handle) {
            return DefaultRepositoryService.createRepositoryData(handle);
        }
    };

    @Autowired
    public DefaultRepositoryService(EffectiveUserProvider effectiveUserProvider, SCMModuleManager mm, UserManager userManager, RepositoryManager repositoryManager, ConfigDocument.Config config) {
        this.scmModuleManager = mm;
        this.effectiveUserProvider = effectiveUserProvider;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.config = config;
    }

    public List<RepositoryData> getRepositories() {
        return ImmutableList.copyOf((Iterable)this.getRepositories(new RepositoryDataSearchCriteria.Builder().build(), OnePageRequest.createNoLimit()).getValues());
    }

    public Page<RepositoryData> getRepositories(RepositoryDataSearchCriteria criteria, PageRequest pageRequest) {
        Iterable allRepos = Iterables.concat(this.getFishEyeRepositories(criteria), this.getLightScmRepositories(criteria));
        return Page.Builder.buildFromAllDataIterable((Iterable)allRepos, (PageRequest)pageRequest);
    }

    public RepositoryData getRepository(String name) {
        RepositoryHandle rh = this.repositoryManager.getRepository(name);
        if (rh == null) {
            SCMRepository pluginRepository = this.scmModuleManager.getRepository(name);
            if (pluginRepository == null) {
                throw new NotFoundException("No such repository '" + name + "'");
            }
            this.requireSCMPermission();
            return this.createRepositoryData(pluginRepository);
        }
        if (!this.isAccessible(rh)) {
            throw new NotPermittedException("You are not allowed to access repository " + name);
        }
        return DefaultRepositoryService.createRepositoryData(rh);
    }

    public SCMRepository getSCMRepository(String name) {
        this.requireSCMPermission();
        return this.scmModuleManager.getRepository(name);
    }

    private Iterable<RepositoryData> getFishEyeRepositories(RepositoryDataSearchCriteria criteria) {
        if (!criteria.getTypeFilter().isEmpty() && Collections.disjoint(ScmType.ALL_SCM_TYPE_IDS, criteria.getTypeFilter())) {
            return Collections.emptyList();
        }
        return FluentIterable.from(LazyIterable.lazyMemoizedIterable(this.repositoryHandleSupplier)).filter(this.accessibleRepositoryPredicate).transform(REPOSITORY_HANDLE_TO_DATA).filter(this.searchCriteriaToPredicate(criteria));
    }

    private Iterable<RepositoryData> getLightScmRepositories(RepositoryDataSearchCriteria criteria) {
        if (!this.hasSCMPermission() || !criteria.getTypeFilter().isEmpty() && !criteria.getTypeFilter().contains(REPO_DATA_TYPE_PLUGIN)) {
            return Collections.emptyList();
        }
        return FluentIterable.from(LazyIterable.lazyMemoizedIterable(this.scmRepositorySupplier)).transform((Function)new Function<SCMRepository, RepositoryData>(){

            public RepositoryData apply(SCMRepository scmRepo) {
                return DefaultRepositoryService.this.createRepositoryData(scmRepo);
            }
        }).filter(this.searchCriteriaToPredicate(criteria));
    }

    private SCMModule getModuleForSCMRepository(SCMRepository repo) {
        for (SCMModule module : this.scmModuleManager.getModules()) {
            for (SCMRepository r2 : module.getRepositories()) {
                if (!repo.getName().equals(r2.getName())) continue;
                return module;
            }
        }
        return null;
    }

    private boolean isAccessible(RepositoryHandle handle) {
        return this.userManager.hasPermissionToAccess(this.effectiveUserProvider.getEffectivePrincipal(), handle);
    }

    private RepositoryData createRepositoryData(SCMRepository repo) {
        return new PluginRepositoryData(repo.getName(), REPO_DATA_TYPE_PLUGIN, true, this.getModuleForSCMRepository(repo).getModuleDescriptor().getCompleteKey(), repo.isAvailable(this.effectiveUserProvider.getEffectivePrincipal()), repo.getDescription(), repo.getStateDescription(), repo instanceof HasDirectoryBrowser, repo instanceof HasChangelogBrowser);
    }

    private static RepositoryData createRepositoryData(RepositoryHandle rh) {
        ScmType repoType = rh.getCfg().getRepositoryType();
        if (repoType == null) {
            throw new RuntimeException("Unknown repository type:" + (Object)((Object)rh.getCfg().getRepositoryType()));
        }
        return repoType.getRepositoryData(rh);
    }

    private void requireSCMPermission() throws NotPermittedException {
        if (!this.hasSCMPermission()) {
            throw new NotPermittedException("You must be logged in to access Crucible SCM plugin repositories.");
        }
    }

    private boolean hasSCMPermission() {
        Principal principal = this.effectiveUserProvider.getEffectivePrincipal();
        SecurityType security = this.config.getSecurity();
        boolean anonymousAllowed = security.isSetAllowCruAnon() ? security.getAllowCruAnon() : security.getAllowAnon();
        return Principal.SuperUser.isSuperUser((Principal)principal) || !Principal.Anonymous.isAnon((Principal)principal) || anonymousAllowed;
    }

    private Predicate<RepositoryData> searchCriteriaToPredicate(final RepositoryDataSearchCriteria criteria) {
        return new Predicate<RepositoryData>(){

            public boolean apply(RepositoryData repo) {
                if (null != criteria.getEnabledFilter() && criteria.getEnabledFilter().booleanValue() != repo.isEnabled()) {
                    return false;
                }
                if (null != criteria.getAvailableFilter() && criteria.getAvailableFilter().booleanValue() != repo.isAvailable()) {
                    return false;
                }
                if (!criteria.getTypeFilter().isEmpty() && !criteria.getTypeFilter().contains(repo.getType())) {
                    return false;
                }
                return Strings.isNullOrEmpty((String)criteria.getNameFilter()) || repo.getName().toLowerCase(Locale.US).contains(criteria.getNameFilter().toLowerCase(Locale.US));
            }
        };
    }
}

