/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.GroupService;
import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.atlassian.crucible.spi.services.ProjectService;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResource;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectKeyException;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component(value="projectService")
@AvailableToPlugins
public class DefaultProjectService
implements ProjectService {
    private static final Pattern PROJECT_KEY_PATTERN = Pattern.compile("([A-Z0-9\\-]+)");
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final SecureProjectManager secureProjectManager;
    private final ReviewManager reviewManager;
    private final LinkerFactory linkerFactory;
    private final EffectiveUserProvider effectiveUserProvider;
    private final SPIUtils spiUtils;
    private final SPIUserUtils spiUserUtils;
    private final GroupService groupService;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultProjectService(EffectiveUserProvider effectiveUserProvider, ProjectManager projectManager, PermissionManager permissionManager, SecureProjectManager secureProjectManager, LinkerFactory linkerFactory, SPIUtils spiUtils, SPIUserUtils spiUserUtils, GroupService groupService, ReviewManager reviewManager, TxTemplate txTemplate) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.secureProjectManager = secureProjectManager;
        this.linkerFactory = linkerFactory;
        this.spiUtils = spiUtils;
        this.spiUserUtils = spiUserUtils;
        this.groupService = groupService;
        this.reviewManager = reviewManager;
        this.txTemplate = txTemplate;
    }

    public List<ProjectData> getAllProjects() {
        return this.getAllProjects(true);
    }

    public int countProjects(ProjectSearchCriteria projectSearchCriteria) {
        return this.projectManager.countProjects(projectSearchCriteria);
    }

    public Page<ProjectData> searchProjects(ProjectSearchCriteria projectSearchCriteria, PageRequest pageRequest) {
        Function projectToProjectData = project -> this.spiUtils.createProjectData((Project)project, false);
        if (this.effectiveUserProvider.isAdmin()) {
            Page<Project> projectPage = this.projectManager.searchAllProjects(projectSearchCriteria, pageRequest);
            return projectPage.transform(projectToProjectData);
        }
        List<Project> visibleProjects = this.secureProjectManager.getVisibleProjects(this.effectiveUserProvider.getEffectivePrincipal());
        List visibleProjectsData = visibleProjects.stream().map(arg_0 -> ((Function)projectToProjectData).apply(arg_0)).collect(Collectors.toList());
        Iterable filteredProjects = Iterables.filter(visibleProjectsData, (Predicate)projectSearchCriteria.filterPredicate());
        return Page.Builder.buildFromAllDataIterable((Iterable)filteredProjects, (PageRequest)pageRequest);
    }

    public PagedResourceIterable<ProjectData> searchProjectsIterable(ProjectSearchCriteria projectSearchCriteria, PageRequest firstPageRequest) {
        return new PagedResourceIterable<ProjectData>(pageRequest -> this.searchProjects(projectSearchCriteria, pageRequest), firstPageRequest);
    }

    public void create(final ProjectData projectData) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                DefaultProjectService.this.daoCreateProject(projectData);
                return null;
            }
        });
    }

    public void update(final ProjectData projectData) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                DefaultProjectService.this.daoUpdateProject(projectData);
                return null;
            }
        });
    }

    public void delete(String key) {
        this.delete(key, false);
    }

    public void delete(final String key, final boolean deleteReviewsInProject) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                if (DefaultProjectService.this.projectManager.isDefaultProject(key)) {
                    throw new IllegalArgumentException(String.format("Can't delete default project: %s", key));
                }
                Project project = DefaultProjectService.this.projectManager.getProjectByKey(key);
                int countReviewsInProject = DefaultProjectService.this.projectManager.countReviewsInProject(project);
                if (countReviewsInProject > 0) {
                    if (deleteReviewsInProject) {
                        DefaultProjectService.this.projectManager.deleteAllReviews(project, DefaultProjectService.this.effectiveUserProvider.getEffectiveUser(), DefaultProjectService.this.reviewManager);
                    } else {
                        throw new IllegalStateException(String.format("Can't delete project: %s with %d reviews", key, countReviewsInProject));
                    }
                }
                if (!DefaultProjectService.this.projectManager.deleteProject(project)) {
                    throw new IllegalStateException(String.format("Could not delete project: %s", key));
                }
                return null;
            }
        });
    }

    private void validateAndSetDefaultsOnCreate(ProjectData projectData) throws IllegalArgumentException {
        this.validateKey(projectData, false);
        this.validateName(projectData, false);
        if (this.projectManager.projectExists(projectData.getKey())) {
            throw new IllegalArgumentException(String.format("Project with key: %s already exists.", projectData.getKey()));
        }
        PermissionScheme permissionScheme = this.validatePermissionSchemeIdAndNameConsistency(projectData, true);
        if (permissionScheme.getRequiresModerator()) {
            projectData.setModeratorEnabled(true);
        }
        if (projectData.getStoreRevisions() == null) {
            projectData.setStoreRevisions(Boolean.valueOf(true));
        }
    }

    private Project daoCreateProject(ProjectData projectData) throws IOException {
        this.validateAndSetDefaultsOnCreate(projectData);
        Project p2 = this.projectManager.createProject(projectData.getName(), projectData.getKey());
        projectData.setId(p2.getId().intValue());
        this.daoUpdateProject(projectData);
        return p2;
    }

    private PermissionScheme validatePermissionSchemeIdAndNameConsistency(ProjectData projectData, boolean setDefault) {
        Preconditions.checkArgument((projectData.getPermissionSchemeId() >= 0 ? 1 : 0) != 0, (String)"projectData.permissionSchemeId is negative: %s", (Object[])new Object[]{projectData.getPermissionSchemeId()});
        if (projectData.getPermissionSchemeId() > 0 && projectData.getPermissionSchemeName() != null) {
            PermissionScheme permissionSchemeById = this.permissionManager.findPermissionSchemeById(projectData.getPermissionSchemeId());
            PermissionScheme permissionSchemeByName = this.permissionManager.findPermissionSchemeByName(projectData.getPermissionSchemeName());
            Preconditions.checkArgument((boolean)permissionSchemeById.getId().equals(permissionSchemeByName.getId()), (String)"projectData.permissionSchemeId and projectData.permissionSchemeName are not consistent, %s <> %s", (Object[])new Object[]{permissionSchemeById, permissionSchemeByName});
            return permissionSchemeById;
        }
        if (projectData.getPermissionSchemeId() > 0 && projectData.getPermissionSchemeName() == null) {
            PermissionScheme permissionSchemeById = this.permissionManager.findPermissionSchemeById(projectData.getPermissionSchemeId());
            Preconditions.checkArgument((permissionSchemeById != null ? 1 : 0) != 0, (String)"could not find permission scheme with given id: %s", (Object[])new Object[]{projectData.getPermissionSchemeId()});
            projectData.setPermissionSchemeName(permissionSchemeById.getName());
            return permissionSchemeById;
        }
        if (projectData.getPermissionSchemeId() == 0 && projectData.getPermissionSchemeName() != null) {
            PermissionScheme permissionSchemeByName = this.permissionManager.findPermissionSchemeByName(projectData.getPermissionSchemeName());
            Preconditions.checkArgument((permissionSchemeByName != null ? 1 : 0) != 0, (String)"could not find permission scheme with given name: %s", (Object[])new Object[]{projectData.getPermissionSchemeName()});
            projectData.setPermissionSchemeId(permissionSchemeByName.getId().intValue());
            return permissionSchemeByName;
        }
        if (setDefault) {
            PermissionScheme permissionScheme = this.permissionManager.getDefaultPermissionScheme();
            projectData.setPermissionSchemeName(permissionScheme.getName());
            projectData.setPermissionSchemeId(permissionScheme.getId().intValue());
            return permissionScheme;
        }
        return null;
    }

    private void validateKey(ProjectData projectData, boolean canBeNull) {
        projectData.setKey(Strings.emptyToNull((String)projectData.getKey()));
        if (!canBeNull) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectData.getKey()) ? 1 : 0) != 0, (Object)"project key must be set");
        }
        if (projectData.getKey() != null) {
            Matcher m2 = PROJECT_KEY_PATTERN.matcher(projectData.getKey());
            Preconditions.checkArgument((boolean)m2.matches(), (String)"Invalid project key, only alphanumeric and uppercase values are allowed: %s", (Object[])new Object[]{PROJECT_KEY_PATTERN.pattern()});
        }
    }

    private void validateName(ProjectData projectData, boolean canBeNull) {
        projectData.setName(Strings.emptyToNull((String)projectData.getName()));
        if (!canBeNull) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectData.getName()) ? 1 : 0) != 0, (Object)"project name must be set");
        }
    }

    private void validateOnUpdate(ProjectData projectData) throws IllegalArgumentException {
        Preconditions.checkArgument((projectData.getId() > 0 ? 1 : 0) != 0, (Object)"ID must be a positive integer.");
        this.validateKey(projectData, true);
        this.validateName(projectData, true);
        Preconditions.checkArgument((projectData.getDefaultDuration() == null || projectData.getDefaultDuration() >= 0 ? 1 : 0) != 0, (String)"Default duration can't be negative: %s", (Object[])new Object[]{projectData.getDefaultDuration()});
        this.validatePermissionSchemeIdAndNameConsistency(projectData, false);
    }

    private void daoUpdateProject(ProjectData projectData) throws ProjectKeyException {
        this.validateOnUpdate(projectData);
        Project p2 = this.projectManager.getProjectById(projectData.getId());
        if (p2 == null) {
            throw new IllegalArgumentException("Project " + projectData.getId() + " does not exist.");
        }
        if (projectData.getKey() != null && !p2.getProjKey().equals(projectData.getKey())) {
            if (this.projectManager.getProjectByKey(projectData.getKey()) != null) {
                throw new ProjectKeyException();
            }
            this.projectManager.changeProjectKey(p2, projectData.getKey());
        }
        p2.setAllowReviewersToJoin(projectData.isAllowReviewersToJoin());
        if (projectData.getStoreRevisions() != null) {
            p2.setStoreRevisions(projectData.getStoreRevisions());
        }
        if (projectData.getDefaultModerator() != null) {
            p2.setDefaultModerator((FecruUser)this.userNameToUser().apply((Object)projectData.getDefaultModerator()));
        }
        if (projectData.getDefaultRepositoryName() != null) {
            p2.setDefaultRepositoryName(projectData.getDefaultRepositoryName());
        }
        if (projectData.getDefaultReviewerUsers() != null) {
            p2.setDefaultReviewerUsers(Sets.newHashSet((Iterable)Iterables.transform((Iterable)projectData.getDefaultReviewerUsers(), this.userNameToUser())));
        }
        if (projectData.getDefaultReviewerGroups() != null) {
            p2.setDefaultReviewerGroups(projectData.getDefaultReviewerGroups().stream().map(UserManager.GROUPNAME_NORMALIZATION).collect(Collectors.toSet()));
        }
        if (projectData.getAllowedReviewerUsers() != null) {
            p2.setAllowedReviewerUsers(Sets.newHashSet((Iterable)Iterables.transform((Iterable)projectData.getAllowedReviewerUsers(), this.userNameToUser())));
        }
        if (projectData.getAllowedReviewerGroups() != null) {
            p2.setAllowedReviewerGroups(projectData.getAllowedReviewerGroups().stream().map(UserManager.GROUPNAME_NORMALIZATION).collect(Collectors.toSet()));
        }
        if (projectData.getKey() != null) {
            p2.setProjKey(projectData.getKey());
        }
        if (projectData.getName() != null) {
            p2.setName(projectData.getName());
        }
        if (projectData.getPermissionSchemeName() != null) {
            p2.setPermissionScheme(this.permissionManager.findPermissionSchemeByName(projectData.getPermissionSchemeName()));
        }
        if (projectData.getDefaultDuration() != null) {
            p2.setDefaultDuration(projectData.getDefaultDuration());
        }
        if (projectData.getDefaultObjectives() != null) {
            p2.setDefaultObjectives(projectData.getDefaultObjectives());
        }
        p2.setModeratorDisabled(!projectData.isModeratorEnabled());
        this.linkerFactory.clearCrucibleLinkerCache();
    }

    private Function<String, FecruUser> userNameToUser() {
        return userName -> {
            if (Strings.isNullOrEmpty((String)userName)) {
                return null;
            }
            return this.spiUserUtils.getUserByName((String)userName);
        };
    }

    private void validateGroupExists(String groupName) throws IllegalArgumentException {
        if (!this.groupService.exist(groupName)) {
            throw new IllegalArgumentException(String.format("Group %s not found", groupName));
        }
    }

    public Page<String> getProjectDefaultReviewerUsers(String projectKey, PageRequest pageRequest) {
        this.ensurePermissionToViewProject(projectKey);
        return this.projectManager.getProjectDefaultReviewerUsers(projectKey, pageRequest).transform(user -> user.getUsername());
    }

    public PagedResourceIterable<String> getProjectDefaultReviewerUsersIterable(String projectKey, PageRequest firstPageRequest) {
        return new PagedResourceIterable<String>(pageRequest -> this.getProjectDefaultReviewerUsers(projectKey, pageRequest), firstPageRequest);
    }

    public boolean addProjectDefaultReviewerUser(String projectKey, String username) {
        this.effectiveUserProvider.ensureAdminPermission();
        FecruUser user = this.spiUserUtils.getUserByName(username);
        return this.projectManager.addProjectDefaultReviewerUser(projectKey, user);
    }

    public boolean deleteProjectDefaultReviewerUser(String projectKey, String username) {
        this.effectiveUserProvider.ensureAdminPermission();
        FecruUser user = this.spiUserUtils.getUserByName(username);
        return this.projectManager.deleteProjectDefaultReviewerUser(projectKey, user);
    }

    public Page<String> getProjectDefaultReviewerGroups(String projectKey, PageRequest pageRequest) {
        this.ensurePermissionToViewProject(projectKey);
        return this.projectManager.getProjectDefaultReviewerGroups(projectKey, pageRequest);
    }

    public PagedResourceIterable<String> getProjectDefaultReviewerGroupsIterable(String projectKey, PageRequest fistPageRequest) {
        return new PagedResourceIterable<String>(pageRequest -> this.getProjectDefaultReviewerGroups(projectKey, pageRequest), fistPageRequest);
    }

    public boolean addProjectDefaultReviewerGroup(String projectKey, String groupName) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.validateGroupExists(groupName);
        return this.projectManager.addProjectDefaultReviewerGroup(projectKey, groupName);
    }

    public boolean deleteProjectDefaultReviewerGroup(String projectKey, String groupName) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.validateGroupExists(groupName);
        return this.projectManager.deleteProjectDefaultReviewerGroup(projectKey, groupName);
    }

    public Page<String> getProjectAllowedReviewerUsers(String projectKey, PageRequest pageRequest) {
        this.ensurePermissionToViewProject(projectKey);
        return this.projectManager.getProjectAllowedReviewerUsers(projectKey, pageRequest).transform(user -> user.getUsername());
    }

    public PagedResourceIterable<String> getProjectAllowedReviewerUsersIterable(final String projectKey, PageRequest firstPageRequest) {
        return new PagedResourceIterable<String>(new PagedResource<String>(){

            @Override
            public Page<String> getPage(PageRequest pageRequest) {
                return DefaultProjectService.this.getProjectAllowedReviewerUsers(projectKey, pageRequest);
            }
        }, firstPageRequest);
    }

    public boolean addProjectAllowedReviewerUser(String projectKey, String username) {
        this.effectiveUserProvider.ensureAdminPermission();
        FecruUser user = this.spiUserUtils.getUserByName(username);
        return this.projectManager.addProjectAllowedReviewerUser(projectKey, user);
    }

    public boolean deleteProjectAllowedReviewerUser(String projectKey, String username) {
        this.effectiveUserProvider.ensureAdminPermission();
        FecruUser user = this.spiUserUtils.getUserByName(username);
        return this.projectManager.deleteProjectAllowedReviewerUser(projectKey, user);
    }

    public Page<String> getProjectAllowedReviewerGroups(String projectKey, PageRequest pageRequest) {
        this.ensurePermissionToViewProject(projectKey);
        return this.projectManager.getProjectAllowedReviewerGroups(projectKey, pageRequest);
    }

    public PagedResourceIterable<String> getProjectAllowedReviewerGroupsIterable(final String projectKey, PageRequest firstPageRequest) {
        return new PagedResourceIterable<String>(new PagedResource<String>(){

            @Override
            public Page<String> getPage(PageRequest pageRequest) {
                return DefaultProjectService.this.getProjectAllowedReviewerGroups(projectKey, pageRequest);
            }
        }, firstPageRequest);
    }

    public boolean addProjectAllowedReviewerGroup(String projectKey, String groupName) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.validateGroupExists(groupName);
        return this.projectManager.addProjectAllowedReviewerGroup(projectKey, groupName);
    }

    public boolean deleteProjectAllowedReviewerGroup(String projectKey, String groupName) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.validateGroupExists(groupName);
        return this.projectManager.deleteProjectAllowedReviewerGroup(projectKey, groupName);
    }

    public boolean exist(String projectKey) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.projectManager.getProjectByKey(projectKey) != null;
    }

    public void moveAllReviews(String sourceProjectKey, String destinationProjectKey) {
        this.effectiveUserProvider.ensureAdminPermission();
        Project destinationProject = this.projectManager.getProjectByKey(destinationProjectKey);
        Preconditions.checkArgument((destinationProject != null ? 1 : 0) != 0, (String)"Destination project with key: %s not found", (Object[])new Object[]{destinationProjectKey});
        Project sourceProject = this.projectManager.getProjectByKey(sourceProjectKey);
        Preconditions.checkArgument((sourceProject != null ? 1 : 0) != 0, (String)"Source project with key: %s not found", (Object[])new Object[]{sourceProjectKey});
        this.projectManager.moveAllReviews(sourceProject, destinationProject);
    }

    @Deprecated
    public List<ProjectData> getAllProjects(boolean excludeAllowedReviewers) {
        Function projectToProjectData = project -> this.spiUtils.createProjectData((Project)project, !excludeAllowedReviewers);
        if (this.effectiveUserProvider.isAdmin()) {
            return ImmutableList.copyOf((Collection)Lists.transform(this.projectManager.getAllProjects(), (Function)projectToProjectData));
        }
        return ImmutableList.copyOf((Collection)Lists.transform(this.secureProjectManager.getVisibleProjects(this.effectiveUserProvider.getEffectivePrincipal()), (Function)projectToProjectData));
    }

    @Nullable
    public Integer getProjectId(String projectKey) {
        this.effectiveUserProvider.ensureAdminPermission();
        Optional project = Optional.fromNullable((Object)this.projectManager.getProjectByKey(projectKey));
        if (project.isPresent()) {
            return ((Project)project.get()).getId();
        }
        return null;
    }

    @Nullable
    public ProjectData getProject(String projectKey) {
        return this.getProject(projectKey, true);
    }

    @Nullable
    public ProjectData getProject(String projectKey, boolean excludeAllowedReviewers) {
        Project p2 = this.projectManager.getProjectByKey(projectKey);
        if (p2 != null && (this.effectiveUserProvider.isAdmin() || ReviewUtil.principalCanDoProjectAction(this.effectiveUserProvider.getEffectivePrincipal(), UserActionManager.ACTION_VIEW, p2))) {
            return this.spiUtils.createProjectData(p2, !excludeAllowedReviewers);
        }
        return null;
    }

    @Nullable
    public ProjectData getProject(Integer id) {
        Project p2 = this.projectManager.getProjectById(id);
        if (p2 != null && (this.effectiveUserProvider.isAdmin() || ReviewUtil.principalCanDoProjectAction(this.effectiveUserProvider.getEffectivePrincipal(), UserActionManager.ACTION_VIEW, p2))) {
            return this.spiUtils.createProjectData(p2, false);
        }
        return null;
    }

    public boolean hasPermission(String projectKey, String actionName) {
        Project project = this.projectManager.getProjectByKey(projectKey);
        boolean isViewReview = UserActionManager.Action.ACTION_VIEW.getName().equals(actionName);
        return project != null && (isViewReview && this.effectiveUserProvider.isAdmin() || ReviewUtil.principalCanDoProjectAction(this.effectiveUserProvider.getEffectivePrincipal(), actionName, project));
    }

    private boolean ensurePermissionToViewProject(String projectKey) {
        Project p2 = this.projectManager.getProjectByKey(projectKey);
        return p2 != null && (this.effectiveUserProvider.isAdmin() || ReviewUtil.principalCanDoProjectAction(this.effectiveUserProvider.getEffectivePrincipal(), UserActionManager.ACTION_VIEW, p2));
    }
}

