/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.NamedPrincipalAssociationData;
import com.atlassian.crucible.spi.data.PermissionSchemeData;
import com.atlassian.crucible.spi.data.PrincipalAssociationData;
import com.atlassian.crucible.spi.services.NamedPrincipalAssociationSearchCriteria;
import com.atlassian.crucible.spi.services.PermissionSchemeSearchCriteria;
import com.atlassian.crucible.spi.services.PermissionSchemeService;
import com.atlassian.crucible.spi.services.PrincipalAssociationSearchCriteria;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.BasePrincipalAssociation;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.PrincipalAssociation;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component(value="permissionSchemeService")
@AvailableToPlugins
public class DefaultPermissionSchemeService
implements PermissionSchemeService {
    private static final Pattern PERMISSION_SCHEME_NAME_PATTERN = Pattern.compile("([A-Za-z0-9\\-]+)");
    private final PermissionManager permissionManager;
    private final UserManager userManager;
    private final ReviewManager reviewManager;
    private final UserActionManager userActionManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultPermissionSchemeService(PermissionManager permissionManager, UserManager userManager, ReviewManager reviewManager, EffectiveUserProvider effectiveUserProvider, TxTemplate txTemplate) {
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.reviewManager = reviewManager;
        this.userActionManager = UserActionManager.getInstance();
        this.effectiveUserProvider = effectiveUserProvider;
        this.txTemplate = txTemplate;
    }

    @Nullable
    public String getName(int id) {
        this.effectiveUserProvider.ensureAdminPermission();
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeById(id);
        if (permissionScheme == null) {
            return null;
        }
        return permissionScheme.getName();
    }

    @Nullable
    public Integer getId(String name) {
        this.effectiveUserProvider.ensureAdminPermission();
        if (name == null) {
            return null;
        }
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(name);
        if (permissionScheme == null) {
            return null;
        }
        return permissionScheme.getId();
    }

    public int countPermissionSchemes(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.permissionManager.countPermissionSchemes(permissionSchemeSearchCriteria);
    }

    public Page<PermissionSchemeData> searchPermissionSchemes(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria, PageRequest pageRequest) {
        this.effectiveUserProvider.ensureAdminPermission();
        Page<PermissionScheme> permissionSchemePage = this.permissionManager.searchPermissionSchemes(permissionSchemeSearchCriteria, pageRequest);
        return permissionSchemePage.transform(this.permissionSchemeToPermissionSchemeData());
    }

    public PermissionSchemeData findByName(String name) {
        this.effectiveUserProvider.ensureAdminPermission();
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(name);
        return (PermissionSchemeData)this.permissionSchemeToPermissionSchemeData().apply((Object)permissionScheme);
    }

    public Page<NamedPrincipalAssociationData> searchUsersPrincipalAssociation(String permissionSchemeName, NamedPrincipalAssociationSearchCriteria namedPrincipalAssociationSearchCriteria, PageRequest pageRequest) {
        this.effectiveUserProvider.ensureAdminPermission();
        Preconditions.checkNotNull((Object)permissionSchemeName);
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(permissionSchemeName);
        ArrayList<UserPA> usersPA = new ArrayList<UserPA>(permissionScheme.getUserPAs());
        Iterable usersPAData = Iterables.transform(usersPA, this.principalAssociationToNamedPrincipalAssociationToData());
        Iterable filteredUsersPA = Iterables.filter((Iterable)usersPAData, (Predicate)namedPrincipalAssociationSearchCriteria.filterPredicate());
        return Page.Builder.buildFromAllDataIterable((Iterable)filteredUsersPA, (PageRequest)pageRequest);
    }

    private String checkUserNameValid(NamedPrincipalAssociationData principalAssociationData) {
        String userName = principalAssociationData.getName();
        Preconditions.checkState((this.userManager.getUser(userName) != null ? 1 : 0) != 0, (Object)("User: " + userName + " not found"));
        return userName;
    }

    public boolean addPermissionSchemeUser(final String permissionSchemeName, final NamedPrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                String userName = DefaultPermissionSchemeService.this.checkUserNameValid(principalAssociationData);
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.addUserAction(userName, action.getName());
            }
        });
    }

    public boolean deletePermissionSchemeUser(final String permissionSchemeName, final NamedPrincipalAssociationData namedPrincipalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(namedPrincipalAssociationData.getAction());
                String userName = DefaultPermissionSchemeService.this.checkUserNameValid(namedPrincipalAssociationData);
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.removeUserAction(userName, action.getName());
            }
        });
    }

    public Page<NamedPrincipalAssociationData> searchGroupsPrincipalAssociation(String permissionSchemeName, NamedPrincipalAssociationSearchCriteria namedPrincipalAssociationSearchCriteria, PageRequest pageRequest) {
        this.effectiveUserProvider.ensureAdminPermission();
        Preconditions.checkNotNull((Object)permissionSchemeName);
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(permissionSchemeName);
        ArrayList<GroupPA> groupsPA = new ArrayList<GroupPA>(permissionScheme.getGroupPAs());
        Iterable groupsPAData = Iterables.transform(groupsPA, this.principalAssociationToNamedPrincipalAssociationToData());
        Iterable filteredGroupsPA = Iterables.filter((Iterable)groupsPAData, (Predicate)namedPrincipalAssociationSearchCriteria.filterPredicate());
        return Page.Builder.buildFromAllDataIterable((Iterable)filteredGroupsPA, (PageRequest)pageRequest);
    }

    public boolean addPermissionSchemeGroup(final String permissionSchemeName, final NamedPrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                GroupInfo group = DefaultPermissionSchemeService.this.userManager.ensureGroupExists(principalAssociationData.getName());
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.addGroupAction(group.getName(), action.getName());
            }
        });
    }

    public boolean deletePermissionSchemeGroup(final String permissionSchemeName, final NamedPrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                GroupInfo group = DefaultPermissionSchemeService.this.userManager.ensureGroupExists(principalAssociationData.getName());
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.removeGroupAction(group.getName(), action.getName());
            }
        });
    }

    public Page<NamedPrincipalAssociationData> searchRolesPrincipalAssociation(String permissionSchemeName, NamedPrincipalAssociationSearchCriteria namedPrincipalAssociationSearchCriteria, PageRequest pageRequest) {
        this.effectiveUserProvider.ensureAdminPermission();
        Preconditions.checkNotNull((Object)permissionSchemeName);
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(permissionSchemeName);
        ArrayList<RolePA> rolesPA = new ArrayList<RolePA>(permissionScheme.getReviewRolePAs());
        Iterable rolesPAData = Iterables.transform(rolesPA, this.principalAssociationToNamedPrincipalAssociationToData());
        Iterable filteredRolesPA = Iterables.filter((Iterable)rolesPAData, (Predicate)namedPrincipalAssociationSearchCriteria.filterPredicate());
        return Page.Builder.buildFromAllDataIterable((Iterable)filteredRolesPA, (PageRequest)pageRequest);
    }

    public boolean addPermissionSchemeReviewRole(final String permissionSchemeName, final NamedPrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                Role role = DefaultPermissionSchemeService.this.reviewManager.ensureReviewRoleExists(principalAssociationData.getName());
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.addReviewRoleAction(role.getName(), action.getName());
            }
        });
    }

    public boolean deletePermissionSchemeRole(final String permissionSchemeName, final NamedPrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                Role role = DefaultPermissionSchemeService.this.reviewManager.ensureReviewRoleExists(principalAssociationData.getName());
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.removeReviewRoleAction(role.getName(), action.getName());
            }
        });
    }

    public Page<PrincipalAssociationData> searchLoggedUsersPrincipalAssociation(String permissionSchemeName, PrincipalAssociationSearchCriteria principalAssociationSearchCriteria, PageRequest pageRequest) {
        this.effectiveUserProvider.ensureAdminPermission();
        Preconditions.checkNotNull((Object)permissionSchemeName);
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(permissionSchemeName);
        ArrayList<AllUserPA> loggedUsersPA = new ArrayList<AllUserPA>(permissionScheme.getAllUsersPAs());
        Iterable loggedUsersPAData = Iterables.transform(loggedUsersPA, this.basePrincipalAssociationToPrincipalAssociationToData());
        Iterable filterLoggedUsersPAData = Iterables.filter((Iterable)loggedUsersPAData, (Predicate)principalAssociationSearchCriteria.filterPredicate());
        return Page.Builder.buildFromAllDataIterable((Iterable)filterLoggedUsersPAData, (PageRequest)pageRequest);
    }

    public boolean addPermissionSchemeLoggedUsers(final String permissionSchemeName, final PrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.addAllUsersAction(action.getName());
            }
        });
    }

    public boolean deletePermissionSchemeLoggedUsers(final String permissionSchemeName, final PrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.removeAllUsersAction(action.getName());
            }
        });
    }

    public Page<PrincipalAssociationData> searchAnonymousUsersPrincipalAssociation(String permissionSchemeName, PrincipalAssociationSearchCriteria principalAssociationSearchCriteria, PageRequest pageRequest) {
        this.effectiveUserProvider.ensureAdminPermission();
        Preconditions.checkNotNull((Object)permissionSchemeName);
        PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(permissionSchemeName);
        ArrayList<AnonymousPA> anonymousUsersPA = new ArrayList<AnonymousPA>(permissionScheme.getAnonymousPAs());
        Iterable anonymousUsersPAData = Iterables.transform(anonymousUsersPA, this.basePrincipalAssociationToPrincipalAssociationToData());
        Iterable filterAnonymousUsersPAData = Iterables.filter((Iterable)anonymousUsersPAData, (Predicate)principalAssociationSearchCriteria.filterPredicate());
        return Page.Builder.buildFromAllDataIterable((Iterable)filterAnonymousUsersPAData, (PageRequest)pageRequest);
    }

    public boolean addPermissionSchemeAnonymousUsers(final String permissionSchemeName, final PrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                if (!action.allowsAnonymousPermission()) {
                    throw new IllegalArgumentException(String.format("Action: %s is not allowed for anonymous users.", action.getName()));
                }
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.addAnonAction(action.getName());
            }
        });
    }

    public boolean deletePermissionSchemeAnonymousUsersLoggedUsers(final String permissionSchemeName, final PrincipalAssociationData principalAssociationData) {
        this.effectiveUserProvider.ensureAdminPermission();
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                UserActionManager.Action action = DefaultPermissionSchemeService.this.userActionManager.ensureActionExists(principalAssociationData.getAction());
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(permissionSchemeName);
                return permissionScheme.removeAnonAction(action.getName());
            }
        });
    }

    public void create(final PermissionSchemeData permissionSchemeData) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.validatePermissionSchemeOnCreate(permissionSchemeData);
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                if (DefaultPermissionSchemeService.this.permissionManager.findPermissionSchemeByName(permissionSchemeData.getName()) != null) {
                    throw new IllegalArgumentException(String.format("Permission scheme with name: %s already exists.", permissionSchemeData.getName()));
                }
                DefaultPermissionSchemeService.this.permissionManager.createPermissionScheme(permissionSchemeData.getName());
                return null;
            }
        });
    }

    public void createFrom(final String copyFromPermissionSchemeName, final String newPermissionSchemeName) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.validatePermissionSchemeName(newPermissionSchemeName);
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                if (DefaultPermissionSchemeService.this.permissionManager.findPermissionSchemeByName(newPermissionSchemeName) != null) {
                    throw new IllegalArgumentException(String.format("Permission scheme with name: %s already exists.", newPermissionSchemeName));
                }
                PermissionScheme copyFromPermissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(copyFromPermissionSchemeName);
                DefaultPermissionSchemeService.this.permissionManager.copyPermissionScheme(copyFromPermissionScheme, newPermissionSchemeName);
                return null;
            }
        });
    }

    private void validatePermissionSchemeOnCreate(PermissionSchemeData permissionSchemeData) {
        this.validatePermissionSchemeName(permissionSchemeData.getName());
    }

    private void validatePermissionSchemeName(String permissionSchemeName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)permissionSchemeName) ? 1 : 0) != 0, (Object)"permission scheme name not set");
        Matcher m2 = PERMISSION_SCHEME_NAME_PATTERN.matcher(permissionSchemeName);
        Preconditions.checkArgument((boolean)m2.matches(), (String)"Invalid permission key name, only alphanumeric values are allowed: %s", (Object[])new Object[]{PERMISSION_SCHEME_NAME_PATTERN.pattern()});
    }

    public void rename(final String oldName, final String newName) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.validatePermissionSchemeName(newName);
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(oldName);
                if (DefaultPermissionSchemeService.this.permissionManager.findPermissionSchemeByName(newName) != null) {
                    throw new IllegalArgumentException(String.format("Permission scheme with name: %s already exists.", newName));
                }
                permissionScheme.setName(newName);
                return null;
            }
        });
    }

    public void delete(final String name) {
        this.effectiveUserProvider.ensureAdminPermission();
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme permissionScheme = DefaultPermissionSchemeService.this.permissionManager.ensurePermissionSchemeExists(name);
                Iterable<Project> projectUsingPermissionScheme = DefaultPermissionSchemeService.this.permissionManager.getProjectsUsingPermissionScheme(permissionScheme);
                if (!Iterables.isEmpty(projectUsingPermissionScheme)) {
                    Iterable projectKeys = Iterables.transform(projectUsingPermissionScheme, (Function)new Function<Project, String>(){

                        public String apply(Project project) {
                            return project.getProjKey();
                        }
                    });
                    throw new IllegalStateException(String.format("Could not delete permission scheme: %s used by projects: %s", name, Iterables.toString((Iterable)projectKeys)));
                }
                DefaultPermissionSchemeService.this.permissionManager.deletePermissionSchemeByName(permissionScheme.getName());
                return null;
            }
        });
    }

    private Function<PermissionScheme, PermissionSchemeData> permissionSchemeToPermissionSchemeData() {
        return permissionScheme -> {
            if (permissionScheme == null) {
                return null;
            }
            PermissionSchemeData permissionSchemeData = new PermissionSchemeData();
            permissionSchemeData.setName(permissionScheme.getName());
            return permissionSchemeData;
        };
    }

    private Function<String, PermissionSchemeData> nameToPermissionSchemeData() {
        return permissionSchemeName -> {
            PermissionSchemeData permissionSchemeData = new PermissionSchemeData();
            permissionSchemeData.setName(permissionSchemeName);
            return permissionSchemeData;
        };
    }

    private Function<PrincipalAssociation, NamedPrincipalAssociationData> principalAssociationToNamedPrincipalAssociationToData() {
        return principalAssociation -> {
            NamedPrincipalAssociationData principalAssociationData = new NamedPrincipalAssociationData();
            principalAssociationData.setName(principalAssociation.getPid());
            principalAssociationData.setAction(principalAssociation.getActionName());
            return principalAssociationData;
        };
    }

    private Function<BasePrincipalAssociation, PrincipalAssociationData> basePrincipalAssociationToPrincipalAssociationToData() {
        return principalAssociation -> {
            PrincipalAssociationData principalAssociationData = new PrincipalAssociationData();
            principalAssociationData.setAction(principalAssociation.getActionName());
            return principalAssociationData;
        };
    }
}

