/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.PluginId;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.ImpersonationService;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.Operation;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@AvailableToPlugins
@Component(value="impersonationService")
public class DefaultImpersonationService
implements ImpersonationService {
    private final SPIUserUtils spiUserUtils;
    private final EffectiveUserProvider effectiveUserProvider;
    private final UserManager userManager;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultImpersonationService(EffectiveUserProvider effectiveUserProvider, UserManager userManager, SPIUserUtils spiUserUtils, TxTemplate txTemplate) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.userManager = userManager;
        this.spiUserUtils = spiUserUtils;
        this.txTemplate = txTemplate;
    }

    public <T, E extends Throwable> T doAsUser(PluginId id, String userName, Operation<T, E> operation) throws E {
        if (this.canImpersonate(id, userName)) {
            return this.doOperationAsUser(userName, operation);
        }
        throw new NotPermittedException("Plugin " + id + " is not allowed to impersonate " + userName);
    }

    public <T, E extends Throwable> T doAsDefaultUser(PluginId id, Operation<T, E> operation) throws E {
        UserData defaultUser;
        String effectiveUserName = Principal.Anonymous.isAnon((Principal)this.effectiveUserProvider.getEffectivePrincipal()) ? ((defaultUser = this.getDefaultUser(id)) != null ? defaultUser.getUserName() : Principal.Anonymous.ANON.getUserName()) : this.effectiveUserProvider.getEffectivePrincipal().getUserName();
        return this.doOperationAsUser(effectiveUserName, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T doPrivilegedAction(PluginId id, Operation<T, E> operation) throws E {
        this.effectiveUserProvider.pushEffectivePrincipal((Principal)Principal.SuperUser.INSTANCE, null);
        try {
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            this.effectiveUserProvider.popEffectivePrincipal();
        }
    }

    public boolean canImpersonate(PluginId id, String userName) {
        return true;
    }

    public boolean canDoPrivilegedAction(PluginId id) {
        return true;
    }

    public UserData getDefaultUser(PluginId id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Throwable> T doOperationAsUser(final String userName, Operation<T, E> operation) throws E {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                UserLogin principal = null;
                FecruUser user = null;
                if (userName != null) {
                    try {
                        principal = DefaultImpersonationService.this.userManager.createTrustedUserLogin(userName);
                        user = DefaultImpersonationService.this.userManager.getLicensedUser(userName);
                    }
                    catch (Exception e2) {
                        String message = "Could not run as '" + userName + "'";
                        Logs.APP_LOG.error((Object)message, (Throwable)e2);
                        throw new RuntimeException(message, e2);
                    }
                }
                if (principal != null) {
                    DefaultImpersonationService.this.effectiveUserProvider.pushEffectivePrincipal(principal, user);
                } else {
                    DefaultImpersonationService.this.effectiveUserProvider.pushEffectivePrincipal((Principal)Principal.Anonymous.ANON, null);
                }
                return null;
            }
        });
        try {
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            this.effectiveUserProvider.popEffectivePrincipal();
        }
    }

    private Optional<FecruUser> getEffectiveUser() {
        return Optional.ofNullable(this.effectiveUserProvider.getEffectiveUser());
    }

    public UserData getCurrentUser(PluginId id) {
        return this.getEffectiveUser().map(this.spiUserUtils::createUserData).orElse(null);
    }

    public String getCurrentUserName(PluginId id) {
        return this.getEffectiveUser().map(FecruUser::getUsername).orElse(null);
    }
}

