/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.data.GlobalPermissionData;
import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.crucible.spi.services.GroupService;
import com.atlassian.fecru.page.OnePageRequest;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.utils.collectors.ImmutableCollectors;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.WithSession;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="globalPermissionService")
@AvailableToPlugins
@WithSession
public class DefaultGlobalPermissionService
implements GlobalPermissionService {
    private final GlobalPermissionManager globalPermissionManager;
    private final GroupService groupService;
    private final UserManager userManager;
    private final EffectiveUserProvider effectiveUserProvider;

    @Autowired
    public DefaultGlobalPermissionService(GlobalPermissionManager globalPermissionManager, GroupService groupService, UserManager userManager, EffectiveUserProvider effectiveUserProvider) {
        this.globalPermissionManager = globalPermissionManager;
        this.groupService = groupService;
        this.userManager = userManager;
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Transactional
    public boolean hasUserPermissions(String userName, GlobalPermissionType permissions) {
        return this.hasUserPermissions(userName, Collections.singleton(permissions));
    }

    @Transactional
    public boolean hasUserPermissions(String username, Set<GlobalPermissionType> permissions) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0, (Object)"username must not be null or empty");
        if (!this.userManager.existsEnabledUser(username)) {
            Logs.APP_LOG.debug((Object)("Permission check for non existant user " + username + ", returning false"));
            return false;
        }
        return this.globalPermissionManager.hasPermissions(username, permissions);
    }

    @Transactional
    public boolean hasUserPermissions(Principal user, Set<GlobalPermissionType> permissions) {
        return user != null && !Principal.Anonymous.isAnon((Principal)user) && (Principal.SuperUser.isSuperUser((Principal)user) || this.hasUserPermissions(user.getUserName(), permissions));
    }

    @Transactional
    public void setPermissionsForGroup(String group, Set<GlobalPermissionType> permissions) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0, (Object)"group must not be null or empty");
        this.effectiveUserProvider.ensureAdminPermission();
        if (!this.groupService.exist(group)) {
            throw new IllegalArgumentException(group);
        }
        this.globalPermissionManager.setPermissionsForGroup(group, permissions);
    }

    @Transactional
    public void removeAllPermissionForGroup(String group) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0, (Object)"group must not be null or empty");
        this.effectiveUserProvider.ensureAdminPermission();
        this.globalPermissionManager.removeAllPermissionsForGroup(group);
    }

    @Transactional
    public Page<GlobalPermissionData> listPermissions(PageRequest pageRequest) {
        this.effectiveUserProvider.ensureAdminPermission();
        PageRequest request = pageRequest != null ? pageRequest : PageRequest.createDefault();
        Collection permissions = (Collection)this.globalPermissionManager.listPermissions(request).stream().map(this::buildPermissionData).collect(ImmutableCollectors.toList());
        new Page.Builder();
        return Page.Builder.buildFromLimitPlusOneCollection((Collection)permissions, (PageRequest)request);
    }

    @Transactional
    public Page<String> groupsWithoutAnyPermissions(String prefix, PageRequest pageRequest) {
        GroupSearchCriteria groupSearchCriteria = GroupSearchCriteria.create().prefix(prefix);
        PagedResourceIterable pagedResourceIterable = new PagedResourceIterable(requestedPage -> this.userManager.searchGroups(groupSearchCriteria, requestedPage), OnePageRequest.createNoLimit());
        Set existingPermissions = this.globalPermissionManager.listPermissions(OnePageRequest.createNoLimit()).stream().map(GlobalPermission::getGroup).collect(Collectors.toSet());
        ImmutableList filteredGroups = StreamSupport.stream(pagedResourceIterable.spliterator(), false).map(groupInfo -> UserManager.GROUPNAME_NORMALIZATION.apply(groupInfo.getName())).filter(group -> !existingPermissions.contains(group)).sorted().collect(ImmutableCollectors.toList());
        return Page.Builder.buildFromAllDataIterable(filteredGroups, (PageRequest)pageRequest);
    }

    public Optional<GlobalPermissionData> getPermissionForGroup(String group) {
        return this.globalPermissionManager.getPermissionForGroup(group).map(this::buildPermissionData);
    }

    private GlobalPermissionData buildPermissionData(GlobalPermission permission) {
        return permission == null ? null : new GlobalPermissionData(permission.getGroup(), permission.isFisheyeUser(), permission.isCrucibleUser());
    }
}

