/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.resource;

import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;

public class SpringAwareScheduledExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService scheduledExecutor;

    public SpringAwareScheduledExecutorService(int poolSize, String namePrefix, boolean daemon) {
        this.scheduledExecutor = Executors.newScheduledThreadPool(poolSize, new ConfigurableThreadFactory(namePrefix, daemon));
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.scheduledExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.scheduledExecutor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduledExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.scheduledExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.scheduledExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.scheduledExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.scheduledExecutor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.scheduledExecutor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.scheduledExecutor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.scheduledExecutor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.scheduledExecutor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.scheduledExecutor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.scheduledExecutor.execute(command);
    }

    @PreDestroy
    public void destroy() {
        this.scheduledExecutor.shutdownNow();
    }
}

