/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.xml;

import com.atlassian.crucible.migration.NodeCreator;
import com.atlassian.crucible.migration.NodeStreamWriter;
import com.atlassian.crucible.migration.ParseException;
import com.cenqua.fisheye.util.XmlUtils;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StAXStreamWriter
implements NodeStreamWriter {
    private static final String XMLSCHEMA_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private final DateFormat dateFormat;
    private final XMLStreamWriter writer;
    private final XmlUtils xmlUtils;
    private final String defaultnamespace;
    private boolean rootExists = false;

    public StAXStreamWriter(Writer output, String namespaceUri) throws ParseException {
        this(StAXStreamWriter.createXMLStreamWriter(output), namespaceUri);
    }

    public StAXStreamWriter(XMLStreamWriter writer, String namespaceUri) {
        if (writer == null || namespaceUri == null) {
            throw new IllegalArgumentException("writer and namespaceUri must not be null");
        }
        this.defaultnamespace = namespaceUri;
        this.xmlUtils = new XmlUtils();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.writer = writer;
    }

    private static XMLStreamWriter createXMLStreamWriter(Writer out) throws ParseException {
        try {
            return XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        }
        catch (XMLStreamException xe) {
            throw new ParseException(xe);
        }
    }

    @Override
    public NodeCreator addRootNode(String name) throws ParseException, IllegalStateException {
        if (this.rootExists) {
            throw new IllegalStateException("Root node already created.");
        }
        try {
            this.writer.writeStartDocument("ISO-8859-1", "1.0");
            this.rootExists = true;
            NodeCreator nc = new NodeCreator(){
                private long depth = 0L;

                @Override
                public NodeCreator addNode(String name) throws ParseException {
                    try {
                        StAXStreamWriter.this.writer.writeStartElement(name);
                        ++this.depth;
                        return this;
                    }
                    catch (XMLStreamException e2) {
                        throw new ParseException(e2);
                    }
                }

                @Override
                public NodeCreator closeEntity() throws ParseException {
                    try {
                        StAXStreamWriter.this.writer.writeEndElement();
                        return --this.depth == 0L ? null : this;
                    }
                    catch (XMLStreamException e2) {
                        throw new ParseException(e2);
                    }
                }

                @Override
                public NodeCreator setContentAsDate(Date date) throws ParseException {
                    return this.setContentAsString(date == null ? null : StAXStreamWriter.this.dateFormat.format(date));
                }

                @Override
                public NodeCreator setContentAsBigInteger(BigInteger bigInteger) throws ParseException {
                    return this.setContentAsString(bigInteger == null ? null : bigInteger.toString());
                }

                @Override
                public NodeCreator setContentAsBoolean(Boolean bool) throws ParseException {
                    return this.setContentAsString(bool == null ? null : Boolean.toString(bool));
                }

                @Override
                public NodeCreator setContentAsString(String value) throws ParseException {
                    try {
                        if (value == null) {
                            StAXStreamWriter.this.writer.writeAttribute(StAXStreamWriter.XMLSCHEMA_URI, "nil", "true");
                        } else {
                            StAXStreamWriter.this.writer.writeCharacters(StAXStreamWriter.this.xmlUtils.unicodeEncode(value));
                        }
                        return this;
                    }
                    catch (XMLStreamException e2) {
                        throw new ParseException(e2);
                    }
                }

                @Override
                public NodeCreator setContent(Reader data) {
                    throw new AssertionError((Object)"Not implemented");
                }

                @Override
                public void addAttribute(String key, String value) throws ParseException {
                    try {
                        StAXStreamWriter.this.writer.writeAttribute(key, StAXStreamWriter.this.xmlUtils.unicodeEncode(value));
                    }
                    catch (XMLStreamException e2) {
                        throw new ParseException(e2);
                    }
                }
            };
            NodeCreator nodeCreator = nc.addNode(name);
            this.writer.writeDefaultNamespace(this.defaultnamespace);
            this.writer.writeNamespace("xsi", XMLSCHEMA_URI);
            return nodeCreator;
        }
        catch (XMLStreamException e2) {
            throw new ParseException("Unable to create the root node.", e2);
        }
    }

    @Override
    public void flush() throws ParseException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e2) {
            throw new ParseException(e2);
        }
    }

    @Override
    public void close() throws ParseException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e2) {
            throw new ParseException(e2);
        }
    }
}

