/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.xml;

import com.atlassian.crucible.migration.NodeParser;
import com.atlassian.crucible.migration.NodeStreamReader;
import com.atlassian.crucible.migration.ParseException;
import com.cenqua.fisheye.util.XmlUtils;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StAXStreamReader
implements NodeStreamReader {
    private static final String XMLSCHEMA_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private final XmlUtils xmlUtils;
    private final DateFormat dateFormat;
    private final XMLStreamReader reader;

    public StAXStreamReader(Reader input) throws ParseException {
        if (input == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        try {
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        }
        catch (XMLStreamException e2) {
            throw new ParseException(e2);
        }
        this.xmlUtils = new XmlUtils();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public NodeParser getRootNode() throws ParseException {
        if (this.reader.getEventType() != 7) {
            throw new IllegalStateException("The root node has already been returned.");
        }
        try {
            this.reader.nextTag();
            return new NodeParser(){

                @Override
                public String getAttribute(String key) throws ParseException {
                    return this.getAttribute(key, null, false);
                }

                @Override
                public String getRequiredAttribute(String key) throws ParseException {
                    return this.getAttribute(key, null, true);
                }

                private String getAttribute(String key, String namespaceUri, boolean required) throws ParseException {
                    this.requireStartElement();
                    for (int i2 = 0; i2 < StAXStreamReader.this.reader.getAttributeCount(); ++i2) {
                        if (!key.equals(StAXStreamReader.this.reader.getAttributeName(i2).getLocalPart()) || namespaceUri != null && !namespaceUri.equals(StAXStreamReader.this.reader.getAttributeName(i2).getNamespaceURI())) continue;
                        return StAXStreamReader.this.xmlUtils.unicodeDecode(StAXStreamReader.this.reader.getAttributeValue(i2));
                    }
                    if (required) {
                        throw new ParseException(String.format("Required attribute %s not found in node %s", key, this.getName()));
                    }
                    return null;
                }

                @Override
                public String getName() {
                    return StAXStreamReader.this.reader.getLocalName();
                }

                @Override
                public boolean isClosed() {
                    return StAXStreamReader.this.reader.getEventType() == 2;
                }

                private int nextTagOrEndOfDocument() throws ParseException {
                    try {
                        int eventType = StAXStreamReader.this.reader.next();
                        while (eventType == 4 && StAXStreamReader.this.reader.isWhiteSpace() || eventType == 12 && StAXStreamReader.this.reader.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
                            eventType = StAXStreamReader.this.reader.next();
                        }
                        if (eventType != 1 && eventType != 2 && eventType != 8) {
                            throw new ParseException("Unable to find start or end tag, or end of document. Location: " + StAXStreamReader.this.reader.getLocation());
                        }
                        return eventType;
                    }
                    catch (XMLStreamException e2) {
                        throw new ParseException(e2);
                    }
                }

                @Override
                public NodeParser getNextNode() throws ParseException {
                    int event = this.nextTagOrEndOfDocument();
                    assert (StAXStreamReader.this.reader.isStartElement() || StAXStreamReader.this.reader.isEndElement() || 8 == StAXStreamReader.this.reader.getEventType());
                    return 8 == event ? null : this;
                }

                @Override
                public String getContentAsString() throws IllegalStateException, ParseException {
                    this.requireStartElement();
                    try {
                        if (Boolean.parseBoolean(this.getAttribute("nil", StAXStreamReader.XMLSCHEMA_URI, false))) {
                            this.nextTagOrEndOfDocument();
                            return null;
                        }
                        return StAXStreamReader.this.xmlUtils.unicodeDecode(StAXStreamReader.this.reader.getElementText());
                    }
                    catch (XMLStreamException e2) {
                        throw new ParseException(e2);
                    }
                }

                @Override
                public Boolean getContentAsBoolean() throws ParseException {
                    String value = this.getContentAsString();
                    return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
                }

                @Override
                public Date getContentAsDate() throws ParseException {
                    String value = this.getContentAsString();
                    try {
                        return value == null ? null : StAXStreamReader.this.dateFormat.parse(value);
                    }
                    catch (java.text.ParseException pe) {
                        throw new ParseException(pe);
                    }
                }

                @Override
                public BigInteger getContentAsBigInteger() throws ParseException {
                    String value = this.getContentAsString();
                    return value == null ? null : new BigInteger(value);
                }

                @Override
                public void getContent(Writer writer) {
                    throw new AssertionError((Object)"Not implemented.");
                }

                private void requireStartElement() throws IllegalStateException {
                    if (!StAXStreamReader.this.reader.isStartElement()) {
                        throw new IllegalStateException("Not currently positioned at the start of a node.");
                    }
                }
            };
        }
        catch (XMLStreamException e2) {
            throw new ParseException(e2);
        }
    }

    @Override
    public void close() throws ParseException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e2) {
            throw new ParseException(e2);
        }
    }
}

