/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.cenqua.crucible.upload.UploadManager;
import com.cenqua.fisheye.AppConfig;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class UploadItemsBackup
extends FileBackupItem {
    private static final String UPLOADS_DIR = "var/data/uploads";

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        return SaverFactory.create(beanFactory, SaverImpl.class, this);
    }

    @Override
    public String getName() {
        return "uploads";
    }

    @Override
    public String getDescription() {
        return "uploaded files and local copies of files under review";
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return false;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, Map<String, String> properties) throws BackupException {
        return new Restorer(){

            @Override
            public void restore() throws IOException {
                UploadItemsBackup.this.extractPath(UploadItemsBackup.UPLOADS_DIR, AppConfig.getInstanceDir(), zip, monitor);
            }
        };
    }

    private static class SaverImpl
    extends FileSaver {
        private SaverImpl() {
        }

        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            this.addPath(new File(UploadItemsBackup.UPLOADS_DIR), UploadManager.getUploadDir(), zos, monitor);
        }
    }
}

