/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.cenqua.fisheye.AppConfig;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class TemplatesBackup
extends FileBackupItem {
    private static final String TEMPLATE_DIR = "template";

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        return SaverFactory.create(beanFactory, SaverImpl.class, this);
    }

    @Override
    public String getName() {
        return "templates";
    }

    @Override
    public String getDescription() {
        return "web templates";
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, Map<String, String> properties) throws BackupException {
        return new Restorer(){

            @Override
            public void restore() throws IOException {
                TemplatesBackup.this.extractPath(TemplatesBackup.TEMPLATE_DIR, AppConfig.getInstanceDir(), zip, monitor);
            }
        };
    }

    private static class SaverImpl
    extends FileSaver {
        private SaverImpl() {
        }

        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            this.addPath(new File(TemplatesBackup.TEMPLATE_DIR), new File(AppConfig.getInstanceDir(), TemplatesBackup.TEMPLATE_DIR), zos, monitor);
        }
    }
}

