/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.NodeStreamWriter;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.AnonymisingStreamWriter;
import com.atlassian.crucible.migration.item.DBExporter;
import com.atlassian.crucible.migration.item.DBImporter;
import com.atlassian.crucible.migration.item.Message;
import com.atlassian.crucible.migration.xml.StAXStreamReader;
import com.atlassian.crucible.migration.xml.StAXStreamWriter;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBControlFactoryImpl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.ctl.RestoreConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class SQLBackup
implements BackupItem {
    public static final Predicate<String> HAS_FECRU_TABLE_PREFIX = tableName -> {
        String normalizedName = Strings.nullToEmpty((String)tableName).toLowerCase(Locale.US);
        return normalizedName.startsWith("cru_") || normalizedName.startsWith("cwd_");
    };
    public static final Predicate<String> IS_EXPORTABLE_TABLE = HAS_FECRU_TABLE_PREFIX.and(tableName -> !"cru_version".equalsIgnoreCase((String)tableName));
    public static final String JDBC_TYPE = "sql.dbtype";
    public static final String FE_NAMESPACE = "http://www.atlassian.com/fisheye/backup-1";
    public static final String JDBC_URL = "sql.jdbcurl";
    public static final String JDBC_USERNAME = "sql.username";
    public static final String JDBC_PASSWORD = "sql.password";
    public static final String JDBC_DRIVER = "sql.driver";
    public static final String JDBC_DRIVER_SOURCE = "sql.driversource";
    public static final String ANONYMIZE = "anonymise";
    public static final String NO_BATCH = "nobatch";
    public static final String FORCE = "force";
    private static final String NAME = "sql";
    private static final String ZIP_ENTRY = "sql/database.xml";
    private DBControlFactory dbControlFactory = null;
    private boolean useBatch = true;

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        SaverImpl s2 = SaverFactory.create(beanFactory, SaverImpl.class, this);
        s2.setControl(this.getBackupControl());
        return s2;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "SQL database";
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, final Map<String, String> properties) throws BackupException {
        try {
            final DBControl control = this.getRestoreControl(zip, properties, monitor);
            if (control.getInfo().state() == DBInfo.DBState.NO_DB) {
                throw new BackupException(String.format("Cannot open target database at: %s (%s)", control.getInfo().getConnectionInfo().getJdbcURL(), control.getErrorMessage()));
            }
            if (!properties.containsKey(FORCE) && control.getInfo().state() != DBInfo.DBState.NO_TABLES) {
                throw new BackupException(String.format("WARNING: This operation will permanently overwrite the database at:\n       %s\nPlease verify that this is the correct database to restore to and then re-run this command with the flag:\n       --force", control.getInfo().getConnectionInfo().getJdbcURL()));
            }
            return new Restorer(){

                @Override
                public void restore() throws IOException {
                    monitor.update(new Message("Restoring to: " + control.getInfo().getConnectionInfo().getJdbcURL()));
                    if (properties.containsKey(SQLBackup.NO_BATCH)) {
                        SQLBackup.this.useBatch = false;
                    }
                    SQLBackup.this.restore(control, zip, monitor);
                }
            };
        }
        catch (IOException ioe) {
            throw new BackupException("Cannot find database configuration: " + ioe.getMessage(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(DBControl control, ZipFile zip, ProgressMonitor monitor) throws IOException {
        DBImporter importer = new DBImporter(monitor);
        importer.setBatch(this.useBatch);
        try {
            block6: {
                block5: {
                    ZipEntry entry = zip.getEntry(ZIP_ENTRY);
                    if (entry == null) break block5;
                    StAXStreamReader reader = new StAXStreamReader(new BufferedReader(new InputStreamReader(zip.getInputStream(entry))));
                    try {
                        importer.importData(reader, control);
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(reader);
                        throw throwable;
                    }
                    IOHelper.close(reader);
                    break block6;
                }
                String message = "SQL database not found in backup, skipping.";
                Logs.APP_LOG.warn((Object)message);
                monitor.update(new Message(message));
            }
            HibernateUtil.setUp(control.getConfig());
        }
        catch (CruDBException ce) {
            IOException ioe = new IOException("Error talking to database: " + ce.getMessage());
            ioe.initCause(ce);
            throw ioe;
        }
        catch (SQLException e2) {
            IOException ioe = new IOException("Error writing to the database: " + e2.getMessage());
            ioe.initCause(e2);
            throw ioe;
        }
    }

    private DBControl getBackupControl() {
        return this.getDBControlFactory().getCurrentControl();
    }

    private DBControl getRestoreControl(ZipFile zip, Map<String, String> properties, ProgressMonitor monitor) throws IOException {
        RestoreConfig restoreConfig = new RestoreConfig(zip, properties, monitor);
        ConfigDocument configFromBackup = restoreConfig.getConfigFromBackup();
        return this.getDBControlFactory().makeControlFromDoc(configFromBackup);
    }

    private DBControlFactory getDBControlFactory() {
        if (this.dbControlFactory == null) {
            this.dbControlFactory = SpringContext.isSetup() ? (DBControlFactory)SpringContext.getComponent("dbControlFactory") : new DBControlFactoryImpl();
        }
        return this.dbControlFactory;
    }

    private static class SaverImpl
    implements Saver {
        private BackupItem backupItem;
        private DBControl control;

        private SaverImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            DBExporter exporter = new DBExporter(IS_EXPORTABLE_TABLE, monitor);
            Connection connection = null;
            try {
                this.control.readOnly(true);
                try {
                    zos.putNextEntry(new ZipEntry(SQLBackup.ZIP_ENTRY));
                    connection = this.control.getConnection();
                    NodeStreamWriter writer = new StAXStreamWriter(new OutputStreamWriter((OutputStream)zos), SQLBackup.FE_NAMESPACE);
                    if (Boolean.parseBoolean(properties.get(SQLBackup.ANONYMIZE))) {
                        writer = new AnonymisingStreamWriter(writer);
                        monitor.update(Message.newWarning("Warning: this backup has been anonymised and should NOT be used as a backup. It does NOT contain your data."));
                    }
                    exporter.exportData(this.control.getInfo().type(), connection, writer);
                    writer.flush();
                }
                finally {
                    this.control.readOnly(false);
                    this.control.closeConnection(connection);
                }
            }
            catch (CruDBException e2) {
                IOException ioe = new IOException("Unable to get a readonly database connection: " + e2.getMessage());
                ioe.initCause(e2);
                throw ioe;
            }
            catch (SQLException e3) {
                IOException ioe = new IOException("Error reading database: " + e3.getMessage());
                ioe.initCause(e3);
                throw ioe;
            }
        }

        @Override
        public void setBackupItem(BackupItem backupItem) {
            this.backupItem = backupItem;
        }

        public void setControl(DBControl control) {
            this.control = control;
        }
    }
}

