/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.cenqua.fisheye.AppConfig;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class PluginDataBackup
extends FileBackupItem {
    private static final String CONFIG_DIR = "var/plugins/config";
    private static final String USER_DIR = "var/plugins/user";
    private static final String DATA_DIR = "data/plugins/data";

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        return SaverFactory.create(beanFactory, SaverImpl.class, this);
    }

    @Override
    public String getName() {
        return "plugins";
    }

    @Override
    public String getDescription() {
        return "plugins and their configuration data";
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, Map<String, String> properties) throws BackupException {
        return new Restorer(){

            @Override
            public void restore() throws IOException {
                PluginDataBackup.this.extractPath(PluginDataBackup.CONFIG_DIR, AppConfig.getInstanceDir(), zip, monitor);
                PluginDataBackup.this.extractPath(PluginDataBackup.USER_DIR, AppConfig.getInstanceDir(), zip, monitor);
                PluginDataBackup.this.extractPath(PluginDataBackup.DATA_DIR, AppConfig.getInstanceDir(), zip, monitor);
            }
        };
    }

    private static class SaverImpl
    extends FileSaver {
        private SaverImpl() {
        }

        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            this.addInstancePath(PluginDataBackup.CONFIG_DIR, zos, monitor);
            this.addInstancePath(PluginDataBackup.USER_DIR, zos, monitor);
            this.addInstancePath(PluginDataBackup.DATA_DIR, zos, monitor);
        }
    }
}

