/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.cenqua.fisheye.AppConfig;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class LicenseBackup
extends FileBackupItem {
    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        return SaverFactory.create(beanFactory, SaverImpl.class, this);
    }

    @Override
    public String getName() {
        return "license";
    }

    @Override
    public String getDescription() {
        return "the product's license key(s)";
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return this.isMandatory();
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, Map<String, String> properties) throws BackupException {
        return new Restorer(){

            @Override
            public void restore() throws IOException {
                LicenseBackup.this.extractPath(null, AppConfig.getInstanceDir(), zip, monitor);
            }
        };
    }

    private static class SaverImpl
    extends FileSaver {
        private SaverImpl() {
        }

        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            File[] licenses;
            for (File license : licenses = AppConfig.getInstanceDir().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.matches(".*\\.license$");
                }
            })) {
                this.addPath(new File(license.getName()), license, zos, monitor);
            }
        }
    }
}

