/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.util.FileSystemUtils;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class FishEyeDataBackup
extends FileBackupItem {
    private static final String[] DATA_DIRS = new String[]{"var/data", "data"};
    private static final Collection<String> EXCLUDED = Arrays.asList("crudb", "DiffTextCache", "uploads");

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        return SaverFactory.create(beanFactory, SaverImpl.class, this);
    }

    @Override
    public String getName() {
        return "fisheyedb";
    }

    @Override
    public String getDescription() {
        return "FishEye data directory";
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, Map<String, String> properties) throws BackupException {
        return new Restorer(){

            @Override
            public void restore() throws IOException {
                RepositoryType[] configuredRepositories;
                for (String dataDir : DATA_DIRS) {
                    FishEyeDataBackup.this.extractPath(dataDir, AppConfig.getInstanceDir(), zip, monitor);
                }
                ArrayList<String> keyFilenames = new ArrayList<String>();
                for (RepositoryType repo : configuredRepositories = AppConfig.getsConfig().getConfig().getRepositoryArray()) {
                    if (repo.isSetHg() && repo.getHg() != null) {
                        if (!repo.getHg().isSetSshAuth() || repo.getHg().getSshAuth() == null) continue;
                        keyFilenames.add(repo.getHg().getSshAuth().getKeyName());
                        continue;
                    }
                    if (!repo.isSetGit() || repo.getGit() == null || !repo.getGit().isSetSshAuth() || repo.getGit().getSshAuth() == null) continue;
                    keyFilenames.add(repo.getGit().getSshAuth().getKeyName());
                }
                String authDirPath = AppConfig.getInstanceDir() + "/data/auth";
                File authDir = new File(authDirPath);
                if (authDir.exists() && authDir.isDirectory()) {
                    FileSystemUtils fileSystemUtils = new FileSystemUtils();
                    for (String filename : keyFilenames) {
                        File privKeyFile = new File(authDirPath + "/" + filename);
                        if (privKeyFile.exists() && privKeyFile.isFile()) {
                            fileSystemUtils.privatise(privKeyFile);
                            continue;
                        }
                        System.err.println("Could not privatise private key '" + filename + "' - key file or public key missing");
                    }
                } else if (keyFilenames.size() > 0) {
                    System.err.println("The configuration contains " + keyFilenames.size() + " repositories that specify SSH keys but no SSH keys were restored");
                }
            }
        };
    }

    private static class SaverImpl
    extends FileSaver {
        private SaverImpl() {
        }

        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            for (String dataDir : DATA_DIRS) {
                File dir = new File(AppConfig.getInstanceDir(), dataDir);
                if (!dir.exists()) continue;
                for (File file : new File(AppConfig.getInstanceDir(), dataDir).listFiles()) {
                    if (EXCLUDED.contains(file.getName())) continue;
                    this.addPath(new File(new File(dataDir), file.getName()), file, zos, monitor);
                }
            }
        }
    }
}

