/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.ExcludeSubdirPathAcceptor;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.FileUtils;
import com.google.common.collect.Sets;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class FishEyeCacheBackup
extends FileBackupItem {
    private static final String REP_CACHE_DIR = "var/cache";
    private static final String CACHE_DIR = "cache";
    private static final long BASE_TIMEOUT_MS = 20000L;
    private static final long TIMEOUT_INCREMENT_MS = 50L;
    private static final Collection<String> EXCLUDED_IN_REP_CACHE = Arrays.asList("clone", "idx0");

    @Override
    public String getName() {
        return CACHE_DIR;
    }

    @Override
    public String getDescription() {
        return "repository and application caches";
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        return SaverFactory.create(beanFactory, SaverImpl.class, this);
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, Map<String, String> properties) throws BackupException {
        return new Restorer(){

            @Override
            public void restore() throws IOException {
                for (String repo : FishEyeCacheBackup.this.list(FishEyeCacheBackup.REP_CACHE_DIR, zip)) {
                    File repoDir = new File(AppConfig.getInstanceDir(), "var/cache/" + repo);
                    if (repoDir.exists()) {
                        monitor.update(Message.newWarning("Replacing existing cache for " + repo + "..."));
                        if (!FileUtils.deleteTree(repoDir)) {
                            throw new IOException("Error replacing existing cache for repository " + repo + ". Cache restore aborted.");
                        }
                    }
                    monitor.update(new Message("Restoring cache for repository " + repo + "..."));
                    FishEyeCacheBackup.this.extractPath("var/cache/" + repo, AppConfig.getInstanceDir(), zip, monitor, new ExcludeSubdirPathAcceptor(FishEyeCacheBackup.this.getName() + "/" + FishEyeCacheBackup.REP_CACHE_DIR + "/" + repo + "/idx0"));
                }
                FishEyeCacheBackup.this.extractPath(FishEyeCacheBackup.CACHE_DIR, AppConfig.getInstanceDir(), zip, monitor, new ExcludeSubdirPathAcceptor(FishEyeCacheBackup.this.getName() + "/cache/plugins/osgi-cache/", FishEyeCacheBackup.this.getName() + "/cache/globalfe/idx1"));
            }
        };
    }

    public static class SaverImpl
    extends FileSaver {
        private RepositoryManager repositoryManager;
        private CrossRepLuceneIndex crossRepLuceneIndex;

        @Autowired
        public SaverImpl(RepositoryManager repositoryManager, CrossRepLuceneIndex crossRepLuceneIndex) {
            this.repositoryManager = repositoryManager;
            this.crossRepLuceneIndex = crossRepLuceneIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            HashSet<RepositoryHandle> handlesToRestart = new HashSet<RepositoryHandle>();
            try {
                this.stopRepositories(monitor, handlesToRestart);
                this.closeIndexes(monitor);
                File repCacheDirInZip = new File(FishEyeCacheBackup.REP_CACHE_DIR);
                File[] repCacheFiles = new File(AppConfig.getInstanceDir(), FishEyeCacheBackup.REP_CACHE_DIR).listFiles();
                if (repCacheFiles != null) {
                    for (File repCache : repCacheFiles) {
                        if (repCache.isDirectory()) {
                            File repSpecificCacheDirInZip = new File(repCacheDirInZip, repCache.getName());
                            for (File file : repCache.listFiles()) {
                                if (EXCLUDED_IN_REP_CACHE.contains(file.getName())) continue;
                                this.addPath(new File(repSpecificCacheDirInZip, file.getName()), file, zos, monitor);
                            }
                            continue;
                        }
                        this.addPath(new File(repCacheDirInZip, repCache.getName()), repCache, zos, monitor);
                    }
                }
                final File instanceCacheDir = new File(AppConfig.getInstanceDir(), FishEyeCacheBackup.CACHE_DIR);
                this.addPath(new File(FishEyeCacheBackup.CACHE_DIR), instanceCacheDir, zos, monitor, new FileFilter(){
                    final Set<File> excludedDirs;
                    {
                        this.excludedDirs = Sets.newHashSet((Object[])new File[]{new File(instanceCacheDir, "globalfe/idx1"), new File(instanceCacheDir, "pipeline")});
                    }

                    @Override
                    public boolean accept(File file) {
                        return !this.excludedDirs.contains(file);
                    }
                });
            }
            finally {
                this.reopenIndexes(monitor);
                this.restartRepositories(monitor, handlesToRestart);
            }
        }

        private void restartRepositories(ProgressMonitor monitor, Set<RepositoryHandle> handlesToRestart) {
            for (RepositoryHandle handle : handlesToRestart) {
                String repoName = handle.getName();
                if (handle.isStopped()) {
                    try {
                        this.repositoryManager.runRepository(repoName);
                        monitor.update(new Message("Restarted repository " + repoName));
                    }
                    catch (RepositoryHandle.StateException se) {
                        this.logRestartError(repoName, monitor, "The repository is not currently stopped", (Exception)((Object)se));
                    }
                    catch (ConfigException ce) {
                        this.logRestartError(repoName, monitor, "The repository is not enabled in the configuration", ce);
                    }
                    catch (DbException de) {
                        this.logRestartError(repoName, monitor, "Problem creating the repository engine from its configuration", de);
                    }
                    catch (IOException ioe) {
                        this.logRestartError(repoName, monitor, "Error accessing the repository's cache", ioe);
                    }
                    catch (LicensePolicyException lpe) {
                        this.logRestartError(repoName, monitor, "Licensing issue", lpe);
                    }
                    continue;
                }
                String message = "Repository is not stopped - in state: " + handle.getStateDescription();
                this.logRestartError(repoName, monitor, message, null);
            }
        }

        private void closeIndexes(ProgressMonitor monitor) {
            try {
                this.crossRepLuceneIndex.close();
            }
            catch (DbException e2) {
                String message = "Unable to stop the FishEye cross-repository index. Caches included in this backup may be inconsistent.";
                Logs.APP_LOG.warn((Object)message, (Throwable)e2);
                monitor.update(Message.newWarning(message));
            }
        }

        private void reopenIndexes(ProgressMonitor monitor) {
            try {
                this.crossRepLuceneIndex.open();
            }
            catch (DbException e2) {
                String message = "Unable to restart cross-repository index. Please shutdown and restart FishEye.";
                Logs.APP_LOG.warn((Object)message, (Throwable)e2);
                monitor.update(Message.newWarning(message));
            }
        }

        private void stopRepositories(ProgressMonitor monitor, Set<RepositoryHandle> handlesToRestart) {
            long timeout = 20000L;
            List<RepositoryHandle> repositoryHandles = this.repositoryManager.getHandles();
            for (RepositoryHandle handle : repositoryHandles) {
                if (handle.isRunning() || handle.isStarting()) {
                    handlesToRestart.add(handle);
                    timeout += 50L;
                }
                monitor.update(new Message("Shutting down repository " + handle.getName() + " ..."));
                handle.stop();
            }
            long end = System.currentTimeMillis() + timeout;
            for (RepositoryHandle handle : repositoryHandles) {
                long timeLeft;
                if (handle.isStopped() || (timeLeft = end - System.currentTimeMillis()) > 0L && handle.tryStop(timeLeft)) continue;
                monitor.update(Message.newWarning("Unable to stop FishEye repository " + handle.getName() + ". Caches included in this backup may not be consistent. If the problem persists, " + "try stopping the repositories manually, before backup."));
            }
        }

        private void logRestartError(String repoName, ProgressMonitor monitor, String message, Exception e2) {
            String errorMessage = "Unable to restart repository " + repoName + " : " + message;
            if (e2 != null) {
                errorMessage = errorMessage + " : " + e2.getMessage();
                Logs.APP_LOG.warn((Object)errorMessage, (Throwable)e2);
            }
            monitor.update(Message.newWarning(errorMessage));
        }
    }
}

