/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.FileUtils;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.filefilter.TrueFileFilter;

public abstract class FileSaver
implements Saver {
    private BackupItem backupItem;

    protected void addPath(File zipPath, File absolutePath, ZipOutputStream zos, ProgressMonitor monitor, FileFilter fileFilter) throws IOException {
        this.add(new File(this.backupItem.getName(), zipPath.getPath()), absolutePath, zos, monitor, fileFilter);
    }

    protected void addPath(File zipPath, File absolutePath, ZipOutputStream zos, ProgressMonitor monitor) throws IOException {
        this.addPath(zipPath, absolutePath, zos, monitor, (FileFilter)TrueFileFilter.TRUE);
    }

    protected void addInstancePath(String path, ZipOutputStream zos, ProgressMonitor monitor) throws IOException {
        this.addPath(new File(path), new File(AppConfig.getInstanceDir(), path), zos, monitor, (FileFilter)TrueFileFilter.TRUE);
    }

    private void add(File zipPath, File absolutePath, ZipOutputStream zos, ProgressMonitor monitor, FileFilter fileFilter) throws IOException {
        if (!fileFilter.accept(absolutePath)) {
            Logs.APP_LOG.debug((Object)("Ignoring " + absolutePath));
        } else if (!absolutePath.exists()) {
            String warning = String.format("Skipping %s: not found.", absolutePath.getAbsolutePath());
            Logs.APP_LOG.warn((Object)warning);
        } else if (absolutePath.isDirectory()) {
            for (File file : absolutePath.listFiles()) {
                this.add(new File(zipPath, file.getName()), file, zos, monitor, fileFilter);
            }
        } else if (absolutePath.isFile()) {
            monitor.update(new Message(String.format("Adding %s (%s)...", zipPath.getPath(), FileUtils.formatFileSize(absolutePath.length()))));
            ZipEntry entry = new ZipEntry(FileUtils.normaliseSeparators(zipPath.getPath()));
            entry.setTime(absolutePath.lastModified());
            zos.putNextEntry(entry);
            IOHelper.copyStream(absolutePath, (OutputStream)zos);
        } else {
            String warning = String.format("Skipping %s: unknown file type.", absolutePath.getAbsolutePath());
            Logs.APP_LOG.warn((Object)warning);
            monitor.update(new Message(warning));
        }
    }

    @Override
    public void setBackupItem(BackupItem backupItem) {
        this.backupItem = backupItem;
    }
}

