/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathAcceptor;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.util.FileUtils;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;

public abstract class FileBackupItem
implements BackupItem {
    protected Collection<String> list(String path, ZipFile zip) {
        Path zipSearchBase = new Path(new Path(this.getName()), path, true);
        HashSet<String> contents = new HashSet<String>();
        Enumeration enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            Path relative;
            ZipEntry entry = (ZipEntry)enumeration.nextElement();
            Path p2 = new Path((CharSequence)entry.getName(), true);
            if (!p2.hasPrefix(zipSearchBase) || (relative = p2.getRelativePath(zipSearchBase)).numComponents() <= 0) continue;
            contents.add(relative.getComponent(0));
        }
        return contents;
    }

    protected void extractPath(String zipPath, File destPath, ZipFile zip, ProgressMonitor monitor) throws IOException {
        this.extractPath(zipPath, destPath, zip, monitor, PathAcceptor.ALL_PATHS_ACCEPTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractPath(String zipPath, File destPath, ZipFile zip, ProgressMonitor monitor, PathAcceptor entryAcceptor) throws IOException {
        if (!destPath.exists()) {
            destPath.mkdirs();
        }
        Path itemNameAsPath = new Path((CharSequence)this.getName(), true);
        Path basePath = zipPath == null ? itemNameAsPath : new Path(itemNameAsPath, zipPath, true);
        Enumeration enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)enumeration.nextElement();
            Path entryPath = new Path((CharSequence)entry.getName(), true);
            if (!entryPath.hasPrefix(basePath) || entry.isDirectory() || entryPath.getNumComponents() == 1 && this.getName().equals(entryPath.getComponent(0)) || !entryAcceptor.accept(entryPath)) continue;
            File file = new File(destPath, entryPath.getRelativePath(itemNameAsPath).getPath());
            file.getParentFile().mkdirs();
            try (BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));){
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    monitor.update(new Message(String.format("Extracting %s (%s)...", entry.getName(), FileUtils.formatFileSize(entry.getSize()))));
                    IOHelper.copyStream((InputStream)in, (OutputStream)out);
                }
                finally {
                    ((OutputStream)out).close();
                    file.setLastModified(entry.getTime());
                }
            }
        }
    }
}

