/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NoOpProgressMonitor;
import com.atlassian.crucible.migration.NodeParser;
import com.atlassian.crucible.migration.NodeStreamReader;
import com.atlassian.crucible.migration.ParseException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.ThrottledProgressMonitor;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DBImporter {
    static final String BACKUP_NEWER_THAN_DB_MSG = "ERROR: This backup archive is from a newer version of %s and cannot be restored in this version (schema %d > %d)...";
    static final String NO_DB_SUPPORT_FOR_BACKUP_MSG = "ERROR: This backup archive is from a version of %s which did not support %s databases (schema version %d < first supported %2$s version %d). You must upgrade your %1$s instance with your previous database, perform a new backup and then re-import.";
    private final Logger logger = Logger.getLogger("Importer");
    private final ThrottledProgressMonitor monitor;
    private long rows = 0L;
    private boolean batch = true;
    private Set<String> completedTables = new HashSet<String>();
    private final Map<String, Set<String>> tablesWithUniqueStringColumns = Maps.newHashMap();

    public DBImporter() {
        this(NoOpProgressMonitor.INSTANCE);
    }

    public DBImporter(ProgressMonitor monitor) {
        this.tablesWithUniqueStringColumns.put("cru_revision", Sets.newHashSet((Object[])new String[]{"cru_source_name", "cru_revision"}));
        this.tablesWithUniqueStringColumns.put("cru_user", Sets.newHashSet((Object[])new String[]{"cru_user_name"}));
        this.tablesWithUniqueStringColumns.put("cru_perm_scheme", Sets.newHashSet((Object[])new String[]{"cru_name"}));
        this.tablesWithUniqueStringColumns.put("cru_project", Sets.newHashSet((Object[])new String[]{"cru_proj_key"}));
        this.monitor = new ThrottledProgressMonitor(monitor, 1000L);
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(NodeStreamReader streamReader, DBControl database) throws SQLException, ParseException, CruDBException {
        NodeParser node = streamReader.getRootNode();
        assert ("backup".equals(node.getName()));
        if (database.getInfo().state() == DBInfo.DBState.STOPPED) {
            this.monitor.forceUpdate(new Message("Dropping existing tables..."));
            database.dropTables();
        }
        this.monitor.forceUpdate(new Message("Creating table definitions..."));
        int schemaVersion = Integer.parseInt(node.getRequiredAttribute("schemaVersion"));
        if (schemaVersion > DbVersion.getDatabaseVersion()) {
            throw new CruDBException(String.format(BACKUP_NEWER_THAN_DB_MSG, AppConfig.getProductName(), schemaVersion, DbVersion.getDatabaseVersion()));
        }
        if (schemaVersion < database.getType().getMinimalSchemaVersion()) {
            throw new CruDBException(String.format(NO_DB_SUPPORT_FOR_BACKUP_MSG, AppConfig.getProductName(), database.getType().getDisplayName(), schemaVersion, database.getType().getMinimalSchemaVersion()));
        }
        database.createTables(schemaVersion);
        Connection connection = database.getConnection();
        DBType type = database == null || database.getInfo() == null ? DBType.HSQL : database.getInfo().type();
        try {
            boolean autoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try {
                node = node.getNextNode();
                while ("table".equals(node.getName()) && !node.isClosed()) {
                    node = this.importTable(node, type, connection);
                    node = node.getNextNode();
                }
                connection.commit();
            }
            finally {
                connection.setAutoCommit(autoCommit);
            }
        }
        finally {
            database.closeConnection(connection);
        }
        this.monitor.forceUpdate(new Message("Adding database constraints..."));
        database.addConstraints(schemaVersion);
        this.monitor.forceUpdate(new Message("Updating database to latest version..."));
        database.upgrade(DbVersion.getDatabaseVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeParser importTable(NodeParser node, DBType type, Connection connection) throws ParseException, SQLException {
        long rowNum = 0L;
        InserterBuilder builder = new InserterBuilder(node.getRequiredAttribute("name"), type);
        String currentTable = builder.getTable();
        node = node.getNextNode();
        while ("column".equals(node.getName()) && !node.isClosed()) {
            builder.addColumn(node.getRequiredAttribute("name"));
            node = node.getNextNode();
            node = node.getNextNode();
        }
        Inserter inserter = builder.build(connection);
        try {
            try {
                while ("row".equals(node.getName()) && !node.isClosed()) {
                    node = node.getNextNode();
                    while (!node.isClosed()) {
                        inserter.setValue(node);
                        node = node.getNextNode();
                    }
                    inserter.execute();
                    ++rowNum;
                    node = node.getNextNode();
                }
            }
            finally {
                inserter.close();
            }
            this.completedTables.add(currentTable);
            this.sendProgressUpdate();
        }
        catch (SQLException se) {
            this.monitor.forceUpdate(new Message(String.format("Database error at %s:%d (table:row) of the input: %s", currentTable, rowNum, se.getMessage())));
            throw se;
        }
        this.monitor.reset();
        return node;
    }

    private boolean isPartOfUniqueIndex(String tableName, String columnName) {
        Set<String> columns = this.tablesWithUniqueStringColumns.get(tableName);
        return columns != null && columns.contains(columnName);
    }

    private void sendProgressUpdate() {
        this.monitor.update(new Message(String.format("%d rows written, %d tables completed.", this.rows, this.completedTables.size())));
    }

    private abstract class BaseInserter
    implements Inserter {
        private final String tableName;
        private final List<String> columnNames;
        private final IntList maxColumnSize;
        private final ColumnImporter columnImporter;
        protected final PreparedStatement ps;
        private int col;

        public BaseInserter(String tableName, List<String> columnNames, IntList maxColumnSize, ColumnImporter columnImporter, PreparedStatement ps) {
            this.tableName = tableName;
            this.columnNames = columnNames;
            this.maxColumnSize = maxColumnSize;
            this.columnImporter = columnImporter;
            this.ps = ps;
            this.col = 1;
        }

        private void setBoolean(Boolean value) throws SQLException {
            this.columnImporter.setBoolean(this.ps, this.col, value);
        }

        private void setString(String value) throws SQLException {
            int maxSize;
            if (value != null && (maxSize = this.maxColumnSize.getInt(this.col)) != -1 && value.length() > maxSize) {
                if (DBImporter.this.isPartOfUniqueIndex(this.getTableName(), this.getColumnName(this.col))) {
                    String message = "The value of column " + this.getTableName() + "." + this.getColumnName(this.col) + ", '" + value + "' has a length of " + value.length() + " which is greater than the maximum allowed length for this column of " + maxSize + ". As this column is part of a unique index, the migration cannot be completed.";
                    throw new SQLException(message);
                }
                String oldValue = value;
                value = oldValue.substring(0, maxSize);
                String message = "Truncating value of column " + this.getTableName() + "." + this.getColumnName(this.col) + " from '" + oldValue + "' to '" + value + "' because its length of " + oldValue.length() + " is greater than the maximum allowed length for this column of " + maxSize + ".";
                DBImporter.this.logger.warning(message);
                DBImporter.this.monitor.forceUpdate(new Message(message));
            }
            this.columnImporter.setString(this.ps, this.col, value);
        }

        private String getColumnName(int col) {
            return this.columnNames.get(col - 1);
        }

        private void setDate(Date value) throws SQLException {
            this.columnImporter.setDate(this.ps, this.col, value);
        }

        private void setBigInteger(BigInteger value) throws SQLException {
            this.columnImporter.setBigInteger(this.ps, this.col, value);
        }

        @Override
        public void setValue(NodeParser node) throws SQLException, ParseException {
            if ("escapedString".equals(node.getName())) {
                this.setString(node.getContentAsString());
            } else if ("boolean".equals(node.getName())) {
                this.setBoolean(node.getContentAsBoolean());
            } else if ("integer".equals(node.getName())) {
                this.setBigInteger(node.getContentAsBigInteger());
            } else if ("timestamp".equals(node.getName())) {
                this.setDate(node.getContentAsDate());
            } else {
                throw new IllegalArgumentException("Unsupported field encountered: " + node.getName());
            }
            ++this.col;
        }

        @Override
        public final void execute() throws SQLException {
            this.executePS();
            this.col = 1;
            DBImporter.this.rows++;
            DBImporter.this.sendProgressUpdate();
        }

        protected abstract void executePS() throws SQLException;

        public String getTableName() {
            return this.tableName;
        }
    }

    private class OracleColumnImporter
    extends CommonColumnImporter {
        private OracleColumnImporter() {
        }

        @Override
        public void setBoolean(PreparedStatement ps, int col, Boolean value) throws SQLException {
            if (value == null) {
                ps.setNull(col, -7);
            } else {
                ps.setBoolean(col, value);
            }
        }
    }

    private class CommonColumnImporter
    implements ColumnImporter {
        private CommonColumnImporter() {
        }

        @Override
        public void setBoolean(PreparedStatement ps, int col, Boolean value) throws SQLException {
            if (value == null) {
                ps.setNull(col, 16);
            } else {
                ps.setBoolean(col, value);
            }
        }

        @Override
        public void setString(PreparedStatement ps, int col, String value) throws SQLException {
            if (value == null) {
                ps.setNull(col, 12);
            } else {
                ps.setString(col, value);
            }
        }

        @Override
        public void setDate(PreparedStatement ps, int col, Date value) throws SQLException {
            if (value == null) {
                ps.setNull(col, 93);
            } else {
                ps.setTimestamp(col, new Timestamp(value.getTime()));
            }
        }

        @Override
        public void setBigInteger(PreparedStatement ps, int col, BigInteger value) throws SQLException {
            if (value == null) {
                ps.setNull(col, -5);
            } else {
                ps.setBigDecimal(col, new BigDecimal(value));
            }
        }
    }

    private static interface ColumnImporter {
        public void setBoolean(PreparedStatement var1, int var2, Boolean var3) throws SQLException;

        public void setString(PreparedStatement var1, int var2, String var3) throws SQLException;

        public void setDate(PreparedStatement var1, int var2, Date var3) throws SQLException;

        public void setBigInteger(PreparedStatement var1, int var2, BigInteger var3) throws SQLException;
    }

    private class BatchInserter
    extends BaseInserter {
        private final int batchSize;
        private int batch;

        private BatchInserter(String table, List<String> columns, IntList maxColumnSize, ColumnImporter columnImporter, PreparedStatement ps) {
            super(table, columns, maxColumnSize, columnImporter, ps);
            this.batchSize = 5000;
            this.batch = 0;
        }

        @Override
        protected void executePS() throws SQLException {
            this.ps.addBatch();
            this.batch = (this.batch + 1) % this.batchSize;
            if (this.batch == 0) {
                this.flush();
            }
        }

        private void flush() throws SQLException {
            for (int result : this.ps.executeBatch()) {
                if (result != -3) continue;
                throw new SQLException("SQL batch insert failed.");
            }
            this.ps.getConnection().commit();
        }

        @Override
        public void close() throws SQLException {
            this.flush();
            JDBCHelper.closeQuietly(this.ps);
        }
    }

    private class ImmediateInserter
    extends BaseInserter {
        private ImmediateInserter(String table, List<String> columns, IntList maxColumnSize, ColumnImporter columnImporter, PreparedStatement ps) {
            super(table, columns, maxColumnSize, columnImporter, ps);
        }

        @Override
        protected void executePS() throws SQLException {
            this.ps.execute();
        }

        @Override
        public void close() throws SQLException {
            JDBCHelper.closeQuietly(this.ps);
        }
    }

    private static interface Inserter {
        public void setValue(NodeParser var1) throws SQLException, ParseException;

        public void execute() throws SQLException;

        public void close() throws SQLException;
    }

    class InserterBuilder {
        private final String table;
        private final DBType type;
        private final List<String> columns;

        public InserterBuilder(String table, DBType dbType) {
            this.table = table;
            this.type = dbType;
            this.columns = new ArrayList<String>();
        }

        public String getTable() {
            return this.table;
        }

        public void addColumn(String column) {
            this.columns.add(column);
        }

        public Inserter build(Connection connection) throws SQLException {
            int i2;
            StringBuilder query = new StringBuilder("INSERT INTO ").append(this.table).append(" (");
            for (i2 = 0; i2 < this.columns.size(); ++i2) {
                query.append(this.columns.get(i2));
                if (i2 >= this.columns.size() - 1) continue;
                query.append(", ");
            }
            query.append(") VALUES (");
            for (i2 = 0; i2 < this.columns.size(); ++i2) {
                query.append("?");
                if (i2 >= this.columns.size() - 1) continue;
                query.append(", ");
            }
            query.append(")");
            IntList maxColumnSizes = this.calculateColumnSizes(connection, this.columns);
            PreparedStatement ps = connection.prepareStatement(query.toString());
            DBImporter.this.logger.fine("PreparedStatement created for query: " + query.toString());
            CommonColumnImporter columnImporter = this.type == DBType.ORACLE ? new OracleColumnImporter() : new CommonColumnImporter();
            return DBImporter.this.batch ? new BatchInserter(this.getTable(), this.columns, maxColumnSizes, columnImporter, ps) : new ImmediateInserter(this.getTable(), this.columns, maxColumnSizes, columnImporter, ps);
        }

        private IntList calculateColumnSizes(Connection connection, List<String> columns) throws SQLException {
            HashMap columnSizeMap = Maps.newHashMap();
            ResultSet rs = connection.getMetaData().getColumns(null, null, this.table, null);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                columnSizeMap.put(columnName, columnSize);
            }
            IntArrayList sizes = new IntArrayList();
            sizes.add(0);
            for (String column : columns) {
                Integer size = (Integer)columnSizeMap.get(column);
                if (size == null) {
                    size = -1;
                }
                sizes.add((Object)size);
            }
            return sizes;
        }
    }
}

