/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NodeCreator;
import com.atlassian.crucible.migration.NodeStreamWriter;
import com.atlassian.crucible.migration.ParseException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.ThrottledProgressMonitor;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.fisheye.util.JDBCHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class DBExporter {
    public static final int ORACLE_BOOL_NUM_PRECISION = 1;
    public static final int ORACLE_SMALL_INT_NUM_PRECISION = 5;
    public static final int ORACLE_INT_NUM_PRECISION = 10;
    public static final int ORACLE_LONG_NUM_PRECISION = 19;
    public static final int FETCH_SIZE = 100;
    private final Predicate<String> tableNamePredicate;
    private final ThrottledProgressMonitor monitor;
    private long rows = 0L;
    private String currentTable;
    private int totalTables = 0;
    private int completedTables = 0;
    private long constraintViolations = 0L;

    public DBExporter(Predicate<String> tableNamePredicate, ProgressMonitor monitor) {
        this.tableNamePredicate = tableNamePredicate;
        this.monitor = new ThrottledProgressMonitor(monitor, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getTableNames(Connection connection) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet result = connection.getMetaData().getTables(null, null, "%", tableTypes);
        try {
            while (result.next()) {
                String tableName = result.getString("TABLE_NAME");
                if (!this.tableNamePredicate.test(tableName)) continue;
                tables.add(tableName);
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        finally {
            JDBCHelper.closeQuietly(result);
        }
    }

    public void exportData(DBType dbType, Connection connection, NodeStreamWriter streamWriter) throws IOException, SQLException {
        NodeCreator node = streamWriter.addRootNode("backup");
        node.addAttribute("schemaVersion", String.valueOf(DbVersion.getDatabaseVersion()));
        Set<String> allTables = this.getTableNames(connection);
        this.totalTables = allTables.size();
        for (String table : allTables) {
            this.currentTable = table.toLowerCase();
            node = this.exportTable(dbType, table, connection, node);
        }
        node.closeEntity();
        if (this.constraintViolations > 0L) {
            String message = String.format("Warning: %d database records had constraint violations. This backup may not work if you migrate to a database product other than %s.", this.constraintViolations, connection.getMetaData().getDatabaseProductName());
            this.monitor.forceUpdate(Message.newWarning(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeCreator exportTable(DBType dbType, String table, Connection connection, NodeCreator node) throws SQLException, IOException {
        NodeCreator nodeCreator;
        node = node.addNode("table");
        node.addAttribute("name", table.toLowerCase());
        Statement statement = connection.createStatement();
        ResultSet result = null;
        try {
            if (dbType.equals((Object)DBType.MYSQL)) {
                statement.setFetchSize(Integer.MIN_VALUE);
            } else {
                statement.setFetchSize(100);
            }
            result = statement.executeQuery("SELECT * FROM " + table);
            ResultSetMetaData meta = result.getMetaData();
            node = this.writeColumnDefinitions(node, meta);
            CommonColumnExporter columnExporter = dbType.accept(new DBType.VisitorAdapter<CommonColumnExporter>(){

                @Override
                public CommonColumnExporter visitDefault() {
                    return new CommonColumnExporter();
                }

                @Override
                public CommonColumnExporter visitHsql() {
                    return new HsqlColumnExporter();
                }

                @Override
                public CommonColumnExporter visitOracle() {
                    return new OracleColumnExporter();
                }

                @Override
                public CommonColumnExporter visitSQLServer2005() {
                    return new SQLServerColumnExporter();
                }

                @Override
                public CommonColumnExporter visitSQLServer2008() {
                    return new SQLServerColumnExporter();
                }
            });
            while (result.next()) {
                node = this.exportRow(columnExporter, node, result, meta);
            }
            ++this.completedTables;
            this.sendUpdate();
            this.monitor.reset();
            nodeCreator = node.closeEntity();
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(result, statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly(result, statement);
        return nodeCreator;
    }

    private NodeCreator writeColumnDefinitions(NodeCreator node, ResultSetMetaData metaData) throws SQLException, ParseException {
        for (int i2 = 1; i2 <= metaData.getColumnCount(); ++i2) {
            node = node.addNode("column");
            node.addAttribute("name", metaData.getColumnName(i2).toLowerCase());
            node = node.closeEntity();
        }
        return node;
    }

    private void throwCantEncodePrecisionScale(ResultSetMetaData metaData, int col, int scale, int precision) throws SQLException {
        throw new SQLException(String.format("Cannot encode NUMERIC value for unsupported precision, scale: (%d, %d) of column %s.%s", precision, scale, metaData.getTableName(col), metaData.getColumnName(col)));
    }

    private void throwCantEncodeJdbcType(ResultSetMetaData metaData, int col) throws SQLException {
        throw new SQLException(String.format("Cannot encode value for unsupported column type: \"%s\" (%d) of column %s.%s", metaData.getColumnTypeName(col), metaData.getColumnType(col), metaData.getTableName(col), metaData.getColumnName(col)));
    }

    private NodeCreator exportRow(ColumnExporter colExporter, NodeCreator node, ResultSet result, ResultSetMetaData metaData) throws IOException, SQLException {
        int columns = metaData.getColumnCount();
        node = node.addNode("row");
        for (int col = 1; col <= columns; ++col) {
            node = colExporter.export(node, result, metaData, col);
        }
        ++this.rows;
        this.sendUpdate();
        return node.closeEntity();
    }

    private void sendUpdate() {
        this.monitor.update(new Message(String.format("%d rows written, %d of %d tables completed.", this.rows, this.completedTables, this.totalTables)));
    }

    private class SQLServerColumnExporter
    extends CommonColumnExporter {
        private SQLServerColumnExporter() {
        }

        @Override
        public NodeCreator export(NodeCreator node, ResultSet result, ResultSetMetaData metaData, int col) throws SQLException, IOException {
            switch (metaData.getColumnType(col)) {
                case -1: 
                case 1: 
                case 12: 
                case 93: 
                case 2005: {
                    String stringValue = result.getString(col);
                    this.warnIfStringTooLong(result, metaData, col, stringValue);
                    node = node.addNode("escapedString").setContentAsString(stringValue).closeEntity();
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    long longValue = result.getLong(col);
                    node = node.addNode("integer").setContentAsBigInteger(result.wasNull() ? null : BigInteger.valueOf(longValue)).closeEntity();
                    break;
                }
                case -6: {
                    boolean boolValue = result.getBoolean(col);
                    node = node.addNode("boolean").setContentAsBoolean(result.wasNull() ? null : Boolean.valueOf(boolValue)).closeEntity();
                    break;
                }
                default: {
                    DBExporter.this.throwCantEncodeJdbcType(metaData, col);
                }
            }
            return node;
        }
    }

    private class OracleColumnExporter
    extends CommonColumnExporter {
        private OracleColumnExporter() {
        }

        @Override
        public NodeCreator export(NodeCreator node, ResultSet result, ResultSetMetaData metaData, int col) throws SQLException, IOException {
            block0 : switch (metaData.getColumnType(col)) {
                case -1: 
                case 1: 
                case 12: {
                    String stringValue = result.getString(col);
                    this.warnIfStringTooLong(result, metaData, col, stringValue);
                    node = node.addNode("escapedString").setContentAsString(stringValue).closeEntity();
                    break;
                }
                case 2005: {
                    String clobValue = result.getString(col);
                    node = node.addNode("escapedString").setContentAsString(clobValue).closeEntity();
                    break;
                }
                case 2: {
                    int scale = metaData.getScale(col);
                    int precision = metaData.getPrecision(col);
                    if (scale == 0) {
                        switch (precision) {
                            case 1: {
                                byte byteValue = result.getByte(col);
                                node = node.addNode("boolean").setContentAsBoolean(result.wasNull() ? null : Boolean.valueOf(byteValue != 0)).closeEntity();
                                break block0;
                            }
                            case 5: 
                            case 10: 
                            case 19: {
                                BigDecimal bdValue = result.getBigDecimal(col);
                                node = node.addNode("integer").setContentAsBigInteger(result.wasNull() ? null : bdValue.toBigIntegerExact()).closeEntity();
                                break block0;
                            }
                        }
                        DBExporter.this.throwCantEncodePrecisionScale(metaData, col, scale, precision);
                        break;
                    }
                    DBExporter.this.throwCantEncodePrecisionScale(metaData, col, scale, precision);
                    break;
                }
                case 93: {
                    return super.export(node, result, metaData, col);
                }
                default: {
                    DBExporter.this.throwCantEncodeJdbcType(metaData, col);
                }
            }
            return node;
        }
    }

    private class HsqlColumnExporter
    extends CommonColumnExporter {
        private HsqlColumnExporter() {
        }

        @Override
        protected void warnIfStringTooLong(ResultSet result, ResultSetMetaData metaData, int col, String string) throws SQLException {
            if (string != null && string.length() > metaData.getColumnDisplaySize(col)) {
                DBExporter.this.monitor.forceUpdate(new Message(String.format("Warning: %s:%d (table:row), value for column %s (%d chars) exceeds max length (%d chars).", DBExporter.this.currentTable, result.getRow(), metaData.getColumnName(col).toLowerCase(), string.length(), metaData.getColumnDisplaySize(col))));
                DBExporter.this.constraintViolations++;
            }
        }
    }

    private class CommonColumnExporter
    implements ColumnExporter {
        private CommonColumnExporter() {
        }

        @Override
        public NodeCreator export(NodeCreator node, ResultSet result, ResultSetMetaData metaData, int col) throws SQLException, IOException {
            switch (metaData.getColumnType(col)) {
                case -5: 
                case 4: 
                case 5: {
                    BigDecimal bigDecimal = result.getBigDecimal(col);
                    node = node.addNode("integer").setContentAsBigInteger(result.wasNull() ? null : bigDecimal.toBigIntegerExact()).closeEntity();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String string = result.getString(col);
                    if (string != null && string.length() == 0 && metaData.isNullable(col) == 0) {
                        string = " ";
                    }
                    this.warnIfStringTooLong(result, metaData, col, string);
                    node = node.addNode("escapedString").setContentAsString(string).closeEntity();
                    break;
                }
                case -7: 
                case 16: {
                    boolean bool = result.getBoolean(col);
                    node = node.addNode("boolean").setContentAsBoolean(result.wasNull() ? null : Boolean.valueOf(bool)).closeEntity();
                    break;
                }
                case 93: {
                    Timestamp ts = result.getTimestamp(col);
                    node = node.addNode("timestamp").setContentAsDate(ts).closeEntity();
                    break;
                }
                default: {
                    DBExporter.this.throwCantEncodeJdbcType(metaData, col);
                }
            }
            return node;
        }

        protected void warnIfStringTooLong(ResultSet result, ResultSetMetaData metaData, int col, String string) throws SQLException {
        }
    }

    private static interface ColumnExporter {
        public NodeCreator export(NodeCreator var1, ResultSet var2, ResultSetMetaData var3, int var4) throws SQLException, IOException;
    }
}

