/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NodeCreator;
import com.atlassian.crucible.migration.NodeStreamWriter;
import com.atlassian.crucible.migration.ParseException;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class ConfigurableAnonymisingStreamWriter
implements NodeStreamWriter {
    private static final String PROPERTIES_FILE = "anonymiser.properties";
    private final Map<String, Anonymiser> anonymisers = new HashMap<String, Anonymiser>();
    private final NodeStreamWriter writer;

    public ConfigurableAnonymisingStreamWriter(NodeStreamWriter writer) throws IOException {
        this(writer, ConfigurableAnonymisingStreamWriter.loadConfiguration());
    }

    public ConfigurableAnonymisingStreamWriter(NodeStreamWriter writer, Properties configuration) {
        if (writer == null || configuration == null) {
            throw new IllegalArgumentException("NodeStreamWriter and Properties cannot be null");
        }
        Enumeration<?> keys = configuration.propertyNames();
        while (keys.hasMoreElements()) {
            String tableCol = (String)keys.nextElement();
            String type = configuration.getProperty(tableCol);
            if ("substitute".equals(type)) {
                this.anonymisers.put(tableCol, new SubstitutingAnonymiser());
                continue;
            }
            if ("hash".equals(type)) {
                this.anonymisers.put(tableCol, new HashingAnonymiser());
                continue;
            }
            throw new IllegalArgumentException("Unsupported anonymiser specified: " + type);
        }
        this.writer = writer;
    }

    private static Properties loadConfiguration() throws IOException {
        Properties props = new Properties();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_FILE);
        try {
            if (in != null) {
                props.load(in);
            } else {
                Logs.APP_LOG.warn((Object)"Configuration file for Crucible database anonymisation could not be found in the classpath (anonymiser.properties). Anonymisation disabled.");
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return props;
    }

    @Override
    public NodeCreator addRootNode(String name) throws ParseException, IllegalStateException {
        final NodeCreator root = this.writer.addRootNode(name);
        return new NodeCreator(){
            private State state = null;
            private String table;
            private int col = 0;
            private final List<Anonymiser> columns = new ArrayList<Anonymiser>();
            private NodeCreator creator = root;

            @Override
            public NodeCreator addNode(String name) throws ParseException {
                this.creator = this.creator.addNode(name);
                if ("table".equals(name)) {
                    this.state = State.OPEN_TABLE;
                } else if ("column".equals(name)) {
                    this.state = State.OPEN_COLUMN;
                } else if ("row".equals(name)) {
                    this.col = 0;
                    this.state = State.OPEN_ROW;
                }
                return this;
            }

            @Override
            public NodeCreator closeEntity() throws ParseException {
                this.creator = this.creator.closeEntity();
                return this.creator == null ? null : this;
            }

            @Override
            public NodeCreator setContentAsDate(Date date) throws ParseException {
                this.creator = this.creator.setContentAsDate(this.columns.get(this.col).anonymise(date));
                ++this.col;
                return this;
            }

            @Override
            public NodeCreator setContentAsBigInteger(BigInteger bigInteger) throws ParseException {
                this.creator = this.creator.setContentAsBigInteger(this.columns.get(this.col).anonymise(bigInteger));
                ++this.col;
                return this;
            }

            @Override
            public NodeCreator setContentAsString(String string) throws ParseException {
                this.creator = this.creator.setContentAsString(this.columns.get(this.col).anonymise(string));
                ++this.col;
                return this;
            }

            @Override
            public NodeCreator setContentAsBoolean(Boolean bool) throws ParseException {
                this.creator = this.creator.setContentAsBoolean(this.columns.get(this.col).anonymise(bool));
                ++this.col;
                return this;
            }

            @Override
            public NodeCreator setContent(Reader data) throws IOException, ParseException {
                this.creator = this.creator.setContent(this.columns.get(this.col).anonymise(data));
                ++this.col;
                return this;
            }

            @Override
            public void addAttribute(String key, String value) throws ParseException {
                this.creator.addAttribute(key, value);
                if ("name".equals(key)) {
                    if (this.state == State.OPEN_TABLE) {
                        this.table = value;
                        this.columns.clear();
                    } else if (this.state == State.OPEN_COLUMN) {
                        Anonymiser anonymiser = (Anonymiser)ConfigurableAnonymisingStreamWriter.this.anonymisers.get(this.table + "." + value);
                        if (anonymiser == null) {
                            anonymiser = new Anonymiser(){

                                @Override
                                public <T> T anonymise(T value) {
                                    return value;
                                }
                            };
                        }
                        this.columns.add(anonymiser);
                    }
                }
            }
        };
    }

    @Override
    public void flush() throws ParseException {
        this.writer.flush();
    }

    @Override
    public void close() throws ParseException {
        this.writer.close();
    }

    private static enum State {
        OPEN_TABLE,
        OPEN_COLUMN,
        OPEN_ROW;

    }

    protected static class HashingAnonymiser
    implements Anonymiser {
        protected HashingAnonymiser() {
        }

        @Override
        public <T> T anonymise(T value) {
            return (T)(value instanceof String ? Integer.toString(value.hashCode()) + ":" + ((String)value).length() : value);
        }
    }

    protected static class SubstitutingAnonymiser
    implements Anonymiser {
        public static final char ANON_CHAR = 'x';
        private final StringBuilder buf = new StringBuilder();

        protected SubstitutingAnonymiser() {
        }

        private void ensureCapacity(int length) {
            int needed = Math.max(0, length - this.buf.length());
            for (int i2 = 0; i2 < needed; ++i2) {
                this.buf.append('x');
            }
        }

        @Override
        public <T> T anonymise(T value) {
            if (value instanceof String) {
                String s2 = (String)value;
                this.ensureCapacity(s2.length());
                return (T)this.buf.substring(0, s2.length());
            }
            return value;
        }
    }

    private static interface Anonymiser {
        public <T> T anonymise(T var1);
    }
}

