/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.SaverFactory;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.ctl.RestoreConfig;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class ConfigBackup
extends FileBackupItem {
    private static final String CONFIG_FILE = "config.xml";

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        return SaverFactory.create(beanFactory, SaverImpl.class, this);
    }

    @Override
    public String getName() {
        return "config";
    }

    @Override
    public String getDescription() {
        return "all configuration information";
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public Restorer getRestorer(final ZipFile zip, final ProgressMonitor monitor, final Map<String, String> properties) throws BackupException {
        return new Restorer(){

            @Override
            public void restore() throws IOException {
                RestoreConfig restoreConfig = new RestoreConfig(zip, properties, monitor);
                ConfigDocument doc = restoreConfig.getConfigFromBackup();
                File file = new File(AppConfig.getInstanceDir(), ConfigBackup.CONFIG_FILE);
                XmlOptions opts = new XmlOptions();
                opts.setSaveImplicitNamespaces(RootConfig.makeExplicitNamespaces());
                doc.save(file, opts);
                if (restoreConfig.isDbConfigOverriden()) {
                    monitor.update(new Message(String.format("Merged database configuration into %s", file.getPath())));
                }
                try {
                    AppConfig.getsConfig().load(file);
                }
                catch (ConfigException e2) {
                    throw new RuntimeException("Failed to load saved config file at " + file.getAbsolutePath(), e2);
                }
            }
        };
    }

    private static class SaverImpl
    extends FileSaver {
        private SaverImpl() {
        }

        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            this.addPath(new File(ConfigBackup.CONFIG_FILE), AppConfig.getConfigurationFile(), zos, monitor);
        }
    }
}

