/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NodeCreator;
import com.atlassian.crucible.migration.NodeStreamWriter;
import com.atlassian.crucible.migration.ParseException;
import com.atlassian.security.password.RandomSaltGenerator;
import com.cenqua.fisheye.util.HashUtils;
import com.cenqua.fisheye.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;
import org.apache.ws.commons.util.Base64;

public class AnonymisingStreamWriter
implements NodeStreamWriter {
    private final NodeStreamWriter writer;
    private final MessageDigest sha256 = HashUtils.getMessageDigest("SHA-256");
    private final int SALT_LENGTH = 32;
    private final int HASHED_STRING_LENGTH = 15;
    private final byte[] salt = new RandomSaltGenerator().generateSalt(32);

    public AnonymisingStreamWriter(NodeStreamWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer cannot be null");
        }
        this.writer = writer;
    }

    protected String anonymise(String string) {
        if (string == null) {
            return string;
        }
        byte[] stringAndSaltBytes = ArrayUtils.addAll((byte[])string.getBytes(), (byte[])this.salt);
        byte[] saltedStringHash = this.sha256.digest(stringAndSaltBytes);
        return StringUtil.truncate(new String(Base64.encode((byte[])saltedStringHash)), 15, false);
    }

    @Override
    public NodeCreator addRootNode(String name) throws ParseException, IllegalStateException {
        final NodeCreator root = this.writer.addRootNode(name);
        return new NodeCreator(){
            private NodeCreator creator;
            {
                this.creator = root;
            }

            @Override
            public NodeCreator addNode(String name) throws ParseException {
                this.creator = this.creator.addNode(name);
                return this;
            }

            @Override
            public NodeCreator closeEntity() throws ParseException {
                this.creator = this.creator.closeEntity();
                return this.creator == null ? null : this;
            }

            @Override
            public NodeCreator setContentAsDate(Date date) throws ParseException {
                this.creator = this.creator.setContentAsDate(date);
                return this;
            }

            @Override
            public NodeCreator setContentAsBigInteger(BigInteger bigInteger) throws ParseException {
                this.creator = this.creator.setContentAsBigInteger(bigInteger);
                return this;
            }

            @Override
            public NodeCreator setContentAsString(String string) throws ParseException {
                this.creator = this.creator.setContentAsString(AnonymisingStreamWriter.this.anonymise(string));
                return this;
            }

            @Override
            public NodeCreator setContentAsBoolean(Boolean bool) throws ParseException {
                this.creator = this.creator.setContentAsBoolean(bool);
                return this;
            }

            @Override
            public NodeCreator setContent(Reader data) throws IOException, ParseException {
                this.creator = this.creator.setContent(data);
                return this;
            }

            @Override
            public void addAttribute(String key, String value) throws ParseException {
                this.creator.addAttribute(key, value);
            }
        };
    }

    @Override
    public void flush() throws ParseException {
        this.writer.flush();
    }

    @Override
    public void close() throws ParseException {
        this.writer.close();
    }
}

