/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.BackupProgressMonitor;
import com.atlassian.activeobjects.spi.RestoreProgressMonitor;
import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.ctl.Restore;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class ActiveObjectsBackup
implements BackupItem {
    private static final String NAME = "ao";
    private static final String ZIP_ENTRY = "ao/database.xml";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "ActiveObjects";
    }

    @Override
    public boolean isCrucible() {
        return true;
    }

    @Override
    public boolean isFishEye() {
        return true;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
        Backup backupService = (Backup)beanFactory.getBean("backup", Backup.class);
        return new ActiveObjectsSaver(backupService);
    }

    @Override
    public Restorer getRestorer(ZipFile zip, ProgressMonitor monitor, Map<String, String> properties) throws BackupException {
        return new ActiveObjectsRestorer(zip, monitor);
    }

    public static class ProgressMonitorAdaptor
    implements BackupProgressMonitor,
    RestoreProgressMonitor {
        private final ProgressMonitor delegate;

        public ProgressMonitorAdaptor(ProgressMonitor delegate) {
            this.delegate = delegate;
        }

        public void beginBackup() {
            this.delegate.update(new Message("Starting ActiveObjects backup..."));
        }

        public void endBackup() {
            this.delegate.update(new Message("ActiveObjects backup completed!"));
        }

        public void beginDatabaseInformationBackup() {
            this.delegate.update(new Message("* Backing up Database Information"));
        }

        public void beginTableDefinitionsBackup() {
            this.delegate.update(new Message("* Backing up Table Definitions"));
        }

        public void beginTablesBackup() {
            this.delegate.update(new Message("* Backing up Tables"));
        }

        public void beginTableBackup(String tableName) {
            this.delegate.update(new Message("** Backing up '" + tableName + "'"));
        }

        public void updateTotalNumberOfTablesToBackup(int tableCount) {
            this.delegate.update(new Message("** Table count: " + tableCount));
        }

        public void endDatabaseInformationBackup() {
        }

        public void endTableDefinitionsBackup() {
        }

        public void endTablesBackup() {
        }

        public void endTableBackup(String tableName) {
        }

        public void beginRestore() {
            this.delegate.update(new Message("Starting ActiveObjects restore..."));
        }

        public void endRestore() {
            this.delegate.update(new Message("ActiveObjects restore completed!"));
        }

        public void beginDatabaseInformationRestore() {
            this.delegate.update(new Message("* Restoring Database Information"));
        }

        public void beginTableDefinitionsRestore() {
            this.delegate.update(new Message("* Restoring Table Definitions"));
        }

        public void beginTablesRestore() {
            this.delegate.update(new Message("* Restoring Tables"));
        }

        public void beginTableDataRestore(String tableName) {
            this.delegate.update(new Message("** Restoring data to '" + tableName + "'"));
        }

        public void beginTableCreationRestore(String tableName) {
            this.delegate.update(new Message("** Creating table '" + tableName + "'"));
        }

        public void beginTableRowRestore() {
            this.delegate.update(new Message("* Restoring Table Data"));
        }

        public void endDatabaseInformationRestore() {
        }

        public void endTableDefinitionsRestore() {
        }

        public void endTablesRestore() {
        }

        public void endTableDataRestore(String s2) {
        }

        public void endTableCreationRestore(String s2) {
        }

        public void endTableRowRestore() {
        }

        public void updateTotalNumberOfTablesToRestore(int tableCount) {
            this.delegate.update(new Message("** Table count: " + tableCount));
        }
    }

    static class ActiveObjectsRestorer
    implements Restorer {
        private final ZipFile zip;
        private final ProgressMonitor monitor;

        public ActiveObjectsRestorer(ZipFile zip, ProgressMonitor monitor) {
            this.zip = zip;
            this.monitor = monitor;
        }

        @Override
        public void restore() throws IOException {
            Restore.destroyApplicationContext();
            Restore.createApplicationContext();
            this.startDbIfNotRunning();
            ZipEntry entry = this.zip.getEntry(ActiveObjectsBackup.ZIP_ENTRY);
            if (entry != null) {
                Backup backupService = SpringContext.getComponent(Backup.class, "backup");
                backupService.restore(this.zip.getInputStream(entry), (RestoreProgressMonitor)new ProgressMonitorAdaptor(this.monitor));
            }
        }

        private void startDbIfNotRunning() throws IOException {
            DBControlFactory dbFactory = SpringContext.getComponent(DBControlFactory.class, "dbControlFactory");
            try {
                if (!dbFactory.getCurrentControl().isRunning()) {
                    dbFactory.getCurrentControl().start();
                }
            }
            catch (CruDBException e2) {
                throw new IOException("Error starting database to restore active objects plugin data: " + e2.getMessage(), e2);
            }
        }
    }

    static class ActiveObjectsSaver
    implements Saver {
        private final Backup backupService;

        public ActiveObjectsSaver(Backup backupService) {
            this.backupService = backupService;
        }

        @Override
        public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
            zos.putNextEntry(new ZipEntry(ActiveObjectsBackup.ZIP_ENTRY));
            this.backupService.save((OutputStream)zos, (BackupProgressMonitor)new ProgressMonitorAdaptor(monitor));
        }

        @Override
        public void setBackupItem(BackupItem backupItem) {
        }
    }
}

