/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration;

import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.item.Message;

public class ThrottledProgressMonitor
implements ProgressMonitor {
    private final ProgressMonitor monitor;
    private final long interval;
    private long lastReportTime;

    public ThrottledProgressMonitor(ProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.interval = interval;
        this.reset();
    }

    @Override
    public void update(Message resource) {
        long now = System.currentTimeMillis();
        if (resource.isWarning() || now - this.lastReportTime > this.interval) {
            this.forceUpdate(resource);
            this.lastReportTime = now;
        }
    }

    public void forceUpdate(Message resource) {
        this.monitor.update(resource);
    }

    public void reset() {
        this.lastReportTime = 0L;
    }
}

