/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration;

import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.fisheye.logging.Logs;
import java.util.ArrayList;
import java.util.List;

public class StoringProgressMonitor
implements ProgressMonitor {
    private List<Message> messages = new ArrayList<Message>();
    private List<Message> warnings = new ArrayList<Message>();
    private final boolean quietMode;
    private final ProgressMonitor monitor;

    public StoringProgressMonitor() {
        this(true, null);
    }

    public StoringProgressMonitor(ProgressMonitor monitor) {
        this(false, monitor);
    }

    public StoringProgressMonitor(boolean quietMode, ProgressMonitor monitor) {
        this.quietMode = quietMode;
        this.monitor = monitor;
    }

    @Override
    public void update(Message message) {
        if (message == null) {
            Logs.APP_LOG.warn((Object)"Attempt to add null backup message", (Throwable)new Exception());
        } else {
            if (message.isWarning()) {
                this.warnings.add(message);
            }
            if (!this.quietMode) {
                this.messages.add(message);
            }
            if (this.monitor != null) {
                this.monitor.update(message);
            }
        }
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<Message> getWarnings() {
        return this.warnings;
    }
}

