/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration;

import com.atlassian.crucible.maintenance.MaintenanceManager;
import com.atlassian.crucible.maintenance.MaintenanceTask;
import com.atlassian.crucible.migration.AbstractBackupManager;
import com.atlassian.crucible.migration.BackupFrequency;
import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.BackupJob;
import com.atlassian.crucible.migration.BackupStatus;
import com.atlassian.crucible.migration.MessageLoggingProgressMonitor;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.ScheduledBackupJob;
import com.atlassian.crucible.migration.StoringProgressMonitor;
import com.atlassian.crucible.migration.item.Message;
import com.atlassian.crucible.resource.ThreadPool;
import com.atlassian.fisheye.quartz.QuartzManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.BackupFrequencyType;
import com.cenqua.fisheye.config1.BackupItemType;
import com.cenqua.fisheye.config1.BackupType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.FileSystemUtils;
import com.google.common.base.Strings;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.quartz.SchedulerException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class BackupManagerImpl
extends AbstractBackupManager
implements BeanFactoryAware {
    private static final String DATE_FORMAT = "yyyy-dd-MM_HHmm";
    private final FisheyeVersionInfo version = new FisheyeVersionInfo();
    @Resource(name="maintenanceManager")
    private MaintenanceManager maintenanceManager;
    @Resource(name="quartzManager")
    private QuartzManager quartzManager;
    @Resource(name="threadPool")
    private ThreadPool executorService;
    @Autowired
    private RootConfig rootConfig;
    private BackupStatus status = null;
    private ScheduledBackupJob scheduledJob = null;
    private AutowireCapableBeanFactory beanFactory;

    @PostConstruct
    public void startSchedule() {
        BackupType.Schedule schedule;
        ConfigDocument.Config cfg = this.rootConfig.getConfig();
        if (cfg.isSetBackup() && (schedule = cfg.getBackup().getSchedule()) != null && schedule.getEnabled()) {
            String prefix = schedule.getPrefix();
            String pattern = schedule.getDatePattern();
            String time = schedule.getTime();
            BackupFrequency frequency = BackupFrequency.valueOf(schedule.getFrequency().toString());
            HashSet<String> items = new HashSet<String>();
            for (BackupType.Schedule.Items.Item item : schedule.getItems().getItemArray()) {
                items.add(item.getName().toString());
            }
            try {
                this.enableScheduledBackups(prefix, pattern, frequency, time, items);
            }
            catch (SchedulerException se) {
                Logs.APP_LOG.error((Object)"Unable to activate the automated backup schedule.", (Throwable)se);
            }
        }
    }

    private File createFile() {
        File backupDir = this.rootConfig.getBackupDir();
        String filename = this.suggestFilename();
        return new File(backupDir, filename);
    }

    @Override
    public String suggestFilename() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return "backup_" + format.format(new Date()) + ".zip";
    }

    private File sanitize(String name) {
        String string = name = name == null ? null : new File(name).getName();
        if (Strings.isNullOrEmpty((String)name)) {
            return this.createFile();
        }
        return new File(this.rootConfig.getBackupDir(), name);
    }

    @Override
    public File createBackupAtLocation(final File archive, final Collection<String> selectedItems, final Map<String, String> params, final ProgressMonitor monitor) throws IOException {
        return this.maintenanceManager.doMaintenance("Creating a backup.", new MaintenanceTask<File, IOException>(){

            @Override
            public File perform() throws IOException {
                return BackupManagerImpl.this.createBackup(archive, selectedItems, params, monitor, new Object());
            }
        });
    }

    @Override
    public File createBackupWithName(String archive, Collection<String> selectedItems, Map<String, String> params, ProgressMonitor monitor) throws IOException {
        File file = this.sanitize(archive);
        return this.createBackupAtLocation(file, selectedItems, params, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File returnAndCreateBackupWithName(String fname, final Collection<String> selectedItems, final Map<String, String> params, ProgressMonitor monitor) throws InterruptedException {
        Object mutex;
        final File archive = this.sanitize(fname);
        final AtomicBoolean running = new AtomicBoolean(false);
        Object object = mutex = new Object();
        synchronized (object) {
            this.executorService.getExecutor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        running.set(true);
                        BackupManagerImpl.this.maintenanceManager.doMaintenance("Creating a backup.", new MaintenanceTask<Void, Exception>(){

                            @Override
                            public Void perform() throws Exception {
                                BackupManagerImpl.this.createBackup(archive, selectedItems, params, new MessageLoggingProgressMonitor(Logs.APP_LOG), mutex);
                                return null;
                            }
                        });
                    }
                    catch (Throwable e2) {
                        Logs.APP_LOG.warn((Object)"Backup failed.", e2);
                        if (e2 instanceof Error) {
                            throw (Error)e2;
                        }
                        throw new RuntimeException(e2);
                    }
                    finally {
                        Object object = mutex;
                        synchronized (object) {
                            mutex.notifyAll();
                        }
                    }
                }
            });
            while (!running.get()) {
                mutex.wait();
            }
        }
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized File createBackup(File file, Collection<String> selectedItems, Map<String, String> params, ProgressMonitor monitor, Object mutex) throws IOException {
        BufferedOutputStream out = null;
        final File archive = file == null ? this.createFile() : file;
        final AtomicReference<BackupStatus.State> state = new AtomicReference<BackupStatus.State>(BackupStatus.State.RUNNING);
        boolean quietMode = Boolean.parseBoolean(params.get("quiet"));
        final StoringProgressMonitor sink = quietMode ? new StoringProgressMonitor() : new StoringProgressMonitor(monitor);
        try {
            String message;
            BackupItem item;
            String name;
            final AtomicReference<Object> currentItemName = new AtomicReference<Object>(null);
            final ArrayList<String> completedItems = new ArrayList<String>();
            final LinkedHashMap<String, BackupItem> pendingItems = new LinkedHashMap<String, BackupItem>();
            this.status = new BackupStatus(){

                @Override
                public BackupStatus.State getState() {
                    return (BackupStatus.State)((Object)state.get());
                }

                @Override
                public File getFile() {
                    return archive;
                }

                @Override
                public List<Message> getOutput() {
                    return sink.getMessages();
                }

                @Override
                public String getCurrentItem() {
                    return (String)currentItemName.get();
                }

                @Override
                public Collection<String> getCompletedItems() {
                    return completedItems;
                }

                @Override
                public Collection<String> getPendingItems() {
                    return pendingItems.keySet();
                }

                @Override
                public void cancel() {
                }
            };
            Logs.APP_LOG.info((Object)"Beginning backup process");
            IOHelper.mkdirs(archive.getParentFile());
            IOHelper.createNewFile(archive);
            new FileSystemUtils().privatise(archive);
            out = new BufferedOutputStream(new FileOutputStream(archive));
            ZipOutputStream zos = new ZipOutputStream((OutputStream)new BufferedOutputStream(out));
            if (params.containsKey("compression")) {
                Logs.APP_LOG.info((Object)("Using custom ZIP compression level " + params.get("compression")));
                zos.setLevel(Integer.parseInt(params.get("compression")));
            }
            for (Map.Entry entry : items.entrySet()) {
                name = (String)entry.getKey();
                item = (BackupItem)entry.getValue();
                if (!item.isMandatory() && !selectedItems.contains(name)) continue;
                pendingItems.put(name, item);
            }
            Iterator iterator = mutex;
            synchronized (iterator) {
                mutex.notifyAll();
            }
            sink.update(new Message("Starting Backup ..."));
            for (Map.Entry entry : new LinkedHashSet(pendingItems.entrySet())) {
                name = (String)entry.getKey();
                currentItemName.set(name);
                item = (BackupItem)entry.getValue();
                pendingItems.remove(name);
                sink.update(new Message("Backing up " + name + "..."));
                item.getSaver(this.beanFactory).backup(zos, sink, params);
                completedItems.add(name);
                currentItemName.set(null);
            }
            this.addMetaData(zos, sink);
            zos.finish();
            zos.flush();
            state.set(BackupStatus.State.COMPLETED);
            if (sink.hasWarnings()) {
                message = "Backup completed with warnings in: " + archive.getAbsolutePath();
                sink.update(new Message(message));
                List<Message> list = sink.getWarnings();
                sink.update(new Message("Warnings:"));
                for (Message w2 : list) {
                    sink.update(new Message("- " + w2.getMessage()));
                }
            } else {
                message = "Backup completed in: " + archive.getAbsolutePath();
                sink.update(new Message(message));
            }
            Logs.APP_LOG.info((Object)message);
            if (state.get() == BackupStatus.State.RUNNING) {
                state.set(BackupStatus.State.ERROR);
            }
        }
        catch (IOException ioe) {
            try {
                sink.update(Message.newWarning(ioe));
                sink.update(new Message("Backup failed"));
                throw ioe;
                catch (Throwable re) {
                    sink.update(Message.newWarning(re));
                    sink.update(new Message("Backup failed"));
                    if (!(re instanceof RuntimeException)) throw new RuntimeException(re);
                    throw (RuntimeException)re;
                }
            }
            catch (Throwable throwable) {
                if (state.get() == BackupStatus.State.RUNNING) {
                    state.set(BackupStatus.State.ERROR);
                }
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return archive;
    }

    private void addMetaData(ZipOutputStream zos, StoringProgressMonitor monitor) throws IOException {
        Properties props = new Properties();
        props.put("product", AppConfig.getProductName());
        props.put("version", this.version.getReleaseNum());
        props.put("build", this.version.getBuildNumber());
        props.put("builddate", this.version.getBuildDate());
        props.put("created", new Date().toString());
        monitor.update(new Message("Writing backup meta data..."));
        ZipEntry entry = new ZipEntry("backup.properties");
        zos.putNextEntry(entry);
        props.store((OutputStream)zos, null);
    }

    @Override
    public BackupStatus getStatus() {
        return this.status;
    }

    @Override
    public synchronized ScheduledBackupJob enableScheduledBackups(final String prefix, final String datePattern, final BackupFrequency frequency, final String time, Collection<String> items) throws SchedulerException {
        if (this.scheduledJob != null) {
            this.scheduledJob.cancel();
        }
        try {
            this.writeSchedule(prefix, datePattern, frequency, time, items);
        }
        catch (IOException ioe) {
            throw new SchedulerException("Error saving backup schedule.", (Exception)ioe);
        }
        try {
            this.quartzManager.scheduleCronJob("scheduledBackupJob", "system", BackupJob.class, BackupManagerImpl.toCronExpression(time, frequency), true);
        }
        catch (ParseException pe) {
            throw new SchedulerException("Unexpected error generating cronjob expression.", (Exception)pe);
        }
        final HashSet<String> backupItems = new HashSet<String>(items);
        this.scheduledJob = new ScheduledBackupJob(){
            boolean canceled = false;

            @Override
            public String getPrefix() {
                return prefix;
            }

            @Override
            public String getDatePattern() {
                return datePattern;
            }

            @Override
            public Collection<String> getItems() {
                return backupItems;
            }

            @Override
            public String getTime() {
                return time;
            }

            @Override
            public BackupFrequency getFrequency() {
                return frequency;
            }

            @Override
            public void cancel() {
                if (!this.canceled) {
                    try {
                        BackupType.Schedule schedule;
                        BackupManagerImpl.this.quartzManager.deleteJob("scheduledBackupJob", "system");
                        BackupManagerImpl.this.scheduledJob = null;
                        ConfigDocument.Config cfg = BackupManagerImpl.this.rootConfig.getConfig();
                        if (cfg.isSetBackup() && (schedule = cfg.getBackup().getSchedule()) != null) {
                            schedule.setEnabled(false);
                            BackupManagerImpl.this.rootConfig.saveConfig();
                        }
                        this.canceled = true;
                    }
                    catch (SchedulerException se) {
                        Logs.APP_LOG.error((Object)"Error canceling the scheduled backup task.", (Throwable)se);
                    }
                    catch (IOException ioe) {
                        Logs.APP_LOG.error((Object)"Error canceling the scheduled backup task.", (Throwable)ioe);
                    }
                }
            }
        };
        return this.scheduledJob;
    }

    private void writeSchedule(String prefix, String datePattern, BackupFrequency frequency, String time, Collection<String> itemNames) throws IOException {
        ConfigDocument.Config cfg = this.rootConfig.getConfig();
        String existingPath = null;
        if (cfg.isSetBackup() && cfg.getBackup().getSchedule() != null && cfg.getBackup().getSchedule().isSetPath()) {
            existingPath = cfg.getBackup().getSchedule().getPath();
        }
        BackupType bt = BackupType.Factory.newInstance();
        BackupType.Schedule schedule = bt.addNewSchedule();
        schedule.setEnabled(true);
        if (!Strings.isNullOrEmpty(existingPath)) {
            schedule.setPath(existingPath);
        }
        schedule.setPrefix(prefix);
        schedule.setDatePattern(datePattern);
        schedule.setFrequency(BackupFrequencyType.Enum.forString(frequency.name()));
        schedule.setTime(time);
        BackupType.Schedule.Items items = schedule.addNewItems();
        for (String item : new HashSet<String>(itemNames)) {
            items.addNewItem().setName(BackupItemType.Enum.forString(item));
        }
        cfg.setBackup(bt);
        this.rootConfig.saveConfig();
    }

    @Override
    public ScheduledBackupJob getScheduledBackupJob() {
        return this.scheduledJob;
    }

    protected static String toCronExpression(String HHmm, BackupFrequency frequency) throws IllegalArgumentException {
        if (HHmm == null || HHmm.split(":").length != 2) {
            throw new IllegalArgumentException("Invalid time string: " + HHmm);
        }
        if (frequency == null) {
            throw new IllegalArgumentException("Frequency was null");
        }
        String hours = HHmm.split(":")[0];
        String minutes = HHmm.split(":")[1];
        return String.format("0 %s %s %s", minutes, hours, frequency.getCronExpression());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
    }
}

