/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration;

import com.atlassian.crucible.migration.BackupManager;
import com.atlassian.crucible.migration.MessageLoggingProgressMonitor;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.BackupType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class BackupJob
implements Job {
    public static final String JOB_NAME = "scheduledBackupJob";
    private BackupManager backupManager;
    private RootConfig rootConfig;

    @Autowired
    public void setBackupManager(BackupManager backupManager) {
        this.backupManager = backupManager;
    }

    @Autowired
    public void setRootConfig(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        BackupType.Schedule schedule;
        Logger anonLogger = Logs.APP_LOG;
        String ndc = "backup-" + System.currentTimeMillis();
        ConfigDocument.Config cfg = this.rootConfig.getConfig();
        if (cfg.isSetBackup() && (schedule = cfg.getBackup().getSchedule()) != null && schedule.getEnabled()) {
            String prefix = schedule.getPrefix();
            String date = Strings.isNullOrEmpty((String)schedule.getDatePattern()) ? "" : new SimpleDateFormat(schedule.getDatePattern()).format(new Date());
            HashSet<String> items = new HashSet<String>();
            for (BackupType.Schedule.Items.Item item : schedule.getItems().getItemArray()) {
                items.add(item.getName().toString());
            }
            try {
                NDC.push((String)ndc);
                Logs.APP_LOG.info((Object)"commencing scheduled backup...");
                File backupFile = this.backupManager.createBackupWithName(prefix + date + ".zip", items, Collections.emptyMap(), new MessageLoggingProgressMonitor(anonLogger));
                Logs.APP_LOG.info((Object)("scheduled backup complete. Written to " + backupFile.getCanonicalPath()));
            }
            catch (Throwable e2) {
                Logs.APP_LOG.error((Object)("Error performing backup: " + e2.getMessage()));
            }
            finally {
                NDC.pop();
            }
        }
    }
}

