/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.maintenance;

import com.atlassian.crucible.maintenance.FecruMaintenanceManager;
import com.atlassian.crucible.maintenance.MaintenanceTask;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.logging.Logs;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.springframework.stereotype.Component;

@Component(value="maintenanceManager")
@AvailableToPlugins
public class MaintenanceManager
implements FecruMaintenanceManager {
    private static final String DEFAULT_MESSAGE = "It looks like you caught us doing maintenance. Please try again in a bit.";
    private String message = "It looks like you caught us doing maintenance. Please try again in a bit.";
    private AtomicInteger counter = new AtomicInteger();

    public MaintenanceManager() {
        Logs.APP_LOG.debug((Object)"Registering Maintenance MBean");
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("com.atlassian.crucible.maintenance:type=MaintenanceMBeanImpl");
            if (server.isRegistered(name)) {
                server.unregisterMBean(name);
            }
            server.registerMBean(new Maintenance(), name);
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"Unable to register the maintenance page MBean.", (Throwable)e2);
        }
    }

    public String getMessage() {
        return this.message == null ? DEFAULT_MESSAGE : this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public boolean isDownForMaintenance() {
        return this.counter.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T doMaintenance(String message, MaintenanceTask<T, E> task) throws E {
        this.setMessage(message);
        this.setDownForMaintenance(true);
        try {
            T t2 = task.perform();
            return t2;
        }
        finally {
            this.setDownForMaintenance(false);
            this.setMessage(null);
        }
    }

    public void setDownForMaintenance(boolean down) {
        if (down) {
            this.counter.incrementAndGet();
        } else {
            this.counter.decrementAndGet();
        }
    }

    public class Maintenance
    implements MaintenanceMBean {
        @Override
        public String getMessage() {
            return MaintenanceManager.this.message;
        }

        @Override
        public void setMessage(String message) {
            MaintenanceManager.this.message = message;
        }

        @Override
        public boolean isDownForMaintenance() {
            return MaintenanceManager.this.isDownForMaintenance();
        }

        @Override
        public void setDownForMaintenance(boolean down) {
            MaintenanceManager.this.setDownForMaintenance(down);
        }
    }

    public static interface MaintenanceMBean {
        public String getMessage();

        public void setMessage(String var1);

        public boolean isDownForMaintenance();

        public void setDownForMaintenance(boolean var1);
    }
}

