/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.fisheye;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchAction;
import com.cenqua.fisheye.syntax.MatchPredicate;
import com.cenqua.fisheye.syntax.RegexpMatchRule;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionGenerator;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrucibleProjectHighlighter
extends SyntaxDefinition {
    private List<String> cachedProjectCodes = null;
    private SyntaxDefinition cachedDef = null;
    private final ProjectManager projectManager;
    private ReviewManager reviewManager;
    private final RootConfig rootConfig;

    @Autowired
    public CrucibleProjectHighlighter(ProjectManager projectManager, ReviewManager reviewManager, RootConfig rootConfig) {
        super("Crucible Linker");
        this.reviewManager = reviewManager;
        this.projectManager = projectManager;
        this.rootConfig = rootConfig;
    }

    @Override
    public void generateRegions(InputState input, RegionList outputRegions) {
        this.getDef().generateRegions(input, outputRegions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyntaxDefinition getDef() {
        List<String> codes = CrucibleFilter.hasContext() ? CrucibleFilter.getAllProjectCodes() : this.getAllProjectKeys();
        CrucibleProjectHighlighter crucibleProjectHighlighter = this;
        synchronized (crucibleProjectHighlighter) {
            if (this.cachedProjectCodes == null || !this.cachedProjectCodes.equals(codes)) {
                SyntaxDefinition syntaxDefinition = new SyntaxDefinition("CrucibleProjectHighlighterDef");
                StringBuilder projectKeysRegex = new StringBuilder();
                if (codes.isEmpty()) {
                    projectKeysRegex.append("CR");
                } else {
                    String sep = "";
                    for (String code : codes) {
                        projectKeysRegex.append(sep);
                        projectKeysRegex.append(Pattern.quote(code));
                        sep = "|";
                    }
                }
                RegexpMatchRule mr = new RegexpMatchRule("(" + projectKeysRegex.toString() + ")-\\d{1,9}", 2);
                mr.setPredicate(new MatchPredicate(){

                    @Override
                    public boolean checkMatch(InputState state, Map<String, Region> matchRegions) {
                        Region r0 = matchRegions.get("0");
                        return r0 != null && CrucibleProjectHighlighter.this.reviewManager.reviewExists(state.getSubSequence(r0).toString());
                    }
                });
                syntaxDefinition.addMatchRule(mr);
                MatchAction matchAction = new MatchAction();
                mr.setAction(matchAction);
                RegionGenerator regionGenerator = new RegionGenerator();
                matchAction.addRegionGenerator(regionGenerator);
                regionGenerator.setProperty("href", this.rootConfig.getSiteURL() + "/cru/${0}");
                regionGenerator.setProperty("type", "crulink");
                regionGenerator.setProperty("crulink", "${0}");
                this.cachedProjectCodes = codes;
                this.cachedDef = syntaxDefinition;
            }
        }
        return this.cachedDef;
    }

    private List<String> getAllProjectKeys() {
        return this.projectManager.getAllCurrentAndHistoricalProjectKeys();
    }
}

