/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.filters;

import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.fisheye.scm.SCMSource;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CrucibleFilter
implements Filter {
    private static final ThreadLocal<Context> CONTEXT = new ThreadLocal();

    public static Context getContext() {
        Context ctx = CONTEXT.get();
        if (ctx == null) {
            throw new IllegalStateException("Context not available, filter already exited");
        }
        return ctx;
    }

    public static void setContext(Context c2) {
        CONTEXT.set(c2);
    }

    public static boolean hasContext() {
        return CONTEXT.get() != null;
    }

    public static HttpServletRequest getRequest() {
        return CrucibleFilter.getContext().request;
    }

    public static HttpServletResponse getResponse() {
        return CrucibleFilter.getContext().response;
    }

    public static Map<Pair<String, Principal>, Source> getSourceCache() {
        if (!CrucibleFilter.hasContext()) {
            return null;
        }
        Context context = CrucibleFilter.getContext();
        if (context.sourceCache == null) {
            context.sourceCache = new HashMap();
        }
        return context.sourceCache;
    }

    public static Map<Pair<Principal, SCMRepository>, SCMSource> getSCMSourceCache() {
        if (!CrucibleFilter.hasContext()) {
            return null;
        }
        Context context = CrucibleFilter.getContext();
        if (context.scmSourceCache == null) {
            context.scmSourceCache = new HashMap();
        }
        return context.scmSourceCache;
    }

    public static List<String> getAllProjectCodes() {
        return CrucibleFilter.getContext().getAllProjectCodes();
    }

    public static String getSiteURL() {
        return ServletUtils.getBaseUrl(CrucibleFilter.getRequest());
    }

    public static Source getSource(String sourceName) {
        return CrucibleFilter.getContext().getSource(sourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Disposer.pushThreadInstance();
        try {
            Context oldContext = CONTEXT.get();
            try {
                CrucibleFilter.setContext(new Context(servletRequest, servletResponse));
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                Context currentContext = CONTEXT.get();
                if (currentContext != null && oldContext == null) {
                    HibernateUtil.commitAllTransactions();
                    HibernateUtil.closeSession();
                }
                CrucibleFilter.setContext(oldContext);
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public static class Context {
        public final HttpServletRequest request;
        public final HttpServletResponse response;
        private List<String> projectCodes;
        private SourceFactory sourceFactory;
        private Map<Pair<String, Principal>, Source> sourceCache;
        private Map<Pair<Principal, SCMRepository>, SCMSource> scmSourceCache;

        public Context(ServletRequest req, ServletResponse resp) {
            this.request = (HttpServletRequest)req;
            this.response = (HttpServletResponse)resp;
        }

        public Source getSource(String sourceName) {
            return this.getSourceFactory().getSource(sourceName, TotalityFilter.getCurrentPrincipal());
        }

        private SourceFactory getSourceFactory() {
            if (this.sourceFactory == null) {
                this.sourceFactory = (SourceFactory)SpringContext.getComponent("sourceFactory");
            }
            return this.sourceFactory;
        }

        public List<String> getAllProjectCodes() {
            if (this.projectCodes == null) {
                ProjectManager projectManager = (ProjectManager)SpringContext.getComponent("projectManager");
                this.projectCodes = projectManager.getAllCurrentAndHistoricalProjectKeys();
            }
            return this.projectCodes;
        }
    }
}

