/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.CrucibleChangeSetsHelper;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="crucibleChangeSetsHelper")
@Scope(value="prototype")
public class SimpleCrucibleChangeSetsHelper
implements CrucibleChangeSetsHelper {
    private final EffectiveUserProvider effectiveUserProvider;
    private final SourceFactory sourceFactory;
    private boolean sizeChecked;
    public final Set<ChangeSetPair> changeSets;

    @Autowired
    public SimpleCrucibleChangeSetsHelper(EffectiveUserProvider effectiveUserProvider, SourceFactory sourceFactory) {
        Preconditions.checkArgument((effectiveUserProvider != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sourceFactory != null ? 1 : 0) != 0);
        this.effectiveUserProvider = effectiveUserProvider;
        this.sourceFactory = sourceFactory;
        this.changeSets = new HashSet<ChangeSetPair>();
        this.sizeChecked = false;
    }

    @Override
    public void addCrucibleChangeSet(ChangeSetPair changeSetPair) {
        this.changeSets.add(changeSetPair);
        this.sizeChecked = false;
    }

    @Override
    public void clear() {
        this.changeSets.clear();
        this.sizeChecked = false;
    }

    @Override
    public void checkSize() throws ChangeSetContentTooLargeException, SourceException {
        if (this.sizeChecked) {
            return;
        }
        int totalCount = 0;
        int limit = CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT;
        for (ChangeSetPair pair : this.changeSets) {
            if ((totalCount += this.getNumberOfPaths(pair)) <= limit) continue;
            throw new ChangeSetContentTooLargeException(limit);
        }
        this.sizeChecked = true;
    }

    @Override
    public List<CrucibleChangeSet> createChangeSetsNoSizeCheck(boolean failOnNonExistent) throws SourceException {
        ArrayList<CrucibleChangeSet> ret = new ArrayList<CrucibleChangeSet>(this.changeSets.size());
        for (ChangeSetPair csp : this.changeSets) {
            CrucibleChangeSet changeSet = this.getChangeSetNoSizeCheck(csp);
            this.addOrFailIfRequested(failOnNonExistent, ret, csp, changeSet);
        }
        return ret;
    }

    @Override
    public List<CrucibleChangeSet> createChangeSets(boolean failOnNonExistent) throws SourceException, ChangeSetContentTooLargeException {
        this.checkSize();
        ArrayList<CrucibleChangeSet> ret = new ArrayList<CrucibleChangeSet>(this.changeSets.size());
        for (ChangeSetPair csp : this.changeSets) {
            CrucibleChangeSet changeSet = this.getChangeSet(csp);
            this.addOrFailIfRequested(failOnNonExistent, ret, csp, changeSet);
        }
        return ret;
    }

    private void addOrFailIfRequested(boolean failOnNonExistent, List<CrucibleChangeSet> ret, ChangeSetPair csp, CrucibleChangeSet changeSet) {
        if (null != changeSet) {
            ret.add(changeSet);
        } else if (failOnNonExistent) {
            throw new IllegalArgumentException("Changeset id '" + csp.getCsid() + "' does not exist in repository " + csp.getRepository());
        }
    }

    private CrucibleChangeSet getChangeSetNoSizeCheck(ChangeSetPair csp) throws SourceException {
        Source s2 = this.getUsableSource(csp);
        return s2.getChangeSet(csp.getCsid(), true);
    }

    private CrucibleChangeSet getChangeSet(ChangeSetPair csp) throws SourceException, ChangeSetContentTooLargeException {
        Source s2 = this.getUsableSource(csp);
        return s2.getChangeSet(csp.getCsid());
    }

    private Source getUsableSource(ChangeSetPair csp) throws SourceException {
        String repository = csp.getRepository();
        Source s2 = this.getSource(repository);
        this.checkSourceUsable(repository, s2);
        return s2;
    }

    private int getNumberOfPaths(ChangeSetPair csp) throws SourceException, ChangeSetContentTooLargeException {
        Source s2 = this.getUsableSource(csp);
        return s2.getChangeSetRevisionCount(csp.getCsid());
    }

    private void checkSourceUsable(String repository, Source s2) throws SourceException {
        if (null == s2) {
            throw new SourceException("Repository '" + repository + "' does not exist.");
        }
        if (!s2.isAvailable()) {
            throw new SourceException("Repository " + repository + " is not available");
        }
        if (!s2.isChangesetCapable()) {
            throw new SourceException("Source " + s2.getName() + " does not support changesets.");
        }
    }

    Source getSource(String repository) {
        return this.sourceFactory.getSource(repository, this.effectiveUserProvider.getEffectivePrincipal());
    }
}

