/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.atlassian.crucible.explorers.RepositoryFileExplorerInfo;
import com.atlassian.fisheye.scm.DirTreeData;
import com.atlassian.fisheye.scm.FileExplorerInfo;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.FisheyeDirTreeData;
import java.util.ArrayList;
import java.util.List;

public class RepositoryRepositoryExplorer
implements RepositoryExplorer {
    private final FisheyeRepositoryExplorer fisheyeRepoExplorer;
    private final ContentManager contentManager;
    private final RepositorySource source;
    private DirTreeData dirTreeData;
    private Integer deletedFilesCount;

    public RepositoryRepositoryExplorer(ContentManager contentManager, RepositorySource source, RepositoryEngine repoEngine, Path lpath, WaybackSpec wbSpec, CookiePreferences userPreferences) throws DbException {
        this.contentManager = contentManager;
        this.source = source;
        this.fisheyeRepoExplorer = new FisheyeRepositoryExplorer(repoEngine, lpath, wbSpec, userPreferences);
    }

    @Override
    public DirTreeData getDirTreeData(Path rootPath, Path selectedPath, boolean noFiles) throws DbException {
        if (this.dirTreeData == null) {
            this.dirTreeData = FisheyeDirTreeData.create(this.fisheyeRepoExplorer, rootPath, selectedPath, noFiles);
        }
        return this.dirTreeData;
    }

    @Override
    public int getDeletedFilesCount() throws DbException {
        if (this.deletedFilesCount == null) {
            int count = 0;
            for (FileExplorerInfo file : this.getFiles()) {
                if (!file.isLatestRevisionDead()) continue;
                ++count;
            }
            this.deletedFilesCount = count;
        }
        return this.deletedFilesCount;
    }

    @Override
    public boolean isHideDeletedFiles() {
        return this.fisheyeRepoExplorer.isHideDeletedFiles();
    }

    @Override
    public List<FileExplorerInfo> getFiles() throws DbException {
        List<FisheyeRepositoryExplorer.FisheyeFileExplorerInfo> files = this.fisheyeRepoExplorer.getFiles();
        ArrayList<FileExplorerInfo> infos = new ArrayList<FileExplorerInfo>();
        for (FisheyeRepositoryExplorer.FisheyeFileExplorerInfo ffei : files) {
            FileRevision latest = ffei.getLatestRevision();
            CrucibleRevision latestCrucibleRevision = this.contentManager.makeCrucibleRevision(this.source.getName(), this.source.getFileRevisionInfo(latest));
            infos.add(new RepositoryFileExplorerInfo(this.source, latestCrucibleRevision, ffei));
        }
        return infos;
    }
}

