/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.FisheyeFileHistoryExplorer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoryFileHistoryExplorer
implements FileHistoryExplorer {
    private final FisheyeFileHistoryExplorer delegate;
    private Map<String, List<RevInfoKey>> infoMap;

    public RepositoryFileHistoryExplorer(FisheyeFileHistoryExplorer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Map<String, List<RevInfoKey>> getInfoMap() {
        if (this.infoMap == null) {
            this.infoMap = new HashMap<String, List<RevInfoKey>>();
            Map<String, Collection<FileRevision>> feInfoMap = this.delegate.getInfoMap();
            for (Map.Entry<String, Collection<FileRevision>> e2 : feInfoMap.entrySet()) {
                this.infoMap.put(e2.getKey(), this.convertRevisions(e2.getValue()));
            }
        }
        return this.infoMap;
    }

    private List<RevInfoKey> convertRevisions(Collection<FileRevision> revisions) {
        ArrayList<RevInfoKey> revInfoKeys = new ArrayList<RevInfoKey>();
        for (FileRevision ffr : revisions) {
            revInfoKeys.add(ffr.getRevInfoKey());
        }
        return revInfoKeys;
    }

    @Override
    public List<String> getBranchNames() {
        return this.delegate.getBranchNames();
    }
}

