/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.crucible.scm.RevisionKey;
import com.atlassian.fisheye.scm.FileExplorerInfo;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.WaybackSpec;

public class RepositoryFileExplorerInfo
implements FileExplorerInfo {
    private final RepositorySource source;
    private final FisheyeRepositoryExplorer.FisheyeFileExplorerInfo fisheyeFileExplorerInfo;
    private CrucibleRevision latestCrucibleRevision;

    public RepositoryFileExplorerInfo(RepositorySource source, CrucibleRevision latestCrucibleRevision, FisheyeRepositoryExplorer.FisheyeFileExplorerInfo fisheyeFileExplorerInfo) {
        this.source = source;
        this.latestCrucibleRevision = latestCrucibleRevision;
        this.fisheyeFileExplorerInfo = fisheyeFileExplorerInfo;
    }

    @Override
    public Path getPath() {
        return this.fisheyeFileExplorerInfo.getPath();
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public RevisionKey getLatestRevision() {
        return new RevisionKey(this.fisheyeFileExplorerInfo.getLatestRevision().getPath().getPath(), this.fisheyeFileExplorerInfo.getLatestRevision().getRevision());
    }

    @Override
    public boolean isLatestRevisionDead() {
        return this.fisheyeFileExplorerInfo.getLatestRevision().isDead();
    }

    @Override
    public int getLatestRevisionCrucibleId() {
        return this.latestCrucibleRevision.getId();
    }

    @Override
    public String getLatestRevisionBranch() {
        return this.fisheyeFileExplorerInfo.getLatestRevision().getBranch();
    }

    @Override
    public boolean isShowFisheyeLinks() {
        return !AppConfig.isCrucibleOnly();
    }

    @Override
    public FileHistoryExplorer getImmediateFileHistoryExplorer(WaybackSpec wb) {
        return this.getSource().getFileHistoryExplorer(this.fisheyeFileExplorerInfo.getLatestRevision().getRevInfoKey(), wb);
    }
}

