/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.atlassian.crucible.explorers.ChangeSetDO;
import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.FisheyeChangelogExplorer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RepositoryChangelogExplorer
implements ChangelogExplorer {
    private final RepositorySource source;
    private final FisheyeChangelogExplorer delegate;
    private final Review review;
    private CommitterUserMappingManager committerUserMappingManager;

    public RepositoryChangelogExplorer(RepositorySource source, FisheyeChangelogExplorer delegate, Review review, CommitterUserMappingManager committerUserMappingManager) {
        this.source = source;
        this.delegate = delegate;
        this.review = review;
        this.committerUserMappingManager = committerUserMappingManager;
    }

    @Override
    public List<ChangeSetDO> getChangesets() throws DbException {
        ArrayList<ChangeSetDO> changeSetDOs = new ArrayList<ChangeSetDO>();
        for (ChangeSet cs : this.delegate.getChangesets()) {
            changeSetDOs.add(this.buildChangeSetDO(cs));
        }
        return changeSetDOs;
    }

    private ChangeSetDO buildChangeSetDO(ChangeSet changeSet) throws DbException {
        int itemCount = changeSet.getRevisionInfosCount();
        ChangeSetDO.MetadataChange metadataChange = ChangeSetDO.MetadataChange.NONE;
        if (changeSet.isPartialMetadataChange()) {
            metadataChange = ChangeSetDO.MetadataChange.PARTIAL;
        } else if (changeSet.isMetadataOnlyChange()) {
            metadataChange = ChangeSetDO.MetadataChange.FULL;
        }
        return new ChangeSetDO(Collections.emptyList(), this.committerUserMappingManager, itemCount, changeSet.getId(), changeSet.getAuthor(), changeSet.getComment(), changeSet.getDateValue(), metadataChange, this.isFisheyeExplorer(), this.source, this.review);
    }

    @Override
    public String getNextInPast() {
        return this.delegate.getNextInPast();
    }

    @Override
    public String getNextInFuture() {
        return this.delegate.getNextInFuture();
    }

    @Override
    public boolean isNextInFutureIsInc() {
        return this.delegate.isNextInFutureIsInc();
    }

    @Override
    public boolean isNextInPastIsInc() {
        return this.delegate.isNextInPastIsInc();
    }

    @Override
    public boolean isFisheyeExplorer() {
        return true;
    }

    @Override
    public List<String> getCommitters() {
        return this.delegate.getCommitters();
    }

    @Override
    public void computeData(int perPage) throws DbException {
        this.delegate.computeData(perPage);
    }

    @Override
    public void setCommitters(List<String> committers) {
        this.delegate.setCommitters(committers);
    }

    @Override
    public void setFromChangeSetId(String fromChangeSetId) {
        this.delegate.setFromChangeSetId(fromChangeSetId);
    }

    @Override
    public void setFromChangeSetIdInc(boolean fromChangeSetIdInc) {
        this.delegate.setFromChangeSetIdInc(fromChangeSetIdInc);
    }

    @Override
    public void setToChangeSetId(String toChangeSetId) {
        this.delegate.setToChangeSetId(toChangeSetId);
    }

    @Override
    public void setToChangeSetIdInc(boolean toChangeSetIdInc) {
        this.delegate.setToChangeSetIdInc(toChangeSetIdInc);
    }
}

