/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.managers.DefaultContentManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Date;

public class ChangeSetItemDO {
    private final CrucibleRevision cruRev;
    private final boolean inThisReview;

    public ChangeSetItemDO(CrucibleRevision cruRev, boolean inThisReview) {
        this.cruRev = cruRev;
        this.inThisReview = inThisReview;
    }

    public int getId() {
        return this.cruRev.getId();
    }

    public CrucibleRevision getCrucibleRevision() {
        return this.cruRev;
    }

    public boolean isInThisIteration() {
        return this.inThisReview;
    }

    public boolean isMoved() {
        return ChangeSetItemDO.isTrue(this.cruRev.isMoved());
    }

    public boolean isCopied() {
        return ChangeSetItemDO.isTrue(this.cruRev.isCopied());
    }

    public boolean isAdded() {
        return ChangeSetItemDO.isTrue(this.cruRev.isAdded());
    }

    public boolean isDeleted() {
        return ChangeSetItemDO.isTrue(this.cruRev.isDeletion());
    }

    private static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    public boolean isDead() {
        return this.isDeleted();
    }

    public boolean isBinary() {
        return ChangeSetItemDO.isTrue(this.cruRev.isBinary());
    }

    public String getRevisionDisplayName() {
        return this.cruRev.getRevisionDisplayName();
    }

    public String getRevision() {
        return this.cruRev.getRevision();
    }

    public String getSourceName() {
        return this.cruRev.getSourceName();
    }

    public String getPath() {
        return this.cruRev.getPath();
    }

    public Path getFePath() {
        return this.cruRev.getFePath();
    }

    public String getAuthorName() {
        return this.cruRev.getAuthorName();
    }

    public String getFileType() {
        return this.cruRev.getFileType();
    }

    public Date getCommitDate() {
        return this.cruRev.getCommitDate();
    }

    public Integer getLinesAdded() {
        return DefaultContentManager.getIntegerDetail(this.cruRev, "linesAdded");
    }

    public Integer getLinesRemoved() {
        return DefaultContentManager.getIntegerDetail(this.cruRev, "linesRemoved");
    }

    public boolean isFEChangeSetItemDO() {
        return false;
    }

    public static class FEChangeSetItemDO
    extends ChangeSetItemDO {
        private final FileRevision fileRev;

        public FEChangeSetItemDO(FileRevision fileRev, CrucibleRevision cruRev, boolean inThisReview) {
            super(cruRev, inThisReview);
            this.fileRev = fileRev;
        }

        public String getDiffRevision() {
            RevInfoKey r2 = this.fileRev.getDiffRevision();
            return r2 == null ? null : this.fileRev.getDiffRevision().getRev();
        }

        @Override
        public boolean isFEChangeSetItemDO() {
            return true;
        }
    }
}

