/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.atlassian.crucible.activity.changeset.ChangeSetHolderLightScm;
import com.atlassian.crucible.explorers.ChangeSetItemDO;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.ChangesetReviewState;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.ChangeSetHolder;
import java.util.Date;
import java.util.List;

public class ChangeSetDO {
    private ChangeSetHolder changeSetHolder;
    private ChangeSetHolderLightScm changeSetHolderLightScm;
    private CommitterUserMappingManager committerUserMappingManager;
    private boolean allItemsInReview;
    private boolean someItemsInReview;
    private MetadataChange metadataChange;
    private final boolean showFisheyeLinks;
    private Source source;
    private Review review;
    private ChangesetReviewState csReviewState;
    private int totalSize;
    private String id;
    private String author;
    private String comment;
    private Date dateValue;

    public ChangeSetDO(List<ChangeSetItemDO> items, CommitterUserMappingManager committerUserMappingManager, int totalSize, String id, String author, String comment, Date dateValue, MetadataChange metadataChange, boolean showFisheyeLinks, Source source, Review review) {
        this.committerUserMappingManager = committerUserMappingManager;
        this.showFisheyeLinks = showFisheyeLinks;
        this.source = source;
        this.review = review;
        this.allItemsInReview = items.size() > 0;
        this.someItemsInReview = false;
        for (ChangeSetItemDO csido : items) {
            this.allItemsInReview = this.allItemsInReview && csido.isInThisIteration();
            this.someItemsInReview = this.someItemsInReview || csido.isInThisIteration();
        }
        this.someItemsInReview = this.someItemsInReview && !this.allItemsInReview;
        this.totalSize = totalSize;
        this.id = id;
        this.author = author;
        this.comment = comment;
        this.dateValue = dateValue;
        this.metadataChange = metadataChange;
    }

    public boolean isRepositorySource() {
        return this.source != null && this.source instanceof RepositorySource;
    }

    public ChangeSet getRepositoryChangeset() throws DbException {
        if (this.source != null && !this.isRepositorySource() && this.source.isAvailable()) {
            return null;
        }
        return ((RepositorySource)this.source).getRepoEngine().getRevisionCache().getChangeSet(this.id);
    }

    public ChangesetReviewState getCsReviewState() {
        if (this.csReviewState == null) {
            if (this.source != null && this.review != null && this.source instanceof RepositorySource) {
                try {
                    this.csReviewState = ((RepositorySource)this.source).getChangesetReviewState(this.id, this.review.getPermaId());
                }
                catch (Exception e2) {
                    Logs.APP_LOG.debug((Object)("EyeQL search failed. Falling back to old cs review state behaviour for cs: " + this.id));
                    this.csReviewState = this.makeCsReviewState();
                }
            } else {
                this.csReviewState = this.makeCsReviewState();
            }
        }
        return this.csReviewState;
    }

    private ChangesetReviewState makeCsReviewState() {
        if (this.allItemsInReview) {
            return ChangesetReviewState.FULL;
        }
        if (this.someItemsInReview) {
            return ChangesetReviewState.PARTIAL;
        }
        return ChangesetReviewState.NONE;
    }

    public boolean isAllItemsInReview() {
        return this.getCsReviewState() == ChangesetReviewState.FULL;
    }

    public boolean isSomeItemsInReview() {
        return this.getCsReviewState() == ChangesetReviewState.PARTIAL;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public boolean isShowFisheyeLinks() {
        return this.showFisheyeLinks;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public boolean isMetadataOnlyChange() {
        return this.metadataChange == MetadataChange.FULL;
    }

    public boolean isPartialMetadataChange() {
        return this.metadataChange == MetadataChange.PARTIAL;
    }

    public boolean isFishEyeChangeSet() {
        return this.source instanceof RepositorySource;
    }

    public ChangeSetHolder getChangeSetHolder() {
        if (this.changeSetHolder == null && this.source instanceof RepositorySource) {
            RepositorySource repoSource = (RepositorySource)this.source;
            RevisionCache<? extends ChangeSet> revisionCache = repoSource.getRepoEngine().getRevisionCache();
            RepositoryConfig repositoryConfig = repoSource.getRepositoryHandle().getCfg();
            this.changeSetHolder = new ChangeSetHolder(this.getRepositoryChangeset(), new ChangeSetHolder.Context(null, revisionCache.isCaseSensitive(), 15, Path.ROOT, this.getSourceName(), repositoryConfig.getRepositoryType(), revisionCache.getDefaultBranch()), repositoryConfig.isSupportsBranchFilter(), this.committerUserMappingManager);
        }
        return this.changeSetHolder;
    }

    public ChangeSetHolderLightScm getChangeSetHolderLightScm() {
        if (this.changeSetHolderLightScm == null) {
            this.changeSetHolderLightScm = new ChangeSetHolderLightScm(this.source.getName(), this.getAuthor(), this.getId(), this.getComment(), this.getDateValue());
        }
        return this.changeSetHolderLightScm;
    }

    public static enum MetadataChange {
        NONE,
        PARTIAL,
        FULL;

    }
}

