/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.event;

import com.atlassian.crucible.event.ReviewEventImpl;
import com.atlassian.crucible.event.ReviewItemRevisionDataChangedEvent;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemRevisionData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.cenqua.crucible.model.FRXRevision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReviewItemRevisionDataChangedEventImpl
extends ReviewEventImpl
implements ReviewItemRevisionDataChangedEvent {
    private List<ReviewItemRevisionData> addedRevisions = new ArrayList<ReviewItemRevisionData>();
    private List<ReviewItemRevisionData> removedRevisions = new ArrayList<ReviewItemRevisionData>();
    private final SPIUtils spiUtils;

    public ReviewItemRevisionDataChangedEventImpl(PermId<ReviewData> reviewPermId, UserData actioner, SPIUtils spiUtils) {
        super(reviewPermId, actioner);
        this.spiUtils = spiUtils;
    }

    public Collection<ReviewItemRevisionData> getRemovedRevisions() {
        return this.removedRevisions;
    }

    public Collection<ReviewItemRevisionData> getAddedRevisions() {
        return this.addedRevisions;
    }

    public void addAddedRevisions(Collection<FRXRevision> frxRevs) {
        for (FRXRevision rev : frxRevs) {
            this.addAddedRevisions(rev);
        }
    }

    private void addAddedRevisions(FRXRevision frxRev) {
        if (frxRev != null) {
            this.addedRevisions.add(this.spiUtils.createRevisionData(frxRev));
        }
    }

    public void addRemovedRevisions(Collection<FRXRevision> frxRevs) {
        for (FRXRevision rev : frxRevs) {
            this.addRemovedRevisions(rev);
        }
    }

    private void addRemovedRevisions(FRXRevision rev) {
        if (rev != null) {
            this.removedRevisions.add(this.spiUtils.createRevisionData(rev));
        }
    }
}

