/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.crucible.event.CommentUpdatedEvent;
import com.atlassian.crucible.event.ReviewCommentEventImpl;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.UserData;
import com.cenqua.crucible.model.Review;

public class CommentUpdatedEventImpl
extends ReviewCommentEventImpl
implements CommentUpdatedEvent {
    private final String oldCommentText;
    private final boolean wasDraft;
    private final boolean isDraft;

    public CommentUpdatedEventImpl(PermId<ReviewData> reviewPermId, UserData actioner, PermId<CommentData> commentPermId, String oldCommentText, boolean wasDraft, boolean isDraft, Review.ReviewType type) {
        super(reviewPermId, actioner, commentPermId, type);
        this.oldCommentText = oldCommentText;
        this.wasDraft = wasDraft;
        this.isDraft = isDraft;
    }

    public String getOldMessage() {
        return this.oldCommentText;
    }

    public boolean isWasDraft() {
        return this.wasDraft;
    }

    @EventName
    public String calculateEventName() {
        String base;
        if (Review.ReviewType.REVIEW.equals((Object)this.type)) {
            base = "cru.review.";
        } else if (Review.ReviewType.SNIPPET.equals((Object)this.type)) {
            base = "cru.snippet.";
        } else {
            return null;
        }
        if (this.wasDraft && !this.isDraft) {
            return base + "comment.created";
        }
        if (!this.wasDraft && !this.isDraft) {
            return base + "comment.edited";
        }
        return null;
    }
}

