/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.configuration.metrics;

import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.configuration.metrics.MetricsConfigDef;
import com.atlassian.crucible.configuration.metrics.XMLValidationException;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.VariableSubstituter;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;

public class MetricsManager {
    public static final MetricsManager INSTANCE = new MetricsManager();
    private HashMap configCache = new HashMap();

    public Integer storeNewConfig(File file, boolean force) throws Exception {
        return this.storeNewConfig(IOHelper.copyFileToString(Charsets.UTF_8, file), force);
    }

    private String getParsedXML(String xml) throws XMLValidationException {
        MetricsConfig mc = new MetricsConfig();
        if (mc.parseXml(xml)) {
            return mc.getXML();
        }
        throw new XMLValidationException(mc.getErrors());
    }

    public Integer storeNewConfig(String xml, boolean force) throws XMLValidationException {
        Integer version = -1;
        String parsedXML = this.getParsedXML(xml);
        if (force || !this.sameAsLatest(parsedXML)) {
            MetricsConfigDef def = new MetricsConfigDef();
            def.setXml(parsedXML);
            HibernateUtil.currentSession().save((Object)def);
            version = def.getVersion();
        }
        return version;
    }

    public Integer replaceConfig(File file, Integer version) throws Exception {
        String xml = this.getParsedXML(IOHelper.copyFileToString(Charsets.UTF_8, file));
        MetricsConfigDef def = this.getConfigDef(version);
        if (def == null) {
            Logs.APP_LOG.warn((Object)"Existing version not found. Metrics not replaced.");
            return null;
        }
        def.setXml(xml);
        return version;
    }

    public MetricsConfigDef getConfigDef(Integer version) {
        if (version != null) {
            try {
                return (MetricsConfigDef)HibernateUtil.currentSession().load(MetricsConfigDef.class, (Serializable)version);
            }
            catch (ObjectNotFoundException onfe) {
                return null;
            }
        }
        return null;
    }

    public MetricsConfig getConfig(Integer version) {
        if (version != null) {
            if (!this.configCache.containsKey(version)) {
                try {
                    this.configCache.put(version, new MetricsConfig(this.getConfigDef(version).getXml(), version));
                }
                catch (ObjectNotFoundException onfe) {
                    return null;
                }
            }
            return (MetricsConfig)this.configCache.get(version);
        }
        return null;
    }

    public List getConfigs() {
        return HibernateUtil.currentSession().createQuery("from MetricsConfigDef").list();
    }

    public Integer getLatestVersion() {
        Session session = HibernateUtil.currentSession();
        Integer version = (Integer)session.createQuery("select max(id) from MetricsConfigDef").uniqueResult();
        if (version != null) {
            return version;
        }
        Properties feprops = new Properties();
        feprops.setProperty("fisheye.home", AppConfig.getAppHome().getAbsolutePath());
        String defaultMetrics = VariableSubstituter.substituteRefs((CharSequence)"${fisheye.home}/default-metrics-config.xml", feprops);
        File defaultMetricsXML = new File(defaultMetrics);
        if (defaultMetricsXML.exists()) {
            try {
                return this.storeNewConfig(defaultMetricsXML, true);
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"DefaultMetrics exists but there is a problem so I can't install it.", (Throwable)e2);
            }
        }
        return null;
    }

    private boolean sameAsLatest(String xml) {
        return StringUtils.equals((String)this.getConfigDef(this.getLatestVersion()).getXml(), (String)xml);
    }

    public void clearCache() {
        this.configCache.clear();
    }
}

