/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.configuration.metrics;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.cenqua.crucible.metrics1.Field;
import com.cenqua.crucible.metrics1.MetricsDocument;
import com.cenqua.fisheye.logging.Logs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class MetricsConfig {
    private Map<String, FieldDefinition> reviewFields = new HashMap<String, FieldDefinition>();
    private Map<String, FieldDefinition> commentFields = new HashMap<String, FieldDefinition>();
    private boolean parsed = false;
    private boolean valid = false;
    private ArrayList validationErrors = new ArrayList();
    private XmlOptions validationOptions = new XmlOptions();
    private MetricsDocument doc;

    public MetricsConfig() {
        this.setValidationOpts();
    }

    public MetricsConfig(String xml, Integer version) {
        this.setValidationOpts();
        this.config(xml, version);
    }

    private void setValidationOpts() {
        this.validationOptions.setErrorListener((Collection)this.validationErrors);
        this.validationOptions.setLoadLineNumbers();
        this.validationOptions.setDocumentSourceName("metrics");
    }

    public boolean isValid() {
        return this.valid;
    }

    public void config(String xml, Integer version) {
        if (!this.parsed) {
            this.valid = this.parseXml(xml);
        }
        if (this.valid) {
            MetricsDocument.Metrics metDoc = this.doc.getMetrics();
            if (metDoc.isSetReview()) {
                this.processFields(metDoc.getReview().getFieldArray(), this.reviewFields, "review", version);
            }
            if (metDoc.isSetComment()) {
                this.processFields(metDoc.getComment().getFieldArray(), this.commentFields, "comment", version);
            }
        } else {
            for (XmlError xmlError : this.validationErrors) {
                Logs.APP_LOG.error((Object)("Metrics Config error: " + xmlError));
            }
        }
    }

    public String getXML() {
        return this.doc.xmlText();
    }

    public boolean parseXml(String xml) {
        this.validationErrors.clear();
        this.parsed = true;
        try {
            XmlOptions opts = new XmlOptions();
            HashMap<String, String> nsMap = new HashMap<String, String>();
            nsMap.put("", MetricsDocument.type.getDocumentElementName().getNamespaceURI());
            opts.setLoadSubstituteNamespaces(nsMap);
            this.doc = MetricsDocument.Factory.parse(xml, opts);
        }
        catch (XmlException e2) {
            this.validationErrors.addAll(e2.getErrors());
            return false;
        }
        return this.doc.validate(this.validationOptions);
    }

    public List getErrors() {
        return this.validationErrors;
    }

    private void processFields(Field[] fields, Map<String, FieldDefinition> list, String scope, Integer version) {
        for (Field field : fields) {
            FieldDefinition fd = new FieldDefinition(field, scope, version);
            list.put(fd.getName(), fd);
        }
    }

    public FieldDefinition getField(String scope, String name) {
        if ("review".equals(scope)) {
            return this.reviewFields.get(name);
        }
        if ("comment".equals(scope)) {
            return this.commentFields.get(name);
        }
        return null;
    }

    public Map<String, FieldDefinition> getReviewFields() {
        return this.reviewFields;
    }

    public Map<String, FieldDefinition> getCommentFields() {
        return this.commentFields;
    }
}

