/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.CoalescingList;
import com.atlassian.crucible.activity.review.ReviewerJoinActivityItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class ReviewerJoinActivityItemList
implements CoalescingList<ReviewerJoinActivityItem> {
    private final Map<Key, ReviewerJoinActivityItem> items = new TreeMap<Key, ReviewerJoinActivityItem>(new KeyComparator());
    private final TimeZone tz;

    public ReviewerJoinActivityItemList(TimeZone tz) {
        this.tz = tz;
    }

    @Override
    public void add(ReviewerJoinActivityItem item) {
        Key state = new Key(item, this.tz);
        if (this.items.containsKey(state)) {
            this.items.get(state).consolidate(item, this.tz);
        } else {
            this.items.put(state, item);
        }
    }

    @Override
    public List<ReviewerJoinActivityItem> getItems(int size) {
        ArrayList<ReviewerJoinActivityItem> activityItems = new ArrayList<ReviewerJoinActivityItem>();
        Iterator<Key> it = this.items.keySet().iterator();
        while (it.hasNext() && activityItems.size() < size) {
            activityItems.add(this.items.get(it.next()));
        }
        return activityItems;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    public boolean contains(ReviewerJoinActivityItem item) {
        return this.items.containsValue(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    private static class Key {
        private ReviewerJoinActivityItem item;
        private TimeZone tz;

        public Key(ReviewerJoinActivityItem item, TimeZone tz) {
            this.item = item;
            this.tz = tz;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Key that = (Key)o2;
            return this.item.canConsolidate(that.item, this.tz);
        }

        public int hashCode() {
            return this.item.getConsolidateHashCode(this.tz);
        }

        public Date getDate() {
            return this.item.getDate();
        }

        public int getReviewId() {
            return this.item.getReview().getId();
        }
    }

    public static class KeyComparator
    implements Comparator<Key> {
        @Override
        public int compare(Key o1, Key o2) {
            int result;
            if (o1.equals(o2)) {
                result = 0;
            } else {
                result = o1.getDate().compareTo(o2.getDate());
                if (result == 0) {
                    result = o1.getReviewId() - o2.getReviewId();
                }
            }
            return result;
        }
    }
}

