/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.BaseReviewActivityItem;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.util.DateHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;

public class ReviewerJoinActivityItem
extends BaseReviewActivityItem {
    private final SortedSet<FecruUser> reviewers;
    private Review review;
    public static final String TYPE = "reviewer-join";
    private String key;
    private final boolean isJoin;
    private final FecruUser actor;
    private ConsolidateType consolidateType = ConsolidateType.NONE;
    private Comparator<FecruUser> REVIEWER_SORT = new Comparator<FecruUser>(){

        @Override
        public int compare(FecruUser o1, FecruUser o2) {
            int comp = o1.getDisplayName().toLowerCase(Locale.US).compareTo(o2.getDisplayName().toLowerCase(Locale.US));
            if (comp != 0) {
                return comp;
            }
            return o1.getUsername().compareTo(o2.getUsername());
        }
    };

    public ReviewerJoinActivityItem(FecruUser actor, FecruUser reviewer, Review review, Date date, boolean isJoin) {
        super(date);
        this.review = review;
        this.isJoin = isJoin;
        this.actor = actor;
        this.reviewers = new TreeSet<FecruUser>(this.REVIEWER_SORT);
        this.reviewers.add(reviewer);
        this.key = "reviewer-join:" + review.getId() + ":" + isJoin + ":" + actor.getId() + ":" + reviewer.getId();
    }

    public void addAllReviewers(Set<FecruUser> reviewers) {
        for (FecruUser rp : reviewers) {
            this.key = this.key + ":" + rp.getId();
        }
        this.reviewers.addAll(reviewers);
    }

    public void consolidate(ReviewerJoinActivityItem item, TimeZone tz) {
        if (!this.canConsolidate(item, tz)) {
            throw new IllegalArgumentException("Item " + this.getOpaqueId() + " cannot consolidate " + item.getOpaqueId());
        }
        if (this.isAllSelf() && item.isAllSelf()) {
            this.consolidateType = ConsolidateType.ALL_SELF;
        } else if (this.actor.getId().equals(item.getActor().getId())) {
            this.consolidateType = ConsolidateType.SAME_ACTOR;
        } else {
            throw new IllegalArgumentException("Item " + this.getOpaqueId() + " cannot consolidate " + item.getOpaqueId());
        }
        this.addAllReviewers(item.reviewers);
        if (this.reviewers.size() == 1) {
            this.consolidateType = ConsolidateType.NONE;
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getOpaqueId() {
        return this.key;
    }

    public Review getReview() {
        return this.review;
    }

    public Set<FecruUser> getReviewers() {
        return this.reviewers;
    }

    public List<FecruUser> getReviewerUsers() {
        ArrayList<FecruUser> users = new ArrayList<FecruUser>();
        for (FecruUser rp : this.reviewers) {
            users.add(rp);
        }
        return users;
    }

    public int getNumReviewers() {
        return this.reviewers.size();
    }

    public boolean isJoin() {
        return this.isJoin;
    }

    public boolean isConsolidateTypeNone() {
        return this.consolidateType == ConsolidateType.NONE;
    }

    public boolean isConsolidateTypeSameActor() {
        return this.consolidateType == ConsolidateType.SAME_ACTOR;
    }

    public boolean isConsolidateTypeAllSelf() {
        return this.consolidateType == ConsolidateType.ALL_SELF;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append((Object)this.consolidateType).append("\t");
        s2.append(this.isJoin ? " added " : " removed ");
        s2.append(this.getDate().toString());
        s2.append(" ").append(this.review.getPermaId());
        s2.append(" \tactor: ").append(this.actor.getUsername());
        s2.append(", [").append(this.reviewers.size()).append(" participants: ");
        String separator = "";
        for (FecruUser p2 : this.reviewers) {
            s2.append(separator).append(p2.getUsername());
            separator = ", ";
        }
        s2.append("] ");
        return s2.toString();
    }

    public FecruUser getActor() {
        return this.actor;
    }

    public FecruUser getActorUser() {
        return this.actor;
    }

    public boolean canConsolidate(ReviewerJoinActivityItem that, TimeZone tz) {
        if (this.getDate() == null || that.getDate() == null || !this.review.getId().equals(that.review.getId()) || this.isJoin != that.isJoin || !DateHelper.isSameDay(this.getDate(), that.getDate(), tz)) {
            return false;
        }
        switch (this.consolidateType) {
            case NONE: {
                switch (that.consolidateType) {
                    case NONE: {
                        return this.isAllSelf() && that.isAllSelf() || this.haveSameActor(that);
                    }
                    case SAME_ACTOR: {
                        return this.haveSameActor(that);
                    }
                    case ALL_SELF: {
                        return this.isAllSelf();
                    }
                }
                break;
            }
            case SAME_ACTOR: {
                switch (that.consolidateType) {
                    case NONE: 
                    case SAME_ACTOR: {
                        return this.haveSameActor(that);
                    }
                    case ALL_SELF: {
                        return false;
                    }
                }
                break;
            }
            case ALL_SELF: {
                switch (that.consolidateType) {
                    case NONE: {
                        return that.isAllSelf();
                    }
                    case SAME_ACTOR: {
                        return false;
                    }
                    case ALL_SELF: {
                        return true;
                    }
                }
            }
        }
        throw new IllegalStateException("Unknown consolidation type(s) " + (Object)((Object)this.consolidateType) + " " + (Object)((Object)that.consolidateType));
    }

    private boolean haveSameActor(ReviewerJoinActivityItem that) {
        return this.actor.getId().equals(that.actor.getId());
    }

    public boolean isAllSelf() {
        return this.isConsolidateTypeAllSelf() || this.isConsolidateTypeNone() && this.actor.getId().equals(this.reviewers.first().getId());
    }

    public int getConsolidateHashCode(TimeZone tz) {
        int result = 31 * this.review.getId();
        result = 31 * result + (this.getDate() != null ? DateHelper.getStartOfDay(this.getDate(), tz).hashCode() : 0);
        result = 31 * result + (this.isJoin ? 1 : 0);
        result = 31 * result + this.consolidateType.ordinal();
        result = 31 * result + this.actor.getId();
        return result;
    }

    private static enum ConsolidateType {
        NONE,
        SAME_ACTOR,
        ALL_SELF;

    }
}

