/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.CoalescingList;
import com.atlassian.crucible.activity.review.ReviewStateChangeActivityItem;
import com.atlassian.fisheye.activity.ActivityItemComparators;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.util.SortedList;
import java.util.List;

public class ReviewStateChangeActivityItemList
implements CoalescingList<ReviewStateChangeActivityItem> {
    private final SortedList<ReviewStateChangeActivityItem> items = new SortedList(ActivityItemComparators.desc());
    private static final String COMBINED_MESSAGE = "summarized and closed";

    @Override
    public void add(ReviewStateChangeActivityItem newItem) {
        if (!this.items.isEmpty()) {
            ReviewStateChangeActivityItem last = this.items.getLast();
            if (last.getReviewPermaId().equals(newItem.getReviewPermaId()) && this.stateMatches(last.getStateType(), newItem.getStateType())) {
                last.setVerbage(COMBINED_MESSAGE);
            } else {
                this.items.add(newItem);
            }
        } else {
            this.items.add(newItem);
        }
    }

    public void addAll(List<ReviewStateChangeActivityItem> list) {
        for (ReviewStateChangeActivityItem item : list) {
            this.add(item);
        }
    }

    private boolean stateMatches(StateManager.States a2, StateManager.States b2) {
        return a2 == StateManager.States.SUMMARIZE_STATE && b2 == StateManager.States.CLOSED_STATE || b2 == StateManager.States.SUMMARIZE_STATE && a2 == StateManager.States.CLOSED_STATE;
    }

    @Override
    public List<ReviewStateChangeActivityItem> getItems(int size) {
        if (size > this.items.size()) {
            size = this.items.size();
        }
        return this.items.subList(0, size);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    public boolean contains(ReviewStateChangeActivityItem item) {
        return this.items.contains(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

