/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.BaseReviewActivityItem;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.Date;

public class ReviewStateChangeActivityItem
extends BaseReviewActivityItem {
    private final Review review;
    private final String primaryState;
    private String verbage;
    private final StateManager.States stateType;
    public static final String TYPE = "review-stateChange";
    private final FecruUser user;
    private final String key;

    public ReviewStateChangeActivityItem(Review review, String primaryState, StateManager.States stateType, String verbage, Date date, FecruUser user, Integer stateChangeId) {
        super(date);
        this.review = review;
        this.primaryState = primaryState;
        this.verbage = verbage;
        this.stateType = stateType;
        this.user = user;
        this.key = "review-stateChange:" + review.getId() + ":" + stateChangeId;
    }

    public Review getReview() {
        return this.review;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getOpaqueId() {
        return this.key;
    }

    public String getReviewPermaId() {
        return this.review.getPermaId();
    }

    public Integer getReviewId() {
        return this.review.getId();
    }

    public String getPrimaryState() {
        return this.primaryState;
    }

    public StateManager.States getStateType() {
        return this.stateType;
    }

    public String getVerbage() {
        return this.verbage;
    }

    public FecruUser getUser() {
        return this.user;
    }

    @Override
    public String toString() {
        return this.review.getPermaId() + " ->" + this.primaryState + " " + this.getDate().toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ReviewStateChangeActivityItem that = (ReviewStateChangeActivityItem)o2;
        String reviewPermaId = this.getReviewPermaId();
        if (reviewPermaId != null ? !reviewPermaId.equals(that.getReviewPermaId()) : that.getReviewPermaId() != null) {
            return false;
        }
        if (this.primaryState != null ? !this.primaryState.equals(that.primaryState) : that.primaryState != null) {
            return false;
        }
        if (this.verbage != null ? !this.verbage.equals(that.verbage) : that.verbage != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.getReviewPermaId() != null ? this.getReviewPermaId().hashCode() : 0;
        result = 31 * result + (this.primaryState != null ? this.primaryState.hashCode() : 0);
        result = 31 * result + (this.verbage != null ? this.verbage.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }

    public void setVerbage(String s2) {
        this.verbage = s2;
    }
}

