/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.CoalescingList;
import com.atlassian.crucible.activity.review.ReviewCompletionActivityItem;
import com.cenqua.fisheye.util.DateHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class ReviewCompletionActivityItemList
implements CoalescingList<ReviewCompletionActivityItem> {
    private final Map<Key, ReviewCompletionActivityItem> items = new TreeMap<Key, ReviewCompletionActivityItem>(new KeyComparator());
    private final TimeZone tz;

    public ReviewCompletionActivityItemList(TimeZone tz) {
        this.tz = tz;
    }

    @Override
    public void add(ReviewCompletionActivityItem item) {
        Key state = new Key(item.getReview().getId(), item.isAllComplete(), item.getDate(), this.tz);
        if (this.items.containsKey(state)) {
            this.items.get(state).addAllParticipants(item.getParticipants());
        } else {
            this.items.put(state, item);
        }
    }

    @Override
    public List<ReviewCompletionActivityItem> getItems(int size) {
        ArrayList<ReviewCompletionActivityItem> activityItems = new ArrayList<ReviewCompletionActivityItem>();
        Iterator<Key> it = this.items.keySet().iterator();
        while (it.hasNext() && activityItems.size() < size) {
            activityItems.add(this.items.get(it.next()));
        }
        return activityItems;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    public boolean contains(ReviewCompletionActivityItem item) {
        return this.items.containsValue(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    private static class Key {
        private int reviewId;
        private boolean isAllComplete;
        private Date date;
        private TimeZone tz;

        private Key(int reviewId, boolean allComplete, Date date, TimeZone tz) {
            this.reviewId = reviewId;
            this.isAllComplete = allComplete;
            this.date = date;
            this.tz = tz;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Key that = (Key)o2;
            if (this.date == null || that.date == null) {
                return false;
            }
            if (!DateHelper.isSameDay(this.date, that.getDate(), this.tz)) {
                return false;
            }
            return this.reviewId == that.reviewId;
        }

        public int hashCode() {
            int result = 31 * this.reviewId;
            result = 31 * result + (this.date != null ? DateHelper.getStartOfDay(this.date, this.tz).hashCode() : 0);
            return result;
        }

        public int getId() {
            return this.reviewId;
        }

        public boolean isAllComplete() {
            return this.isAllComplete;
        }

        public Date getDate() {
            return this.date;
        }
    }

    public static class KeyComparator
    implements Comparator<Key> {
        @Override
        public int compare(Key o1, Key o2) {
            int result;
            if (o1.equals(o2)) {
                result = 0;
            } else {
                result = o1.date.compareTo(o2.date);
                if (result == 0) {
                    result = o1.reviewId - o2.reviewId;
                }
            }
            return result;
        }
    }
}

