/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.BaseReviewActivityItem;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.fisheye.logging.Logs;
import java.util.ArrayList;
import java.util.List;

public class ReviewCompletionActivityItem
extends BaseReviewActivityItem {
    private final List<ReviewParticipant> participants = new ArrayList<ReviewParticipant>();
    private Review review;
    public static final String TYPE = "review-completion";
    private String key;

    public ReviewCompletionActivityItem(ReviewParticipant participant, Review review) {
        super(participant.getCompletionStatusChangeDate());
        this.addParticipant(participant);
        this.review = review;
        this.key = "review-completion:" + review.getId() + ":" + participant.isAllComplete() + ":" + participant.getId();
    }

    public void addAllParticipants(List<ReviewParticipant> participants) {
        for (ReviewParticipant rp : participants) {
            this.key = this.key + ":" + rp.getId();
        }
        this.participants.addAll(participants);
    }

    private void addParticipant(ReviewParticipant participant) {
        this.participants.add(participant);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getOpaqueId() {
        return this.key;
    }

    public Review getReview() {
        return this.review;
    }

    public List<ReviewParticipant> getParticipants() {
        return this.participants;
    }

    public List<FecruUser> getParticipantUsers() {
        ArrayList<FecruUser> users = new ArrayList<FecruUser>();
        for (ReviewParticipant rp : this.participants) {
            users.add(rp.getUser());
        }
        return users;
    }

    public int getNumParticipants() {
        return this.participants.size();
    }

    public boolean isAllComplete() {
        if (this.participants.isEmpty()) {
            Logs.APP_LOG.warn((Object)"ReviewCompletionActivityItem constructed with no participants");
            return false;
        }
        return this.participants.get(0).isAllComplete();
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder("ReviewCompletion[id=" + this.review.getPermaId() + ", participants:");
        String separator = "";
        for (ReviewParticipant p2 : this.participants) {
            s2.append(separator).append(p2.getUser().getUsername());
            separator = ", ";
        }
        s2.append("]");
        return s2.toString();
    }
}

