/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.ProjectConstraint;
import com.atlassian.fisheye.activity.StarActivityConstraintBuilder;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.CommentStar;
import com.atlassian.fisheye.stars.model.ProjectStar;
import com.atlassian.fisheye.stars.model.ReviewStar;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarList;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.rep.DbException;
import java.util.List;

public class ProjectConstraintBuilder
implements StarActivityConstraintBuilder<ProjectConstraint> {
    private StarList stars = new StarList();
    private ProjectConstraint itemParams = new ProjectConstraint();
    private final ReviewManager reviewManager;
    private final CommentManager commentManager;

    public ProjectConstraintBuilder(ReviewManager reviewManager, CommentManager commentManager) {
        this.reviewManager = reviewManager;
        this.commentManager = commentManager;
    }

    @Override
    public ProjectConstraint getActivityItemParams() throws DbException {
        List projectStars = this.stars.getStarsOfType(StarType.PROJECT);
        for (Object star : projectStars) {
            this.itemParams.addProject(((ProjectStar)star).getProjectID());
        }
        List reviewStars = this.stars.getStarsOfType(StarType.REVIEW);
        for (ReviewStar star : reviewStars) {
            Review byId = this.reviewManager.getReviewById(star.getReviewId());
            if (byId == null) continue;
            this.itemParams.addReview(byId);
        }
        List commentStars = this.stars.getStarsOfType(StarType.COMMENT);
        for (CommentStar star : commentStars) {
            Comment comment = this.commentManager.getById(star.getCommentID());
            if (comment == null) continue;
            this.itemParams.addComment(this.commentManager.getById(star.getCommentID()));
        }
        return this.itemParams;
    }

    @Override
    public void addStars(List<Star> stars) {
        this.stars.addStars(stars);
    }

    @Override
    public void addStar(Star star) {
        this.stars.addStar(star);
    }
}

